/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileDescriptor fd = new FileDescriptor();

    public RandomAccessFile(File file, String string) throws IOException {
        this(file.getPath(), string);
    }

    public RandomAccessFile(String string, String string2) throws IOException {
        boolean bl;
        if (string2.equalsIgnoreCase("r")) {
            bl = false;
        } else if (string2.equalsIgnoreCase("rw")) {
            bl = true;
        } else {
            throw new IllegalArgumentException();
        }
        System.getSecurityManager().checkRead(string);
        if (bl) {
            System.getSecurityManager().checkWrite(string);
        }
        this.open(string, bl);
    }

    public native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public native long getFilePointer() throws IOException;

    public native long length() throws IOException;

    private native void open(String var1, boolean var2);

    public native int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = this.readBytes(byArray, n + n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() == 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    private native int readBytes(byte[] var1, int var2, int var3);

    public final char readChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)(n << 8 | n2);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.read(byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException();
        }
    }

    public final int readInt() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        return n << 24 | (n2 << 16) + (n3 << 8) + n4;
    }

    public final String readLine() throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            int n = this.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            stringBuffer.append((byte)n);
            if ((char)n == '\n') {
                bl = true;
            }
            if ((char)n != '\r') continue;
            long l = this.getFilePointer();
            int n2 = this.read();
            if (n2 == -1) {
                bl = true;
                continue;
            }
            if ((char)n2 == '\n') {
                stringBuffer.append((byte)n2);
                bl = true;
                continue;
            }
            this.seek(l);
        }
        return stringBuffer.toString();
    }

    public final long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        return ((long)n << 32) + ((long)n2 & 0xFFFFFFFFFFFFFFFFL);
    }

    public final short readShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n << 8 | n2);
    }

    public final String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            byte by = this.readByte();
            if ((by & 0x80) == 128) {
                char c;
                byte by2;
                if ((by & 0xE0) == 192) {
                    by2 = this.readByte();
                    if ((by2 & 0xC0) == 128) {
                        c = (char)(((by & 0x1F) << 6) + (by2 & 0x3F));
                        stringBuffer.append(c);
                        n2 += 2;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((by & 0xF0) == 224) {
                    by2 = this.readByte();
                    if ((by2 & 0xC0) == 128) {
                        c = this.readByte();
                        if ((c & 0xC0) == 128) {
                            char c2 = (char)(((by & 0xF) << 12) + ((by2 & 0x3F) << 6) + (c & 0x3F));
                            stringBuffer.append(c2);
                            n2 += 3;
                            continue;
                        }
                        throw new UTFDataFormatException();
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            stringBuffer.append((char)by);
            ++n2;
        }
        if (n2 > n) {
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return n << 8 | n2;
    }

    public native void seek(long var1) throws IOException;

    public int skipBytes(int n) throws IOException {
        long l = this.getFilePointer();
        this.seek(l + (long)n);
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public native void write(int var1) throws IOException;

    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)(cArray[i] & 0xFF);
        }
        this.write(byArray, 0, byArray.length);
    }

    private native void writeBytes(byte[] var1, int var2, int var3);

    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeChars(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        this.write(byArray, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    public final void writeUTF(String string) throws IOException {
        char[] cArray = string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byteArrayOutputStream.write(c);
                continue;
            }
            if (c <= '\u07ff') {
                byteArrayOutputStream.write(0xC0 | 0x3F & c >> 6);
                byteArrayOutputStream.write(0x80 | 0x3F & c);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | 0xF & c >> 12);
            byteArrayOutputStream.write(0x80 | 0x3F & c >> 6);
            byteArrayOutputStream.write(0x80 | 0x3F & c);
        }
        cArray = null;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 65535) {
            throw new UTFDataFormatException("String too long");
        }
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            try {
                this.writeShort(byArray.length);
                this.write(byArray, 0, byArray.length);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }
}

