/*
 * Decompiled with CFR 0.152.
 */
package kaffe.awt;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import kaffe.awt.FlavorConverter;

public abstract class ExportTransferable
implements Transferable,
ClipboardOwner {
    protected Object data;
    protected DataFlavor[] flavors;
    protected FlavorConverter[] converters;

    protected ExportTransferable(Object object, DataFlavor[] dataFlavorArray, FlavorConverter[] flavorConverterArray) {
        this.data = object;
        this.flavors = dataFlavorArray;
        this.converters = flavorConverterArray;
    }

    public byte[] getNativeData(String string) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!this.flavors[i].isMimeTypeEqual(string) || this.converters[i] == null) continue;
            return this.converters[i].exportObject(this.data);
        }
        return null;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!this.flavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.data))).concat(String.valueOf(']'));
    }
}

