/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager2 {
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int ACTUALSIZE = 3;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    Point offset = new Point();

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.comptable.put(component, ((GridBagConstraints)object).clone());
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    void adjustWeightsRelative(Container container) {
        int n;
        double d;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.sumWidths();
        int n7 = this.sumHeights();
        double d2 = 0.0;
        double d3 = 0.0;
        for (n3 = 0; n3 < this.columnWeights.length; ++n3) {
            if (!(this.columnWeights[n3] > 0.0)) continue;
            d2 += this.columnWeights[n3];
            ++n4;
        }
        for (n3 = 0; n3 < this.rowWeights.length; ++n3) {
            if (!(this.rowWeights[n3] > 0.0)) continue;
            d3 += this.rowWeights[n3];
            ++n5;
        }
        int n8 = container.insets.left + container.insets.right;
        int n9 = container.insets.top + container.insets.bottom;
        if (n4 > 0) {
            n2 = container.width - n6 - n8;
            for (n3 = 0; n3 < this.columnWeights.length; ++n3) {
                d = this.columnWeights[n3];
                if (d > 0.0) {
                    n = (int)(d / d2 * (double)n2);
                    int n10 = n3;
                    this.columnWidths[n10] = this.columnWidths[n10] + n;
                    d2 -= d;
                    n2 -= n;
                }
                if (d2 == 0.0) break;
            }
            if (n2 > 0) {
                int n11 = n3;
                this.columnWidths[n11] = this.columnWidths[n11] + n2;
            }
            this.offset.x = 0;
        } else {
            this.offset.x = (container.width - n6 - n8) / 2;
        }
        if (n5 > 0) {
            n2 = container.height - n7 - n9;
            for (n3 = 0; n3 < this.rowWeights.length; ++n3) {
                d = this.rowWeights[n3];
                if (d > 0.0) {
                    n = (int)(d / d3 * (double)n2);
                    int n12 = n3;
                    this.rowHeights[n12] = this.rowHeights[n12] + n;
                    d3 -= d;
                    n2 -= n;
                }
                if (d3 == 0.0) break;
            }
            if (n2 > 0) {
                int n13 = n3;
                this.rowHeights[n13] = this.rowHeights[n13] + n2;
            }
            this.offset.y = 0;
        } else {
            this.offset.y = (container.height - n7 - n9) / 2;
        }
    }

    int columnStart(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnWidths[i];
        }
        return n2;
    }

    void dumpDims() {
        System.out.print("\t");
        for (int i = 0; i < this.columnWidths.length; ++i) {
            System.out.print(String.valueOf(this.columnWidths[i]).concat(String.valueOf(" ")));
        }
        System.out.println();
        for (int i = 0; i < this.rowHeights.length; ++i) {
            System.out.println(this.rowHeights[i]);
        }
    }

    void dumpWeights() {
        System.out.print("\t");
        for (int i = 0; i < this.columnWeights.length; ++i) {
            System.out.print(String.valueOf(this.columnWeights[i]).concat(String.valueOf(" ")));
        }
        System.out.println();
        for (int i = 0; i < this.rowWeights.length; ++i) {
            System.out.println(this.rowWeights[i]);
        }
    }

    void getCellDims(Container container, int n) {
        Dimension dimension = this.getLayoutExtends(container);
        int n2 = -1;
        int n3 = 0;
        int n4 = container.getComponentCount();
        if (this.rowHeights == null || this.rowHeights.length != dimension.height) {
            this.rowHeights = new int[dimension.height];
        }
        if (this.columnWidths == null || this.columnWidths.length != dimension.width) {
            this.columnWidths = new int[dimension.width];
        }
        if (this.columnWeights == null || this.columnWeights.length != dimension.width) {
            this.columnWeights = new double[dimension.width];
        }
        if (this.rowWeights == null || this.rowWeights.length != dimension.height) {
            this.rowWeights = new double[dimension.height];
        }
        for (int i = 0; i < n4; ++i) {
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (gridBagConstraints == null) continue;
            Dimension dimension2 = n == 1 ? component.getMinimumSize() : component.getPreferredSize();
            n2 = gridBagConstraints.gridx == -1 ? ++n2 : gridBagConstraints.gridx;
            if (gridBagConstraints.gridy > -1) {
                n3 = gridBagConstraints.gridy;
            }
            int n5 = dimension2.width + gridBagConstraints.insets.left + gridBagConstraints.insets.right + 2 * gridBagConstraints.ipadx;
            int n6 = dimension2.height + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom + 2 * gridBagConstraints.ipady;
            int n7 = Math.max(gridBagConstraints.gridwidth, 1);
            int n8 = Math.max(gridBagConstraints.gridheight, 1);
            n5 /= n7;
            n6 /= n8;
            for (int j = 0; j < n7; ++j) {
                if (this.columnWidths[n2 + j] >= n5) continue;
                this.columnWidths[n2 + j] = n5;
            }
            if (this.columnWeights[n2 + n7 - 1] < gridBagConstraints.weightx) {
                this.columnWeights[n2 + n7 - 1] = gridBagConstraints.weightx;
            }
            for (int j = 0; j < n8; ++j) {
                if (this.rowHeights[n3 + j] >= n6) continue;
                this.rowHeights[n3 + j] = n6;
            }
            if (this.rowWeights[n3 + n8 - 1] < gridBagConstraints.weighty) {
                this.rowWeights[n3 + n8 - 1] = gridBagConstraints.weighty;
            }
            n2 += n7 - 1;
            if (gridBagConstraints.gridwidth != 0) continue;
            ++n3;
            n2 = -1;
        }
        if (n == 3) {
            this.adjustWeightsRelative(container);
        }
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.defaultConstraints;
        if (this.comptable.containsKey(component)) {
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int[][] getLayoutDimensions() {
        int[][] nArrayArray = new int[][]{this.columnWidths, this.rowHeights};
        return nArrayArray;
    }

    Dimension getLayoutExtends(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = container.getComponentCount();
        block8: for (int i = 0; i < n5; ++i) {
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (gridBagConstraints == null) continue;
            n3 = gridBagConstraints.gridx >= 0 ? gridBagConstraints.gridx : ++n3;
            if (gridBagConstraints.gridy >= 0) {
                n4 = gridBagConstraints.gridy;
            }
            switch (gridBagConstraints.gridwidth) {
                case 0: {
                    if (n < n3 + 1) {
                        n = n3 + 1;
                    }
                    n3 = -1;
                    ++n4;
                    break;
                }
                case -1: {
                    if (n >= n3 + 1) break;
                    n = n3 + 1;
                    break;
                }
                default: {
                    if (n >= (n3 += gridBagConstraints.gridwidth - 1) + 1) break;
                    n = n3 + 1;
                }
            }
            switch (gridBagConstraints.gridheight) {
                case -1: {
                    continue block8;
                }
                case 0: {
                    continue block8;
                }
                default: {
                    if (n3 == -1) continue block8;
                    n2 = Math.max(n2, n4 + gridBagConstraints.gridheight);
                }
            }
        }
        n2 = Math.max(n2, n4);
        return new Dimension(n, n2);
    }

    public Point getLayoutOrigin() {
        return this.offset;
    }

    public double[][] getLayoutWeights() {
        double[][] dArrayArray = new double[][]{this.columnWeights, this.rowWeights};
        return dArrayArray;
    }

    public void invalidateLayout(Container container) {
        this.layoutContainer(container);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets;
        int n = -1;
        int n2 = 0;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = new Rectangle();
        int n7 = container.getComponentCount();
        this.getCellDims(container, 3);
        for (int i = 0; i < n7; ++i) {
            int n8;
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (gridBagConstraints == null) continue;
            boolean bl = false;
            if (gridBagConstraints.gridy >= 0) {
                n2 = gridBagConstraints.gridy;
                n4 = this.rowStart(n2) + insets.top;
            }
            if (gridBagConstraints.gridx < 0) {
                ++n;
                if (n2 > rectangle.y) {
                    n += rectangle.x + rectangle.width;
                }
                n3 = this.columnStart(n) + insets.left;
            } else {
                n = gridBagConstraints.gridx;
                n3 = this.columnStart(n) + insets.left;
            }
            int n9 = gridBagConstraints.gridwidth;
            if (n9 == 0) {
                n9 = this.columnWidths.length - n;
                bl = true;
            } else if (n9 == -1) {
                n9 = this.columnWidths.length - n - 1;
            }
            int n10 = gridBagConstraints.gridheight;
            if (n10 == 0) {
                n10 = this.rowHeights.length - n2;
            } else if (n10 == -1) {
                n10 = this.rowHeights.length - n2 - 1;
            }
            n5 = 0;
            for (n8 = 0; n8 < n9; ++n8) {
                n5 += this.columnWidths[n++];
            }
            --n;
            n6 = 0;
            for (n8 = 0; n8 < n10; ++n8) {
                n6 += this.rowHeights[n2 + n8];
            }
            if (n10 > 1) {
                rectangle.setBounds(n, n2, n9, n10);
            } else if (n2 >= rectangle.y + rectangle.height) {
                rectangle.setBounds(0, 0, 0, 0);
            }
            Insets insets2 = gridBagConstraints.insets;
            if (gridBagConstraints.fill == 3) {
                component.setBounds(n3 + insets2.left + gridBagConstraints.ipadx + this.offset.x, n4 + insets2.top + gridBagConstraints.ipady + this.offset.y, n5 - insets2.left - insets2.right - 2 * gridBagConstraints.ipadx, n6 - insets2.top - insets2.bottom - 2 * gridBagConstraints.ipady);
            } else {
                int n11;
                int n12;
                int n13;
                int n14;
                Dimension dimension = component.getPreferredSize();
                if (gridBagConstraints.fill == 1) {
                    n14 = n3 + insets2.left + gridBagConstraints.ipadx + this.offset.x;
                    n13 = n5 - insets2.left - insets2.right - 2 * gridBagConstraints.ipadx;
                    n12 = dimension.height;
                    n11 = (gridBagConstraints.anchor & 0x20) > 0 ? n4 + n6 - dimension.height - gridBagConstraints.ipady - insets2.bottom + this.offset.y : ((gridBagConstraints.anchor & 0x10) > 0 ? n4 + (n6 - n12) / 2 + this.offset.y : n4 + gridBagConstraints.ipady + insets2.top + this.offset.y);
                } else if (gridBagConstraints.fill == 2) {
                    n11 = n4 + insets2.top + gridBagConstraints.ipady + this.offset.y;
                    n12 = n6 - insets2.top - insets2.bottom - 2 * gridBagConstraints.ipady;
                    n13 = dimension.width;
                    n14 = (gridBagConstraints.anchor & 2) > 0 ? n3 + n5 - n13 - gridBagConstraints.ipadx - insets2.right + this.offset.x : ((gridBagConstraints.anchor & 1) > 0 ? n3 + (n5 - n13) / 2 + this.offset.x : n3 + gridBagConstraints.ipadx + insets2.left + this.offset.x);
                } else {
                    n13 = dimension.width;
                    n12 = dimension.height;
                    n11 = (gridBagConstraints.anchor & 0x20) > 0 ? n4 + n6 - dimension.height - gridBagConstraints.ipady - insets2.bottom + this.offset.y : ((gridBagConstraints.anchor & 0x10) > 0 ? n4 + (n6 - n12) / 2 + this.offset.y : n4 + gridBagConstraints.ipady + insets2.top + this.offset.y);
                    n14 = (gridBagConstraints.anchor & 2) > 0 ? n3 + n5 - n13 - gridBagConstraints.ipadx - insets2.right + this.offset.x : ((gridBagConstraints.anchor & 1) > 0 ? n3 + (n5 - n13) / 2 + this.offset.x : n3 + gridBagConstraints.ipadx + insets2.left + this.offset.x);
                }
                component.setBounds(n14, n11, n13, n12);
            }
            if (!bl) continue;
            n = -1;
            n4 += n6;
            ++n2;
        }
    }

    public Point location(int n, int n2) {
        int n3;
        int n4 = this.offset.x;
        int n5 = this.offset.y;
        for (n3 = 0; n3 < this.columnWidths.length && n >= (n4 += this.columnWidths[n3]); ++n3) {
        }
        int n6 = 0;
        while (n3 < this.rowHeights.length && n2 >= (n5 += this.rowHeights[n6])) {
            ++n6;
        }
        return new Point(n3, n6);
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        if (this.comptable.containsKey(component)) {
            return (GridBagConstraints)this.comptable.get(component);
        }
        return null;
    }

    public Dimension maximumLayoutSize(Container container) {
        return Toolkit.singleton.getScreenSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.insets;
        this.getCellDims(container, 1);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.insets;
        this.getCellDims(container, 2);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public void removeLayoutComponent(Component component) {
        this.comptable.remove(component);
    }

    int rowStart(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.rowHeights[i];
        }
        return n2;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.comptable.put(component, gridBagConstraints2);
    }

    int sumHeights() {
        int n = 0;
        for (int i = 0; i < this.rowHeights.length; ++i) {
            n += this.rowHeights[i];
        }
        return n;
    }

    int sumWidths() {
        int n = 0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            n += this.columnWidths[i];
        }
        return n;
    }

    public String toString() {
        int n = this.columnWidths != null ? this.columnWidths.length : 0;
        int n2 = this.rowHeights != null ? this.rowHeights.length : 0;
        return String.valueOf(String.valueOf(String.valueOf("GridBagLayout columns: ").concat(String.valueOf(n))).concat(String.valueOf(",rows: "))).concat(String.valueOf(n2));
    }
}

