/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.HotKeyEntry;
import java.awt.MenuItem;
import java.awt.event.KeyEvent;

class HotKeyHandler {
    static HotKeyEntry entry;

    static void addHotKey(Component component, MenuItem menuItem, int n, int n2, String string) {
        if ((n2 & 2) > 0) {
            n = HotKeyHandler.mapCtrlCode(n, n2);
        }
        HotKeyEntry hotKeyEntry = new HotKeyEntry(component, menuItem, n, n2, string);
        if (entry == null) {
            entry = hotKeyEntry;
        } else {
            HotKeyEntry hotKeyEntry2 = entry;
            while (hotKeyEntry2.next != null) {
                hotKeyEntry2 = hotKeyEntry2.next;
            }
            hotKeyEntry2.next = hotKeyEntry;
        }
    }

    static void addHotKey(Component component, int n, int n2, String string) {
        HotKeyHandler.addHotKey(component, null, n, n2, string);
    }

    static void focusNext(Container container, Component component) {
        boolean bl = component == null;
        for (int i = 0; i < container.nChildren; ++i) {
            Component component2 = container.children[i];
            if (bl && component2.isFocusTraversable()) {
                component2.requestFocus();
                return;
            }
            if (component != component2) continue;
            bl = true;
        }
        if (container.parent != null) {
            HotKeyHandler.focusNext(container.parent, container);
        } else {
            HotKeyHandler.focusNext(container, null);
        }
    }

    static void focusPrev(Container container, Component component) {
        boolean bl = component == null;
        for (int i = container.nChildren - 1; i >= 0; --i) {
            Component component2 = container.children[i];
            if (bl && component2.isFocusTraversable()) {
                component2.requestFocus();
                return;
            }
            if (component != component2) continue;
            bl = true;
        }
        if (container.parent != null) {
            HotKeyHandler.focusPrev(container.parent, container);
        } else {
            HotKeyHandler.focusPrev(container, null);
        }
    }

    static boolean handle(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401 || keyEvent.consumed) {
            return false;
        }
        HotKeyEntry hotKeyEntry = entry;
        while (hotKeyEntry != null) {
            if (hotKeyEntry.process(keyEvent)) {
                return true;
            }
            hotKeyEntry = hotKeyEntry.next;
        }
        char c = keyEvent.getKeyChar();
        Component component = (Component)keyEvent.getSource();
        boolean bl = keyEvent.isShiftDown();
        Container container = component.parent != null ? component.parent : (Container)component;
        switch (c) {
            case '\t': {
                if (bl) {
                    HotKeyHandler.focusPrev(container, AWTEvent.keyTgt);
                } else {
                    HotKeyHandler.focusNext(container, AWTEvent.keyTgt);
                }
                return true;
            }
        }
        return false;
    }

    static int mapCtrlCode(int n, int n2) {
        if ((n2 & 2) > 0 && n >= 1 && n <= 26) {
            return n + 64;
        }
        return n;
    }

    static void removeHotKey(Component component, int n, int n2) {
        if (entry == null) {
            return;
        }
        if ((n2 & 2) > 0) {
            n = HotKeyHandler.mapCtrlCode(n, n2);
        }
        if (HotKeyHandler.entry.tgt == component && HotKeyHandler.entry.keyCode == n && HotKeyHandler.entry.mods == n2) {
            entry = HotKeyHandler.entry.next;
            return;
        }
        HotKeyEntry hotKeyEntry = entry;
        while (hotKeyEntry.next != null) {
            HotKeyEntry hotKeyEntry2 = hotKeyEntry.next;
            if (hotKeyEntry2.tgt == component && hotKeyEntry2.keyCode == n && hotKeyEntry2.mods == n2) {
                hotKeyEntry.next = hotKeyEntry2.next;
                break;
            }
            hotKeyEntry = hotKeyEntry.next;
        }
    }

    static void removeHotKeys(Component component) {
        if (entry == null) {
            return;
        }
        HotKeyEntry hotKeyEntry = entry;
        while (hotKeyEntry != null) {
            HotKeyEntry hotKeyEntry2 = hotKeyEntry.next;
            if (hotKeyEntry.tgt == component && hotKeyEntry == entry) {
                entry = hotKeyEntry.next;
            } else if (hotKeyEntry2 != null && hotKeyEntry2.tgt == component) {
                hotKeyEntry.next = hotKeyEntry2.next;
            }
            hotKeyEntry = hotKeyEntry.next;
        }
    }

    static int size() {
        int n = 0;
        HotKeyEntry hotKeyEntry = entry;
        while (hotKeyEntry != null) {
            ++n;
            hotKeyEntry = hotKeyEntry.next;
        }
        return n;
    }

    HotKeyHandler() {
    }
}

