/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kaffe.io.AccessibleBAOStream;
import kaffe.util.Ptr;

public class Image {
    Ptr nativeData;
    int width = -1;
    int height = -1;
    ImageProducer producer;
    Object srcObj;
    Vector observers = new Vector();
    int flags;
    static final int PRODUCING = 256;
    static final int READY = 35;
    static final int SCREEN = 1024;
    static Thread prodThread;
    static Initializer prodQueue;
    static Object lock;

    Image(File file) {
        this.srcObj = file;
        this.createFromFile();
    }

    Image(Image image, int n, int n2) {
        this.nativeData = Toolkit.imgCreateScaledImage(image.nativeData, n, n2);
        this.width = n;
        this.height = n2;
        this.flags = 35;
    }

    Image(ImageProducer imageProducer) {
        this.producer = imageProducer;
    }

    Image(URL uRL) {
        this.srcObj = uRL;
    }

    Image(byte[] byArray, int n, int n2) {
        this.createFromData(byArray, n, n2);
    }

    Image(int n, int n2) {
        this.nativeData = Toolkit.imgCreateScreenImage(n, n2);
        this.width = n;
        this.height = n2;
        this.flags = 1059;
    }

    void addObserver(ImageObserver imageObserver) {
        if (imageObserver != null) {
            if (this.observers == null) {
                this.observers = new Vector(2);
                this.observers.addElement(imageObserver);
            } else if (!this.observers.contains(imageObserver)) {
                this.observers.addElement(imageObserver);
            }
        }
    }

    static int checkImage(Image image, int n, int n2, ImageObserver imageObserver, boolean bl) {
        if (image == null) {
            return 192;
        }
        if ((image.flags & 0x20) != 0) {
            if (n > 0 && n2 > 0) {
                image.scale(n, n2);
            }
        } else if (bl) {
            image.addObserver(imageObserver);
            if ((image.flags & 0x180) == 0) {
                image.startAsyncProduction();
            }
        }
        return image.flags;
    }

    void createFromData(byte[] byArray, int n, int n2) {
        this.nativeData = Toolkit.imgCreateFromData(byArray, n, n2);
        this.finishCreate();
    }

    void createFromFile() {
        File file = (File)this.srcObj;
        String string = file.getAbsolutePath();
        if (file.exists()) {
            this.flags |= 0x100;
            this.nativeData = Toolkit.imgCreateFromFile(string);
        }
        this.finishCreate();
    }

    void createFromURL() {
        URL uRL = (URL)this.srcObj;
        byte[] byArray = new byte[1024];
        this.flags |= 0x100;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream != null) {
                int n;
                AccessibleBAOStream accessibleBAOStream = new AccessibleBAOStream(8192);
                while ((n = inputStream.read(byArray)) >= 0) {
                    accessibleBAOStream.write(byArray, 0, n);
                }
                inputStream.close();
                this.createFromData(accessibleBAOStream.getBuffer(), 0, accessibleBAOStream.size());
            }
        }
        catch (Exception exception) {
            this.flags = 192;
        }
    }

    protected void finalize() {
        this.flush();
    }

    void finishCreate() {
        if (this.nativeData != null) {
            this.width = Toolkit.imgGetWidth(this.nativeData);
            this.height = Toolkit.imgGetHeight(this.nativeData);
            this.stateChange(35, 0, 0, this.width, this.height);
        } else {
            this.stateChange(192, 0, 0, this.width, this.height);
        }
    }

    public void flush() {
        if (this.nativeData != null) {
            Toolkit.imgFreeImage(this.nativeData);
            this.nativeData = null;
        }
    }

    public Graphics getGraphics() {
        if ((this.flags & 0x400) == 0 || this.nativeData == null) {
            return null;
        }
        return Graphics.getGraphics(this, 0, 0, 0, 0, this.width, this.height, Color.black, Color.white, Defaults.WndFont, false);
    }

    public int getHeight(ImageObserver imageObserver) {
        if ((this.flags & 2) != 0) {
            return this.height;
        }
        this.addObserver(imageObserver);
        if ((this.flags & 0x180) == 0) {
            this.startAsyncProduction();
        }
        return -1;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return null;
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (this.nativeData == null || n <= 0 || n2 <= 0 || (this.flags & 0x400) != 0 || (this.flags & 0x20) == 0) {
            return null;
        }
        return new Image(this, n, n2);
    }

    public ImageProducer getSource() {
        if (this.nativeData != null) {
            return new NativeProducer();
        }
        return this.producer;
    }

    public int getWidth(ImageObserver imageObserver) {
        if ((this.flags & 1) != 0) {
            return this.width;
        }
        this.addObserver(imageObserver);
        if ((this.flags & 0x180) == 0) {
            this.startAsyncProduction();
        }
        return -1;
    }

    void removeObserver(ImageObserver imageObserver) {
        if (this.observers != null) {
            if (this.observers.size() == 1) {
                this.observers = null;
            } else {
                this.observers.removeElement(imageObserver);
            }
        }
    }

    boolean scale(int n, int n2) {
        if ((this.flags & 0x400) != 0 || (this.flags & 0x20) == 0 || this.nativeData == null) {
            return false;
        }
        if (n != this.width || n2 != this.height) {
            Ptr ptr = this.nativeData;
            this.nativeData = Toolkit.imgCreateScaledImage(this.nativeData, n, n2);
            Toolkit.imgFreeImage(ptr);
            this.width = n;
            this.height = n2;
        }
        return true;
    }

    synchronized void startAsyncProduction() {
        Initializer initializer = new Initializer();
        this.flags |= 0x100;
        Object object = lock;
        synchronized (object) {
            try {
                if (prodQueue == null) {
                    prodQueue = initializer;
                } else {
                    Initializer initializer2 = prodQueue;
                    while (initializer2.next != null) {
                        initializer2 = initializer2.next;
                    }
                    initializer2.next = initializer;
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        if (prodThread == null) {
            prodThread = new Thread(prodQueue);
            prodThread.setPriority(2);
            prodThread.start();
        }
    }

    void stateChange(int n, int n2, int n3, int n4, int n5) {
        this.flags = n;
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ImageObserver imageObserver = (ImageObserver)enumeration.nextElement();
                if (imageObserver.imageUpdate(this, n, n2, n3, n4, n5)) continue;
                this.observers.removeElement(imageObserver);
            }
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.width))).concat(String.valueOf(','))).concat(String.valueOf(this.height))).concat(String.valueOf(", flags: "))).concat(String.valueOf(this.flags))).concat(String.valueOf(']'));
    }

    static {
        lock = new Object();
    }

    class NativeProducer
    implements ImageProducer {
        Vector consumers = new Vector(1);

        public void addConsumer(ImageConsumer imageConsumer) {
            if (!this.consumers.contains(imageConsumer)) {
                this.consumers.addElement(imageConsumer);
            }
        }

        void imageComplete(int n) {
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.imageComplete(n);
            }
        }

        public boolean isConsumer(ImageConsumer imageConsumer) {
            return this.consumers.contains(imageConsumer);
        }

        void produceFromFile() {
            Image.this.createFromFile();
            if (Image.this.nativeData != null) {
                this.produceFromNativeImage();
            } else {
                this.imageComplete(5);
            }
        }

        void produceFromNativeImage() {
            Toolkit.imgProduceImage(this, Image.this.nativeData);
        }

        void produceFromURL() {
            Image.this.createFromURL();
            if (Image.this.nativeData != null) {
                this.produceFromNativeImage();
            } else {
                this.imageComplete(5);
            }
        }

        public void removeConsumer(ImageConsumer imageConsumer) {
            this.consumers.removeElement(imageConsumer);
        }

        public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        }

        void setColorModel(ColorModel colorModel) {
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setColorModel(colorModel);
            }
        }

        void setDimensions(int n, int n2) {
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setDimensions(n, n2);
            }
        }

        void setHints(int n) {
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setHints(n);
            }
        }

        void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
            }
        }

        public void startProduction(ImageConsumer imageConsumer) {
            this.addConsumer(imageConsumer);
            if (Image.this.nativeData != null) {
                this.produceFromNativeImage();
            } else if (Image.this.srcObj != null) {
                if (Image.this.srcObj instanceof String) {
                    this.produceFromFile();
                } else if (Image.this.srcObj instanceof URL) {
                    this.produceFromURL();
                }
            }
        }

        NativeProducer() {
        }
    }

    class Initializer
    implements ImageConsumer,
    Runnable {
        Initializer next;

        public void imageComplete(int n) {
            int n2 = 0;
            if (n == 2) {
                n2 |= 0x10;
            }
            if (n == 3) {
                n2 |= 0x20;
            }
            if (n == 1) {
                n2 |= 0x40;
            }
            if (n == 4) {
                n2 |= 0x80;
            }
            Image.this.stateChange(Image.this.flags | n2, 0, 0, Image.this.width, Image.this.height);
        }

        public void run() {
            Object object;
            while (true) {
                Initializer initializer;
                object = lock;
                synchronized (object) {
                    Object var4_3;
                    try {
                        if (prodQueue == null) {
                            var4_3 = null;
                            break;
                        }
                        initializer = prodQueue;
                        prodQueue = Image.prodQueue.next;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        throw throwable;
                    }
                    var4_3 = null;
                    {
                    }
                }
                initializer.startProduction();
            }
            object = lock;
            synchronized (object) {
                try {
                    prodThread = null;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public void setColorModel(ColorModel colorModel) {
        }

        public void setDimensions(int n, int n2) {
            if (n != Image.this.width || n2 != Image.this.height) {
                Image.this.width = n;
                Image.this.height = n2;
                Image.this.nativeData = Toolkit.imgCreateImage(Image.this.width, Image.this.height);
                Image.this.stateChange(Image.this.flags | 1 | 2, 0, 0, Image.this.width, Image.this.height);
            }
        }

        public void setHints(int n) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            if (Image.this.nativeData == null) {
                return;
            }
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                Toolkit.imgSetIdxPels(Image.this.nativeData, n, n2, n3, n4, indexColorModel.rgbs, byArray, indexColorModel.trans, n5, n6);
                Image.this.stateChange(Image.this.flags | 8, n, n2, n3, n4);
            }
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            if (Image.this.nativeData == null) {
                return;
            }
            if (colorModel instanceof DirectColorModel) {
                if (colorModel != ColorModel.getRGBdefault()) {
                    for (int i = n; i < n6; ++i) {
                        nArray[i] = colorModel.getRGB(nArray[i]);
                    }
                }
                Toolkit.imgSetRGBPels(Image.this.nativeData, n, n2, n3, n4, nArray, n5, n6);
                Image.this.stateChange(Image.this.flags | 8, n, n2, n3, n4);
            }
        }

        public void setProperties(Hashtable hashtable) {
            Image.this.stateChange(Image.this.flags | 4, 0, 0, Image.this.width, Image.this.height);
        }

        void startProduction() {
            Image.this.flags |= 0x100;
            if (Image.this.producer != null) {
                Image.this.producer.startProduction(this);
            } else if (Image.this.srcObj != null) {
                if (Image.this.srcObj instanceof File) {
                    Image.this.createFromFile();
                } else if (Image.this.srcObj instanceof URL) {
                    Image.this.createFromURL();
                }
            }
        }

        Initializer() {
        }
    }
}

