/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Label
extends Component {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int align;
    String label;
    boolean hasBorder;
    FontMetrics fm;

    public Label() {
        this("", 1);
    }

    public Label(String string) {
        this(string, 1);
    }

    public Label(String string, int n) {
        this.setForeground(Defaults.LabelClr);
        this.setFont(Defaults.LabelFont);
        this.setText(string);
        this.setAlignment(n);
    }

    public int getAlignment() {
        return this.align;
    }

    public Dimension getPreferredSize() {
        int n = 50;
        int n2 = 20;
        if (this.fm != null) {
            n = Math.max(n, this.fm.stringWidth(this.label));
            n2 = Math.max(n2, 3 * this.fm.getHeight() / 2);
        }
        return new Dimension(n, n2);
    }

    public String getText() {
        return this.label;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.fm.stringWidth(this.label);
        int n2 = this.hasBorder ? 2 : 0;
        int n3 = this.height - (this.height - this.fm.getHeight()) / 2 - this.fm.getDescent();
        int n4 = n2 + 1;
        switch (this.align) {
            case 0: {
                n4 = (this.width - n) / 2;
                break;
            }
            case 2: {
                n4 = this.width - n - n2;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.hasBorder) {
            this.paintBorder(graphics);
        }
        if (Defaults.LabelsCarved) {
            graphics.setColor(Color.white);
            graphics.drawString(this.label, n4 + 1, n3 + 1);
        }
        graphics.setColor(this.fgClr);
        graphics.drawString(this.label, n4, n3);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",Label: "))).concat(String.valueOf(this.label));
    }

    public void setAlignment(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.align = n;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.label == null || !this.label.equals(string)) {
            this.label = string;
            boolean bl = this.hasBorder = string.startsWith(" ") && string.endsWith(" ");
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }
}

