/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public abstract class TextComponent
extends Container {
    protected transient TextListener textListener;
    boolean isEditable = true;
    protected static TextEvent tEvt = new TextEvent(null, 900);

    public void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public abstract int getCaretPosition();

    public abstract String getSelectedText();

    public abstract int getSelectionEnd();

    public abstract int getSelectionStart();

    public abstract String getText();

    boolean handleClipboard(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n2 == 2) {
            if (n == 15) {
                this.copyToClipboard();
                return true;
            }
            if (n == 1) {
                this.pasteFromClipboard();
                return true;
            }
        }
        return false;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    boolean isPrintableTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if (n != 0 && n != 1) {
            return false;
        }
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\u001b': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    protected String paramString() {
        return super.paramString();
    }

    void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelectionWith(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.hasToNotify(1024, this.textListener)) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    void replaceSelectionWith(String string) {
    }

    public abstract void select(int var1, int var2);

    public abstract void selectAll();

    public abstract void setCaretPosition(int var1);

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public abstract void setSelectionEnd(int var1);

    public abstract void setSelectionStart(int var1);

    public abstract void setText(String var1);
}

