/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

public class DataFlavor {
    String type;
    String name;
    Class repClass;
    public static DataFlavor plainTextFlavor = null;
    public static DataFlavor stringFlavor = null;
    static Class defaultRepClass;
    static String defaultMimeType;

    public DataFlavor(Class clazz, String string) {
        this.type = defaultMimeType;
        this.repClass = clazz;
        this.name = string;
    }

    public DataFlavor(String string, String string2) {
        this.repClass = defaultRepClass;
        this.type = string;
        this.name = string2;
    }

    public boolean equals(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor) && this.repClass == dataFlavor.repClass;
    }

    public String getHumanPresentableName() {
        return this.name;
    }

    public String getMimeType() {
        return this.type;
    }

    public Class getRepresentationClass() {
        return this.repClass;
    }

    public boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.type);
    }

    public boolean isMimeTypeEqual(String string) {
        return this.type.equals(string);
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return String.valueOf(String.valueOf(string).concat(String.valueOf('='))).concat(String.valueOf(string2));
    }

    public void setHumanPresentableName(String string) {
        this.name = string;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("DataFlavor [").concat(String.valueOf(this.name))).concat(String.valueOf(','))).concat(String.valueOf(this.type))).concat(String.valueOf(','))).concat(String.valueOf(this.repClass.getName()))).concat(String.valueOf(']'));
    }

    static {
        try {
            defaultRepClass = Class.forName("java.io.InputStream");
            defaultMimeType = "application/x-java-serialized-object";
            plainTextFlavor = new DataFlavor("text/plain; charset=unicode", "plain text");
            stringFlavor = new DataFlavor(Class.forName("java.lang.String"), "unicode string");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

