/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import kaffe.util.NotImplemented;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream in;
    private byte[] buffer = new byte[255];
    private int pos = 0;
    private int len = 0;
    private boolean doBlocking = false;
    private Hashtable objectsDone = new Hashtable();
    private int nextKey = 0x7E0000;
    private Object currObject;
    private ObjectStreamClass currStreamClass;
    private boolean enableResolve = false;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.in = inputStream;
        this.enableBuffering(false);
        this.readStreamHeader();
        this.enableBuffering(true);
    }

    public int available() throws IOException {
        throw new NotImplemented();
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected final boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        this.enableResolve = bl;
        return bl2;
    }

    public int read() throws IOException {
        if (!this.doBlocking) {
            return this.in.read();
        }
        if (this.pos >= this.len) {
            if (this.in.read() != 119) {
                throw new StreamCorruptedException("expected blockdata");
            }
            int n = this.in.read();
            this.len = this.in.read(this.buffer, 0, n);
            if (this.len != n) {
                throw new StreamCorruptedException("bad blockdata size");
            }
            this.pos = 0;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4;
    }

    public boolean readBoolean() throws IOException {
        return this.readWithEOF() != 0;
    }

    public byte readByte() throws IOException {
        return (byte)this.readWithEOF();
    }

    public int readUnsignedByte() throws IOException {
        return this.readWithEOF();
    }

    public char readChar() throws IOException {
        int n = this.readWithEOF();
        int n2 = this.readWithEOF();
        return (char)(n << 8 | n2);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            n3 = this.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public int readInt() throws IOException {
        int n = this.readWithEOF();
        int n2 = this.readWithEOF();
        int n3 = this.readWithEOF();
        int n4 = this.readWithEOF();
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public String readLine() throws IOException {
        throw new NotImplemented();
    }

    public long readLong() throws IOException {
        long l = this.readInt();
        long l2 = (long)this.readInt() & 0xFFFFFFFFL;
        return l << 32 | l2;
    }

    public short readShort() throws IOException {
        int n = this.readWithEOF();
        int n2 = this.readWithEOF();
        return (short)(n << 8 | n2);
    }

    public int readUnsignedShort() throws IOException {
        int n = this.readWithEOF();
        int n2 = this.readWithEOF();
        return n << 8 | n2;
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = this;
        synchronized (objectInputStream) {
            try {
                Object object;
                Object object2;
                boolean bl = this.enableBuffering(false);
                Object object3 = this.currObject;
                ObjectStreamClass objectStreamClass = this.currStreamClass;
                int n = this.readUnsignedByte();
                if (n == 113) {
                    object2 = new Integer(this.readInt());
                    this.currObject = this.objectsDone.get(object2);
                    if (this.currObject == null) {
                        throw new StreamCorruptedException("reference to unknown object");
                    }
                } else if (n == 112) {
                    this.currObject = null;
                } else {
                    switch (n) {
                        case 115: {
                            try {
                                this.currStreamClass = (ObjectStreamClass)this.readObject();
                            }
                            catch (ClassCastException classCastException) {
                                throw new StreamCorruptedException("expected class desc");
                            }
                            this.currObject = ObjectInputStream.allocateNewObject(this.currStreamClass.clazz, null);
                            if ((this.currStreamClass.method & 4) != 0) {
                                try {
                                    ((Externalizable)this.currObject).readExternal(this);
                                }
                                catch (ClassCastException classCastException) {}
                                break;
                            }
                            if ((this.currStreamClass.method & 1) != 0) {
                                this.invokeObjectReader(this.currObject, Class.forName("java.io.ObjectStreamClass"));
                                break;
                            }
                            if ((this.currStreamClass.method & 2) != 0) {
                                this.defaultReadObject();
                                break;
                            }
                            throw new StreamCorruptedException(String.valueOf("unknown method type: ").concat(String.valueOf(this.currStreamClass.method)));
                        }
                        case 117: {
                            try {
                                this.currStreamClass = (ObjectStreamClass)this.readObject();
                            }
                            catch (ClassCastException classCastException) {
                                throw new StreamCorruptedException("expected class desc");
                            }
                            this.currObject = this.readArray();
                            break;
                        }
                        case 114: {
                            this.currObject = object2 = new ObjectStreamClass();
                            this.invokeObjectReader(this.currObject, Class.forName("java.io.ObjectStreamClass"));
                            ((ObjectStreamClass)object2).clazz = this.resolveClass((ObjectStreamClass)object2);
                            ((ObjectStreamClass)object2).buildFieldsAndOffset();
                            break;
                        }
                        case 116: {
                            this.currObject = this.readUTF();
                            break;
                        }
                        case 121: {
                            this.pos = 0;
                            this.len = 0;
                            this.objectsDone = new Hashtable();
                            this.enableBuffering(true);
                            break;
                        }
                        default: {
                            throw new StreamCorruptedException(String.valueOf("unexpected token: ").concat(String.valueOf(n)));
                        }
                    }
                    object = new Integer(++this.nextKey);
                    this.objectsDone.put(this.currObject, object);
                }
                object2 = this.currObject;
                if (this.enableResolve) {
                    object2 = this.resolveObject(object2);
                }
                this.currObject = object3;
                this.currStreamClass = objectStreamClass;
                this.enableBuffering(bl);
                object = object2;
                Object var9_11 = null;
                return object;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                throw throwable;
            }
        }
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        this.readDataFields(this.currStreamClass, this.currObject);
    }

    private void readDataFields(ObjectStreamClass objectStreamClass, Object object) {
        if (objectStreamClass != null) {
            this.readDataFields(objectStreamClass.superclazzStream, object);
            this.inputClassFields(object, objectStreamClass.clazz, objectStreamClass.fieldRdWr);
        }
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        this.expectShort((short)-21267, "bad magic nr");
        this.expectShort((short)5, "bad version nr");
    }

    public String readUTF() throws IOException {
        ObjectInputStream objectInputStream = this;
        synchronized (objectInputStream) {
            try {
                short s = this.readShort();
                byte[] byArray = new byte[s];
                this.readFully(byArray);
                String string = this.unmakeUTF(byArray);
                Object var6_5 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    private Object readArray() throws IOException, ClassNotFoundException {
        Object object;
        block9: {
            Class clazz;
            int n;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        n = this.readInt();
                                        object = ObjectInputStream.allocateNewArray(this.currStreamClass.clazz, n);
                                        clazz = this.currStreamClass.clazz.getComponentType();
                                        if (clazz != Class.forName("java.lang.Object")) break block8;
                                        Object[] objectArray = (Object[])object;
                                        for (int i = 0; i < n; ++i) {
                                            objectArray[i] = this.readObject();
                                        }
                                        break block9;
                                    }
                                    if (clazz != Character.TYPE) break block10;
                                    char[] cArray = (char[])object;
                                    for (int i = 0; i < n; ++i) {
                                        cArray[i] = this.readChar();
                                    }
                                    break block9;
                                }
                                if (clazz != Short.TYPE) break block11;
                                short[] sArray = (short[])object;
                                for (int i = 0; i < n; ++i) {
                                    sArray[i] = this.readShort();
                                }
                                break block9;
                            }
                            if (clazz != Integer.TYPE) break block12;
                            int[] nArray = (int[])object;
                            for (int i = 0; i < n; ++i) {
                                nArray[i] = this.readInt();
                            }
                            break block9;
                        }
                        if (clazz != Boolean.TYPE) break block13;
                        boolean[] blArray = (boolean[])object;
                        for (int i = 0; i < n; ++i) {
                            blArray[i] = this.readBoolean();
                        }
                        break block9;
                    }
                    if (clazz != Long.TYPE) break block14;
                    long[] lArray = (long[])object;
                    for (int i = 0; i < n; ++i) {
                        lArray[i] = this.readLong();
                    }
                    break block9;
                }
                if (clazz != Double.TYPE) break block15;
                double[] dArray = (double[])object;
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.readDouble();
                }
                break block9;
            }
            if (clazz != Float.TYPE) break block9;
            float[] fArray = (float[])object;
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.readFloat();
            }
        }
        return object;
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        throw new NotImplemented();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class clazz = this.loadClass0(null, objectStreamClass.getName());
        return clazz;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    public int skipBytes(int n) throws IOException {
        throw new NotImplemented();
    }

    private String unmakeUTF(byte[] byArray) throws UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2;
            if (((n2 = byArray[n++] & 0xFF) & 0x80) == 128) {
                char c;
                int n3;
                if ((n2 & 0xE0) == 192) {
                    if (((n3 = byArray[n++] & 0xFF) & 0xC0) == 128) {
                        c = (char)((n2 & 0x1F) << 6 | n3 & 0x3F);
                        stringBuffer.append(c);
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((n2 & 0xF0) == 224) {
                    if (((n3 = byArray[n++] & 0xFF) & 0xC0) == 128) {
                        if (((c = byArray[n++] & 0xFF) & 0xC0) == 128) {
                            char c2 = (char)((n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | c & 0x3F);
                            stringBuffer.append(c2);
                            continue;
                        }
                        throw new UTFDataFormatException();
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    int readWithEOF() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    void expectShort(short s, String string) throws IOException {
        int n;
        int n2 = this.readWithEOF();
        if (s != (short)(n2 << 8 | (n = this.readWithEOF()))) {
            throw new StreamCorruptedException(string);
        }
    }

    void expectByte(byte by, String string) throws IOException {
        int n = this.readWithEOF();
        if (by != (byte)n) {
            throw new StreamCorruptedException(string);
        }
    }

    private boolean enableBuffering(boolean bl) throws IOException {
        if (bl != this.doBlocking) {
            if (this.pos < this.len) {
                throw new StreamCorruptedException("blockdata buffer not empty");
            }
            this.doBlocking = bl;
            return !bl;
        }
        return bl;
    }

    private native Class loadClass0(Class var1, String var2);

    private native void inputClassFields(Object var1, Class var2, int[] var3);

    private static native Object allocateNewObject(Class var0, Class var1);

    private static native Object allocateNewArray(Class var0, int var1);

    private native boolean invokeObjectReader(Object var1, Class var2);
}

