/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();
    private String[] paths = null;

    private Runtime() {
        String string = this.initializeLinkerInternal();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
            this.paths = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.paths[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
    }

    private native String buildLibName(String var1, String var2);

    public Process exec(String string) throws IOException {
        return this.exec(string, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return this.exec(stringArray2, stringArray);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        System.getSecurityManager().checkExec(stringArray[0]);
        return this.execInternal(stringArray, stringArray2);
    }

    private native Process execInternal(String[] var1, String[] var2) throws IOException;

    public void exit(int n) {
        System.getSecurityManager().checkExit(n);
        this.exitInternal(n);
    }

    private native void exitInternal(int var1);

    public native long freeMemory();

    public native void gc();

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private void initPaths() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.initializeLinkerInternal(), System.getProperty("path.separator"));
        this.paths = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.paths[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    private native String initializeLinkerInternal();

    public synchronized void load(String string) {
        if (!this.loadInternal(string)) {
            throw new UnsatisfiedLinkError(string);
        }
    }

    private native boolean loadFileInternal(String var1);

    private boolean loadInternal(String string) {
        System.getSecurityManager().checkLink(string);
        return this.loadFileInternal(string);
    }

    public synchronized void loadLibrary(String string) {
        if (this.paths != null) {
            for (int i = 0; i < this.paths.length; ++i) {
                if (!this.loadInternal(this.buildLibName(this.paths[i], string))) continue;
                return;
            }
            throw new UnsatisfiedLinkError(string);
        }
    }

    public native void runFinalization();

    public native void runFinalizersOnExit(boolean var1);

    public native long totalMemory();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);
}

