/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Vector;

public class TextMenu
extends MenuBar
implements ActionListener {
    private Menu fileMenu;
    private Menu editMenu;
    private Menu fontMenu;
    private Menu sizeMenu;
    private Menu tabsMenu;
    private Menu beanMenu;
    private Menu helpMenu;
    private EditMan editMan;
    private SizeMan sizeMan;
    private FontMan fontMan;
    private TabMan tabMan;
    private String newString = new String("New");
    private String openString = new String("Open");
    private String saveString = new String("Save");
    private String saveAsString = new String("Save As");
    private String printString = new String("Print");
    private String quitString = new String("Quit");
    private String otherString = new String("Other");
    private String aboutString = new String("About");
    private TextEdit textEdit;
    private TextCanvas textCanvas;
    private Vector beans;
    private Class sfi;
    private Class tfi;

    public TextMenu(TextEdit textEdit, Vector vector) {
        CheckboxMenuItem checkboxMenuItem;
        this.textEdit = textEdit;
        this.textCanvas = this.textEdit.getCanvas();
        this.beans = vector;
        try {
            this.sfi = Class.forName("SimpleFilterInterface");
            this.tfi = Class.forName("Test01FilterInterface");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Sorry, menu could not load filter interfaces.");
            this.beans = null;
        }
        this.editMan = new EditMan(textEdit);
        this.sizeMan = new SizeMan(textEdit);
        this.fontMan = new FontMan(textEdit);
        this.tabMan = new TabMan(textEdit);
        this.fileMenu = new Menu("File");
        this.fileMenu.add(new MenuItem(this.newString));
        this.fileMenu.add(new MenuItem(this.openString));
        this.fileMenu.add(new MenuItem(this.saveString));
        this.fileMenu.add(new MenuItem(this.saveAsString));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new MenuItem(this.printString));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new MenuItem(this.quitString));
        this.fileMenu.addActionListener(this);
        this.add(this.fileMenu);
        this.editMenu = new Menu("Edit");
        this.editMan.addItems(this.editMenu);
        this.add(this.editMenu);
        this.fontMenu = new Menu("Font");
        String[] stringArray = textEdit.getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("Courier")) {
                checkboxMenuItem = this.add_checked(this.fontMenu, this.fontMan, stringArray[n]);
                this.fontMan.remember(checkboxMenuItem);
            } else {
                this.add_unchecked(this.fontMenu, this.fontMan, stringArray[n]);
            }
            ++n;
        }
        this.add(this.fontMenu);
        this.sizeMenu = new Menu("Size");
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("9"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("10"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("11"));
        checkboxMenuItem = this.add_checked(this.sizeMenu, this.sizeMan, new String("12"));
        this.sizeMan.remember(checkboxMenuItem);
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("14"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("16"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("18"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("36"));
        this.add_unchecked(this.sizeMenu, this.sizeMan, new String("48"));
        this.add(this.sizeMenu);
        this.tabsMenu = new Menu("Tabs");
        this.tabMan.addItems(this.tabsMenu);
        this.add(this.tabsMenu);
        this.beanMenu = new Menu("Options");
        if (this.beans != null) {
            int n2 = 0;
            while (n2 < this.beans.size()) {
                String string = null;
                Object e = this.beans.elementAt(n2);
                if (this.sfi.isInstance(e)) {
                    string = ((SimpleFilterInterface)e).getMenuString();
                } else if (this.tfi.isInstance(e)) {
                    string = ((Test01FilterInterface)e).getMenuString();
                }
                if (string != null) {
                    this.beanMenu.add(new MenuItem(string));
                }
                ++n2;
            }
        }
        this.beanMenu.addActionListener(this);
        this.add(this.beanMenu);
        this.helpMenu = new Menu("Help");
        this.helpMenu.add(new MenuItem(this.aboutString));
        this.helpMenu.addActionListener(this);
        this.add(this.helpMenu);
    }

    private void add_unchecked(Menu menu, ItemListener itemListener, String string) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(itemListener);
        menu.add(checkboxMenuItem);
    }

    private CheckboxMenuItem add_checked(Menu menu, ItemListener itemListener, String string) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(itemListener);
        checkboxMenuItem.setState(true);
        menu.add(checkboxMenuItem);
        return checkboxMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.fileMenu) {
            this.doFile(string);
            return;
        }
        if (object == this.beanMenu) {
            this.doBean(string);
            return;
        }
        if (object == this.helpMenu) {
            AboutDialog aboutDialog = new AboutDialog(this.textEdit);
            aboutDialog.show();
        }
    }

    private void doBean(String string) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.beans.size()) {
            Object e = this.beans.elementAt(n);
            if (this.sfi.isInstance(e)) {
                bl = this.doSimple(string, (SimpleFilterInterface)e);
            } else if (this.tfi.isInstance(e)) {
                bl = this.doTest(string, (Test01FilterInterface)e);
            }
            ++n;
        }
    }

    private boolean doSimple(String string, SimpleFilterInterface simpleFilterInterface) {
        boolean bl = false;
        String string2 = simpleFilterInterface.getMenuString();
        if (string.equals(string2)) {
            String string3 = this.textCanvas.copy(false);
            if ((string3 = simpleFilterInterface.filterText(string3)) != null) {
                this.textCanvas.paste(string3);
            }
            bl = true;
        }
        return bl;
    }

    private boolean doTest(String string, Test01FilterInterface test01FilterInterface) {
        boolean bl = false;
        String string2 = test01FilterInterface.getMenuString();
        if (string.equals(string2)) {
            String string3 = this.textCanvas.copy(false);
            if ((string3 = test01FilterInterface.filterText(this.textEdit, string3)) != null) {
                this.textCanvas.paste(string3);
            }
            bl = true;
        }
        return bl;
    }

    private void doFile(String string) {
        if (string.equals(this.newString)) {
            this.textEdit.cmdFileNew();
            return;
        }
        if (string.equals(this.openString)) {
            this.textEdit.cmdFileOpen();
            return;
        }
        if (string.equals(this.saveString)) {
            this.textEdit.cmdFileSave();
            return;
        }
        if (string.equals(this.saveAsString)) {
            this.textEdit.cmdFileSaveAs();
            return;
        }
        if (string.equals(this.printString)) {
            this.textEdit.cmdPrint();
            return;
        }
        if (string.equals(this.quitString)) {
            this.textEdit.cmdFileQuit();
        }
    }
}

