/*
 * Decompiled with CFR 0.152.
 */
package pizza.util;

import java.io.Serializable;
import pizza.util.Dictionary;
import pizza.util.Enumeration;
import pizza.util.HashtableEntry;
import pizza.util.KeyEnumerator;
import pizza.util.ValueEnumerator;

public class Hashtable
extends Dictionary
implements Serializable,
Cloneable {
    private HashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public Hashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration pizza$util$Hashtable$keys() {
        return new KeyEnumerator(this.table);
    }

    public synchronized Enumeration pizza$util$Hashtable$elements() {
        return new ValueEnumerator(this.table);
    }

    public synchronized boolean pizza$util$Hashtable$contains(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean pizza$util$Hashtable$containsKey(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public synchronized Object pizza$util$Hashtable$get(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    public synchronized Object pizza$util$Hashtable$put(Object object, Object object2) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                Object object3 = hashtableEntry.value;
                hashtableEntry.value = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.pizza$util$Hashtable$put(object, object2);
        }
        hashtableEntryArray[n2] = new HashtableEntry(object, object2, n, hashtableEntryArray[n2]);
        ++this.count;
        return null;
    }

    public synchronized Object pizza$util$Hashtable$remove(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        Hashtable hashtable = new Hashtable(this.table.length, this.loadFactor);
        int n = this.table.length;
        while (n-- > 0) {
            hashtable.table[n] = this.table[n] != null ? this.table[n].pizza$util$HashtableEntry$copy() : null;
        }
        return hashtable;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pizza$util$Hashtable$keys();
        Enumeration enumeration2 = this.pizza$util$Hashtable$elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.pizza$util$Enumeration$nextElement().toString();
            String string2 = enumeration2.pizza$util$Enumeration$nextElement().toString();
            stringBuffer.append(String.valueOf(String.valueOf(string).concat(String.valueOf("="))).concat(String.valueOf(string2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Enumeration pizza$util$Dictionary$keys() {
        return this.pizza$util$Hashtable$keys();
    }

    public Enumeration pizza$util$Dictionary$elements() {
        return this.pizza$util$Hashtable$elements();
    }

    public Object pizza$util$Dictionary$get(Object object) {
        return this.pizza$util$Hashtable$get(object);
    }

    public Object pizza$util$Dictionary$put(Object object, Object object2) {
        return this.pizza$util$Hashtable$put(object, object2);
    }

    public Object pizza$util$Dictionary$remove(Object object) {
        return this.pizza$util$Hashtable$remove(object);
    }
}

