/*
 * Decompiled with CFR 0.152.
 */
package pizza.util;

import java.io.Serializable;
import pizza.support.Closure;
import pizza.support.array;
import pizza.util.Enumeration;
import pizza.util.NoSuchElementException;
import pizza.util.VectorEnumerator;

public class Vector
implements Serializable,
Cloneable {
    protected array elementData;
    protected int elementCount;
    protected int capacityIncrement;
    Closure allocator;
    Object defaultElem;

    public Vector(int n, int n2, Closure closure, Object object) {
        this.elementData = array.fromObject(closure.$apply(new Integer(n)));
        this.capacityIncrement = n2;
        this.allocator = closure;
        this.defaultElem = object;
    }

    public Vector(int n, Closure closure, Object object) {
        this(n, 0, closure, object);
    }

    public Vector(Closure closure, Object object) {
        this(10, closure, object);
    }

    public final synchronized void copyInto(array array2) {
        int n = this.elementCount;
        while (n-- > 0) {
            array2.at(n, this.elementData.at(n));
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length();
        if (this.elementCount < n) {
            array array2 = this.elementData;
            this.elementData = array.fromObject(this.allocator.$apply(new Integer(this.elementCount)));
            System.arraycopy(array2.toObject(), 0, this.elementData.toObject(), 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length();
        if (n > n2) {
            int n3;
            array array2 = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = array.fromObject(this.allocator.$apply(new Integer(n3)));
            System.arraycopy(array2.toObject(), 0, this.elementData.toObject(), 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData.at(i, this.defaultElem);
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length();
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData.at(i))) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount);
    }

    public final synchronized int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (!object.equals(this.elementData.at(n2))) continue;
            return n2;
        }
        return -1;
    }

    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        try {
            return this.elementData.at(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n).concat(String.valueOf(" < 0")));
        }
    }

    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData.at(0);
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData.at(this.elementCount - 1);
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        this.elementData.at(n, object);
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData.toObject(), n + 1, this.elementData.toObject(), n, n2);
        }
        --this.elementCount;
        this.elementData.at(this.elementCount, this.defaultElem);
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount))).concat(String.valueOf(1)));
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData.toObject(), n, this.elementData.toObject(), n + 1, this.elementCount - n);
        this.elementData.at(n, object);
        ++this.elementCount;
    }

    public final synchronized void addElement(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData.at(this.elementCount++, object);
    }

    public final synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData.at(i, this.defaultElem);
        }
        this.elementCount = 0;
    }

    private Vector() {
    }

    public synchronized Object clone() {
        Vector vector = new Vector(this.elementCount, this.capacityIncrement, this.allocator, this.defaultElem);
        System.arraycopy(this.elementData.toObject(), 0, vector.elementData.toObject(), 0, this.elementCount);
        return vector;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.pizza$util$Enumeration$nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

