/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import pizza.lang.List;
import pizza.lang.Pair;
import pizza.support.array;
import pizza.util.Hashtable;
import pizza.v39.AST;
import pizza.v39.ClassSymbol;
import pizza.v39.Constants;
import pizza.v39.FunSymbol;
import pizza.v39.Namer;
import pizza.v39.Report;
import pizza.v39.Scope;
import pizza.v39.Symbol;
import pizza.v39.Symtab;
import pizza.v39.Trail;
import pizza.v39.Type;
import pizza.v39.TypeSymbol;

class Checks
implements Constants {
    static void typeError(int n, String string, Type type, Type type2, Trail trail) {
        Report.error(n, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("\n found   : "))).concat(String.valueOf(type))).concat(String.valueOf("\n required: "))).concat(String.valueOf(type2))).concat(String.valueOf("\n("))).concat(String.valueOf(trail.errmsg()))).concat(String.valueOf(")")));
        trail.undo();
    }

    static Type checkType(int n, Type type, Type type2) {
        Object object;
        Constants constants = type2.deref();
        switch (constants.pizza$v39$Type$$tag) {
            case 10: {
                return type2;
            }
            case 5: {
                object = ((Type.FunType)constants).restype;
                if (object != null) break;
                return type;
            }
        }
        constants = type.assignable(type2, Trail.empty);
        if (((Trail)constants).status == 0) {
            return type;
        }
        object = type.tag() <= 7 && type2.tag() <= 7 ? "possible loss of precision" : "incompatible types";
        Checks.typeError(n, (String)object, type, type2, (Trail)constants);
        return Type.ErrType;
    }

    static Type join(int n, Type type, Type type2) {
        Trail trail;
        type = type.deconst();
        type2 = type2.deconst();
        if (type == Type.AnyType || type2 == Type.ErrType) {
            return type2;
        }
        if (type2 == Type.AnyType || type == Type.ErrType) {
            return type;
        }
        if (type.tag() == 2 || type2.tag() == 2) {
            if (type.tag() == 2 && type2.tag() == 2) {
                return type;
            }
            return Type.intType;
        }
        if (type2.isTypeVar()) {
            trail = type2.subtype(type, Trail.empty);
            if (trail.status == 0) {
                return type;
            }
            trail.undo();
        } else {
            trail = type.subtype(type2, Trail.empty);
            if (trail.status == 0) {
                return type2;
            }
            trail.undo();
            trail = type2.subtype(type, Trail.empty);
            if (trail.status == 0) {
                return type;
            }
            trail.undo();
        }
        for (Type type3 = type.supertype(); type3 != null; type3 = type3.supertype()) {
            trail = type2.subtype(type3, Trail.empty);
            if (trail.status == 0) {
                return type3;
            }
            trail.undo();
        }
        Report.error(n, String.valueOf(String.valueOf(String.valueOf(type).concat(String.valueOf(" and "))).concat(String.valueOf(type2))).concat(String.valueOf(" do not have a common supertype")));
        return Type.ErrType;
    }

    static Type checkNonVoid(AST aST) {
        if (aST.type == Type.VoidType) {
            Report.error(aST.pos, "'void' type not allowed here");
            aST.type = Type.ErrType;
        }
        return aST.type;
    }

    static Type checkJavaType(AST aST) {
        Type type = aST.type.deref();
        switch (type.pizza$v39$Type$$tag) {
            case 5: 
            case 7: {
                Report.error(aST.pos, String.valueOf(String.valueOf("Java type required, but ").concat(String.valueOf(aST.type))).concat(String.valueOf(" found")));
                aST.type = Type.ErrType;
            }
        }
        return aST.type;
    }

    static Type checkCastable(int n, Type type, Type type2) {
        Pair pair = type.castable(type2, Trail.empty);
        Type type3 = (Type)pair.snd;
        Trail trail = (Trail)pair.fst;
        if (trail.status == 0) {
            return type3;
        }
        Checks.typeError(n, "inconvertible types", type, type2, trail);
        return Type.ErrType;
    }

    static List remove(List list, Type type) {
        switch (list.pizza$lang$List$$tag) {
            case 1: {
                return list;
            }
            case 2: {
                List.Cons cons = (List.Cons)list;
                List list2 = cons.tail;
                Type type2 = (Type)cons.head;
                if (type == type2) {
                    return list2;
                }
                return List.Cons(type2, Checks.remove(list2, type));
            }
        }
        throw new Error();
    }

    static void addBound(int n, Type.TypeVar typeVar, Type type) {
        Trail trail = Checks.addBound(typeVar, type, Trail.empty);
        if (trail.status != 0) {
            Report.error(n, String.valueOf("incompatible type variable bounds: ").concat(String.valueOf(trail.errmsg())));
            trail.undo();
        }
    }

    private static Trail addBound(Type.TypeVar typeVar, Type type, Trail trail) {
        switch (type.pizza$v39$Type$$tag) {
            case 3: 
            case 4: {
                List list = typeVar.bounds;
                while (!list.isEmpty()) {
                    Type type2 = (Type)list.pizza$lang$List$head();
                    if (type.tsym().subclass(type2.tsym())) {
                        trail = type.subtype(type2, trail);
                        if (trail.status != 0) {
                            return trail;
                        }
                        typeVar.bounds = Checks.remove(typeVar.bounds, type2);
                    } else {
                        if (type2.tsym().subclass(type.tsym())) {
                            return type2.subtype(type, trail);
                        }
                        if ((type.tsym().modifiers & 0x200) == 0 && (type2.tsym().modifiers & 0x200) == 0) {
                            return trail.error("% and % are incompatible", type, type2);
                        }
                    }
                    list = list.pizza$lang$List$tail();
                }
                typeVar.bounds = List.Cons(type, typeVar.bounds);
                return trail;
            }
            case 10: {
                return trail;
            }
        }
        return trail.error("classtype required for type variable bound, but % found", trail);
    }

    static boolean checkClassBounds(int n, TypeSymbol typeSymbol) {
        return Checks.checkClassBounds(n, new Hashtable(), typeSymbol.type);
    }

    static boolean checkClassBounds(int n, Hashtable hashtable, Type type) {
        Type type2;
        Type[] typeArray = type.interfaces();
        for (int i = 0; typeArray != null && i < typeArray.length; ++i) {
            type2 = typeArray[i];
            TypeSymbol typeSymbol = type2.tsym();
            Type type3 = (Type)hashtable.pizza$util$Hashtable$put(typeSymbol, type2);
            if (type3 != null) {
                Type[] typeArray2 = type3.allargs();
                Type[] typeArray3 = type2.allargs();
                Trail trail = Type.sametypes(typeArray2, typeArray3, Trail.empty);
                if (trail.status != 0) {
                    Report.error(n, String.valueOf(String.valueOf(typeSymbol).concat(String.valueOf(" cannot be inherited with different arguments: "))).concat(String.valueOf(trail.errmsg())));
                }
                trail.undo();
                return false;
            }
            if (Checks.checkClassBounds(n, hashtable, type2)) continue;
            return false;
        }
        type2 = type.supertype();
        if (type2 != null) {
            return Checks.checkClassBounds(n, hashtable, type2);
        }
        return true;
    }

    static void checkBound(AST aST, Type type) {
        Checks.checkType(aST.pos, aST.type, type);
    }

    static void checkBound(AST[] aSTArray, Type type) {
        for (int i = 0; i < aSTArray.length; ++i) {
            Checks.checkBound(aSTArray[i], type);
        }
    }

    static void validateType(AST aST) {
        if (aST != null) {
            AST[] aSTArray;
            switch (aST.pizza$v39$AST$$tag) {
                case 42: {
                    aSTArray = ((AST.ArrayTypeTerm)aST).elemtype;
                    Checks.validateType((AST)aSTArray);
                    break;
                }
                case 44: {
                    aSTArray = (AST.ParTypeTerm)aST;
                    AST[] aSTArray2 = aSTArray.argtypes;
                    AST aST2 = aSTArray.clazz;
                    if (!(aST2.type instanceof Type.ClassType) || !(aST.type instanceof Type.ClassType)) break;
                    Type[] typeArray = aST2.type.args();
                    Type[] typeArray2 = aST.type.args();
                    if (typeArray2.length != typeArray.length) break;
                    Checks.validateTypeArgs(aSTArray2, typeArray, typeArray2);
                    break;
                }
                case 45: {
                    aSTArray = ((AST.TypeFormal)aST).bounds;
                    Checks.validateTypes(aSTArray);
                    break;
                }
                case 37: {
                    aSTArray = ((AST.Select)aST).selected;
                    if (!(aST.type instanceof Type.ClassType) || !(aST.type.outer() instanceof Type.ClassType)) break;
                    Checks.validateType((AST)aSTArray);
                    break;
                }
                case 6: {
                    AST aST3 = ((AST.VarDef)aST).vartype;
                    Checks.validateType(aST3);
                    return;
                }
            }
            aSTArray = aST.type;
            switch (aSTArray.pizza$v39$Type$$tag) {
                case 3: {
                    if (aST.type.args().length == 0 || aST.type != aST.type.tsym().type) break;
                    Report.error(aST.pos, String.valueOf(String.valueOf("type ").concat(String.valueOf(aST.type))).concat(String.valueOf(" takes parameters")));
                    aST.type = Type.ErrType;
                }
            }
        }
    }

    static void validateTypes(AST[] aSTArray) {
        for (int i = 0; i < aSTArray.length; ++i) {
            Checks.validateType(aSTArray[i]);
        }
    }

    static void validateTypeArgs(AST[] aSTArray, Type[] typeArray, Type[] typeArray2) {
        Object object;
        for (int i = 0; i < typeArray2.length; ++i) {
            object = aSTArray[i];
            Checks.validateType((AST)object);
            Checks.checkNonVoid((AST)object);
        }
        object = Type.freshTypeConsts(typeArray);
        Type.bind(typeArray, Type.subst(typeArray2, typeArray, (Type[])array.asObject(object)));
        for (int i = 0; i < typeArray2.length; ++i) {
            Checks.validateTypeArg(aSTArray[i].pos, typeArray[i], ((Type.TypeVar)typeArray[i]).bounds);
        }
        Type.bind(typeArray, typeArray);
    }

    static void validateTypeArg(int n, Type type, List list) {
        switch (list.pizza$lang$List$$tag) {
            case 1: {
                break;
            }
            case 2: {
                List.Cons cons = (List.Cons)list;
                List list2 = cons.tail;
                Type type2 = (Type)cons.head;
                Trail trail = type.subtype(type2, Trail.empty);
                if (trail.status != 0) {
                    trail.undo();
                    Report.error(n, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("type parameter ").concat(String.valueOf(type))).concat(String.valueOf(" is not within bound "))).concat(String.valueOf(type2))).concat(String.valueOf("\n("))).concat(String.valueOf(trail.errmsg()))).concat(String.valueOf(")")));
                } else {
                    Checks.validateTypeArg(n, type, list2);
                }
                trail.undo();
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private static boolean isHandled(Type type, List list) {
        return type == Type.ErrType || type.subtype(Symtab.errorType) || type.subtype(Symtab.runtimeExceptionType) || type.elem(list);
    }

    private static Type unHandled(List list, List list2) {
        switch (list.pizza$lang$List$$tag) {
            case 1: {
                return null;
            }
            case 2: {
                List.Cons cons = (List.Cons)list;
                List list3 = cons.tail;
                Type type = (Type)cons.head;
                if (Checks.isHandled(type, list2)) {
                    return Checks.unHandled(list3, list2);
                }
                return type;
            }
        }
        throw new Error();
    }

    static void checkHandled(int n, Type type, List list) {
        if (!Checks.isHandled(type, list)) {
            Report.error(n, String.valueOf(String.valueOf("unreported exception: ").concat(String.valueOf(type))).concat(String.valueOf("; must be caught or declared to be thrown")));
        }
    }

    static void checkHandled(int n, List list, List list2) {
        Type type = Checks.unHandled(list, list2);
        if (type != null) {
            Checks.checkHandled(n, type, list2);
        }
    }

    static void checkMono(int n, ClassSymbol classSymbol) {
        Symbol symbol = classSymbol.locals().elems;
        while (symbol != null) {
            if (symbol.sym.kind == 4 && (symbol.sym.modifiers & 8) == 0 && symbol.sym.type.isPolymorphic()) {
                Report.error(n, String.valueOf("non-parametric case illegal for class with polymorphic field: ").concat(String.valueOf(symbol.sym)));
            }
            symbol = symbol.sibling;
        }
    }

    private static int protection(int n) {
        switch (n & 7) {
            case 2: {
                return 3;
            }
            case 0: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new InternalError();
    }

    private static String protectionString(int n) {
        switch (n & 7) {
            case 2: {
                return "private";
            }
            case 0: {
                return "package";
            }
            case 4: {
                return "protected";
            }
            case 1: {
                return "public";
            }
        }
        throw new InternalError();
    }

    static String cannotOverride(FunSymbol funSymbol, FunSymbol funSymbol2) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(funSymbol).concat(String.valueOf(funSymbol.location()))).concat(String.valueOf(" cannot override "))).concat(String.valueOf(funSymbol2))).concat(String.valueOf(funSymbol2.location()));
    }

    static boolean checkOverridden(int n, FunSymbol funSymbol, FunSymbol funSymbol2, ClassSymbol classSymbol) {
        if ((funSymbol.modifiers & 8) != 0) {
            if ((funSymbol2.modifiers & 8) == 0) {
                Report.error(n, String.valueOf("static ").concat(String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2))));
                return false;
            }
        } else {
            if ((funSymbol2.modifiers & 0x18) != 0) {
                Report.error(n, String.valueOf(String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2)).concat(String.valueOf("; overridden method is "))).concat(String.valueOf(Namer.modNames(funSymbol2.modifiers & 0x18))));
                return false;
            }
            if (Checks.protection(funSymbol.modifiers) > Checks.protection(funSymbol2.modifiers)) {
                Report.error(n, String.valueOf(String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2)).concat(String.valueOf(" with weaker access privileges; was "))).concat(String.valueOf(Checks.protectionString(funSymbol2.modifiers))));
                return false;
            }
            if ((funSymbol.modifiers & 0x200000) == 0 && (funSymbol2.modifiers & 0x200000) == 1) {
                Report.error(n, String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2)).concat(String.valueOf(" since it is not a continuation")));
            } else {
                Trail trail;
                Type type;
                Type type2 = classSymbol.type.memberType(funSymbol);
                Type type3 = classSymbol.type.memberType(funSymbol2);
                switch (type2.pizza$v39$Type$$tag) {
                    case 8: {
                        type = (Type.ForAll)type2;
                        Type type4 = type.qtype;
                        Type.TypeVar[] typeVarArray = type.tvars;
                        Type.bind((Type[])array.asObject(typeVarArray), (Type[])array.asObject(Type.freshTypeVars((Type[])array.asObject(typeVarArray))));
                        trail = type4.restype().sametype(type3.restype(), Type.sametypes(type4.argtypes(), type3.argtypes(), Trail.empty));
                        Type.bind((Type[])array.asObject(typeVarArray), (Type[])array.asObject(typeVarArray));
                        break;
                    }
                    default: {
                        trail = type2.restype().sametype(type3.restype(), Trail.empty);
                    }
                }
                if (trail.status != 0) {
                    Checks.typeError(n, String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2)).concat(String.valueOf(" with different return type")), funSymbol.type.restype(), funSymbol2.type.restype(), trail);
                    trail.undo();
                    return false;
                }
                trail.undo();
                type = Checks.unHandled(funSymbol.type.thrown(), funSymbol2.type.thrown());
                if (type != null) {
                    Report.error(n, String.valueOf(String.valueOf(Checks.cannotOverride(funSymbol, funSymbol2)).concat(String.valueOf("; overridden method does not throw "))).concat(String.valueOf(type)));
                    return false;
                }
            }
        }
        return true;
    }

    private static FunSymbol firstUndef(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        FunSymbol funSymbol = null;
        if (typeSymbol == classSymbol || (typeSymbol.modifiers & 0x600) != 0) {
            Scope scope = typeSymbol.locals();
            Symbol symbol = scope.elems;
            while (symbol != null) {
                FunSymbol funSymbol2;
                FunSymbol funSymbol3;
                if (symbol.sym.kind == 8 && (symbol.sym.modifiers & 0x400) != 0 && ((funSymbol3 = (funSymbol2 = (FunSymbol)symbol.sym).implementation(classSymbol)) == null || funSymbol3 == funSymbol2)) {
                    return funSymbol2;
                }
                symbol = symbol.sibling;
            }
            if (typeSymbol.supertype() != null) {
                funSymbol = Checks.firstUndef(classSymbol, typeSymbol.supertype().tsym());
                for (int i = 0; funSymbol == null && i < typeSymbol.interfaces().length; ++i) {
                    funSymbol = Checks.firstUndef(classSymbol, typeSymbol.interfaces()[i].tsym());
                }
            }
        }
        return funSymbol;
    }

    static void checkAllDefined(int n, ClassSymbol classSymbol) {
        FunSymbol funSymbol = Checks.firstUndef(classSymbol, classSymbol);
        if (funSymbol != null) {
            FunSymbol funSymbol2 = new FunSymbol(funSymbol.modifiers, funSymbol.name, classSymbol.type.memberType(funSymbol), funSymbol.owner);
            Report.error(n, String.valueOf(String.valueOf(String.valueOf(classSymbol).concat(String.valueOf(" should be declared abstract; it does not define "))).concat(String.valueOf(funSymbol2))).concat(String.valueOf(funSymbol2.location())));
        }
    }

    static void checkOverride(int n, FunSymbol funSymbol) {
        ClassSymbol classSymbol = (ClassSymbol)funSymbol.owner;
        Symbol symbol = classSymbol.locals().lookup(funSymbol.name);
        while (symbol.scope != null) {
            if (funSymbol != symbol.sym && funSymbol.overrides(symbol.sym, classSymbol)) {
                Checks.checkOverridden(n, funSymbol, (FunSymbol)symbol.sym, classSymbol);
                return;
            }
            symbol = symbol.next();
        }
    }

    static void checkImplementations(int n, ClassSymbol classSymbol) {
        for (int i = 0; i < classSymbol.interfaces().length; ++i) {
            Checks.checkImplementations(n, classSymbol, classSymbol.interfaces()[i].tsym());
        }
    }

    static void checkImplementations(int n, ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        Symbol symbol = typeSymbol.locals().elems;
        while (symbol != null) {
            FunSymbol funSymbol;
            FunSymbol funSymbol2;
            if (symbol.sym.kind == 8 && (symbol.sym.modifiers & 8) == 0 && (funSymbol2 = (funSymbol = (FunSymbol)symbol.sym).implementation(classSymbol)) != null) {
                Checks.checkOverridden(n, funSymbol2, funSymbol, classSymbol);
            }
            symbol = symbol.sibling;
        }
        for (int i = 0; i < typeSymbol.interfaces().length; ++i) {
            Checks.checkImplementations(n, classSymbol, typeSymbol.interfaces()[i].tsym());
        }
    }

    Checks() {
    }
}

