/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

public class DatagramSocket {
    private DatagramSocketImpl impl;
    static Class DatagramSocketImplClass;

    protected DatagramSocket(DatagramSocketImpl datagramSocketImpl) throws SocketException {
        this.impl = datagramSocketImpl;
    }

    public DatagramSocket() throws SocketException {
        this(0, null);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        System.getSecurityManager().checkListen(n);
        try {
            this.impl = (DatagramSocketImpl)DatagramSocketImplClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException(String.valueOf(String.valueOf(String.valueOf("Couldn't create DatagramSocketImpl from class ").concat(String.valueOf(DatagramSocketImplClass.getName()))).concat(String.valueOf(":"))).concat(String.valueOf(exception)));
        }
        this.impl.create();
        if (inetAddress == null) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        this.impl.bind(n, inetAddress);
    }

    public synchronized void close() {
        this.impl.close();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.impl.getOption(4102);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.impl.setOption(4097, new Integer(n));
    }

    public int getSendBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4097);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.impl.setOption(4098, new Integer(n));
    }

    public int getReceiveBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4098);
    }

    protected synchronized void finalize() {
        this.close();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress;
        try {
            inetAddress = (InetAddress)this.impl.getOption(15);
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        return inetAddress;
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        System.getSecurityManager().checkRead(this.impl.fd);
        this.impl.receive(datagramPacket);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        System.getSecurityManager().checkConnect(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
        this.impl.send(datagramPacket);
    }

    static {
        System.loadLibrary("net");
        DatagramSocketImplClass = Class.forName("java.net.PlainDatagramSocketImpl");
    }
}

