/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import kaffe.util.NotImplemented;

public class ChoiceFormat
extends NumberFormat {
    private double[] limits;
    private String[] strings;

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '|') {
                ++n2;
                continue;
            }
            if (string.charAt(i) != '<') continue;
            ++n2;
        }
        this.limits = new double[n2];
        this.strings = new String[n2];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                this.limits[n4] = Double.valueOf(string.substring(n3, i));
                n3 = n4 + 1;
                continue;
            }
            if (c == '<') {
                bl = true;
                this.limits[n4] = Double.valueOf(string.substring(n3, i));
                n3 = n4 + 1;
                continue;
            }
            if (c != '|') continue;
            this.strings[n4] = string.substring(n3, i);
            ++n4;
            if (!bl) continue;
            bl = false;
            this.limits[n4] = ChoiceFormat.nextDouble(this.limits[n4 - 1]);
            this.strings[n4] = this.strings[n4 - 1];
            ++n4;
        }
    }

    public Object clone() {
        return new ChoiceFormat(this.limits, this.strings);
    }

    public boolean equals(Object object) {
        try {
            ChoiceFormat choiceFormat = (ChoiceFormat)object;
            for (int i = 0; i < this.limits.length; ++i) {
                if (this.limits[i] == choiceFormat.limits[i] && this.strings[i].equals(choiceFormat.strings[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (d < this.limits[0]) {
            stringBuffer.append(this.strings[0]);
            return stringBuffer;
        }
        int n = this.limits.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(this.limits[i] <= d) || !(d < this.limits[i + 1])) continue;
            stringBuffer.append(this.strings[i]);
            return stringBuffer;
        }
        stringBuffer.append(this.strings[n]);
        return stringBuffer;
    }

    public Object[] getFormats() {
        return this.strings;
    }

    public double[] getLimits() {
        return this.limits;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static final double nextDouble(double d) {
        return d + Double.MIN_NORMAL;
    }

    public static final double previousDouble(double d) {
        return d - Double.MIN_NORMAL;
    }

    public static double nextDouble(double d, boolean bl) {
        if (bl) {
            return ChoiceFormat.nextDouble(d);
        }
        return ChoiceFormat.previousDouble(d);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new NotImplemented();
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        this.limits = dArray;
        this.strings = stringArray;
    }

    public String toPattern() {
        throw new NotImplemented();
    }
}

