/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    String name;
    long time;
    long crc;
    long size;
    int method;
    byte[] extra;
    String comment;
    int flag;
    int version;
    long csize;
    long offset;

    ZipEntry() {
    }

    public ZipEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("name length > 0xFFFF");
        }
        this.name = string;
        this.time = 0L;
        this.crc = 0L;
        this.size = -1L;
        this.method = -1;
        this.extra = null;
        this.comment = null;
        this.csize = -1L;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getTime() {
        return this.time;
    }

    public void setSize(long l) {
        if (this.size > -1L) {
            throw new IllegalArgumentException("size > 0xFFFFFFFF");
        }
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("crc < 0 or > 0xFFFFFFFF: " + l);
        }
        this.crc = l;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("unsupported compression method");
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray.length > 1048575) {
            throw new IllegalArgumentException("extra length > 0xFFFFF");
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string.length() > 65535) {
            throw new IllegalArgumentException("comment length > 0xFFFF");
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }
}

