dnl Parameterized macros.
dnl Requires GNU m4.
dnl This file is part of GNU Ad HoC.
dnl Minor portions of it were stolen from Autoconf.
dnl Copyright (C) 1992, 1993, 1994, 1995, 1996 Free Software Foundation, Inc.
dnl Copyright (C) 1998, 1999 Alexandre Oliva
dnl Copyright (C) 1999 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Ad HoC.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Ad HoC appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Ad HoC program.
dnl
dnl Certain portions of the Ad HoC source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Ad HoC.  We call these the "data" portions.  The rest of the Ad HoC
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Ad HoC never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Ad HoC
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Ad HoC, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.
dnl
dnl Original autoconf version written by David MacKenzie, with help from
dnl Franc,ois Pinard, Karl Berry, Richard Pixley, Ian Lance Taylor,
dnl Roland McGrath, Noah Friedman, david d zuhn, and many others.
dnl Modified for GNU AdHoC by Alexandre Oliva
dnl
divert(-1)
changequote([, ])

dnl Some old m4's don't support m4exit.  But they provide
dnl equivalent functionality by core dumping because of the
dnl long macros we define.
ifdef([__gnu__], , [errprint(Ad HoC requires GNU m4.
Install it before installing Ad HoC or set the
M4 environment variable to its path name.
)m4exit(2)])

undefine([eval])
undefine([include])
undefine([shift])
undefine([format])

dnl ### Defining macros


dnl AH_DEFUN(NAME, EXPANSION) - Define a macro.
define([AH_DEFUN],defn([define]))
define([AC_DEFUN],defn([define]))dnl for compatibility with autoconf

dnl ### Initialization

dnl AH_EMIT_OUTPUT - Start expanding macros to output.
AH_DEFUN([AH_EMIT_OUTPUT], [divert(0)])
dnl AH_OMIT_OUTPUT - Start throwing output away.
AH_DEFUN([AH_OMIT_OUTPUT], [divert(-1)])

dnl AH_BIN_SH() - Start emitting output with shell-script magic
AH_DEFUN(AH_BIN_SH, [AH_EMIT_OUTPUT()dnl
#! /bin/sh])
define(AC_INIT_BINSH, defn([AH_BIN_SH]))dnl for compatibility with autoconf
define(AH_INIT_BINSH, defn([AH_BIN_SH]))dnl for similarity with autoconf

dnl AH_INCLUDE(FILE FILE ...) - Include the named file.  Wildcards are
dnl accepted, as long as they can be found in the *current* directory
dnl (i.e., they won't be searched in the m4 search directories).
AC_DEFUN(AH_INCLUDE,
[ifelse($1, [], [], [dnl
  esyscmd([for file in $1; do echo "builtin(include, $file)dnl"; done])dnl
])])
define(AC_INCLUDE, defn([AH_INCLUDE]))dnl for compatibility with autoconf

AH_INCLUDE(adhoc-version.m4)
