/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Xml2SomDatasets datasetsSom;
    private AcroFieldsSearch acroFieldsSom;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;
    private boolean changed;
    private Node datasetsNode;
    private Node templateNode;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public XfaForm(PdfReader pdfReader) throws IOException, ParserConfigurationException, SAXException {
        Object object;
        Object object2;
        Object object3;
        this.reader = pdfReader;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfReader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            this.xfaPresent = false;
            return;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.XFA));
        if (pdfObject == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (pdfObject.isArray()) {
            object3 = ((PdfArray)pdfObject).getArrayList();
            int n = 1;
            while (n < ((ArrayList)object3).size()) {
                object2 = PdfReader.getPdfObject((PdfObject)((ArrayList)object3).get(n));
                if (object2 instanceof PRStream) {
                    object = PdfReader.getStreamBytes((PRStream)object2);
                    byteArrayOutputStream.write((byte[])object);
                }
                n += 2;
            }
        } else if (pdfObject instanceof PRStream) {
            object3 = PdfReader.getStreamBytes((PRStream)pdfObject);
            byteArrayOutputStream.write((byte[])object3);
        }
        byteArrayOutputStream.close();
        object3 = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object3).setNamespaceAware(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object3).newDocumentBuilder();
        this.domDocument = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        object2 = this.domDocument.getFirstChild();
        object2 = object2.getFirstChild();
        while (object2 != null) {
            if (object2.getNodeType() == 1) {
                object = object2.getLocalName();
                if (((String)object).equals("template")) {
                    this.templateNode = object2;
                    this.templateSom = new Xml2SomTemplate((Node)object2);
                } else if (((String)object).equals("datasets")) {
                    this.datasetsNode = object2;
                    this.datasetsSom = new Xml2SomDatasets(object2.getFirstChild());
                }
            }
            object2 = object2.getNextSibling();
        }
    }

    public static void setXfa(byte[] byArray, PdfReader pdfReader, PdfWriter pdfWriter) throws IOException {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfReader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return;
        }
        pdfReader.killXref(pdfDictionary.get(PdfName.XFA));
        PdfStream pdfStream = new PdfStream(byArray);
        pdfStream.flateCompress();
        PdfIndirectReference pdfIndirectReference = pdfWriter.addToBody(pdfStream).getIndirectReference();
        pdfDictionary.put(PdfName.XFA, pdfIndirectReference);
    }

    public void setXfa(PdfWriter pdfWriter) throws IOException {
        XfaForm.setXfa(XfaForm.serializeDoc(this.domDocument), this.reader, pdfWriter);
    }

    public static byte[] serializeDoc(Node node) throws IOException {
        XmlDomWriter xmlDomWriter = new XmlDomWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xmlDomWriter.setOutput(byteArrayOutputStream, null);
        xmlDomWriter.setCanonical(false);
        xmlDomWriter.write(node);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public String findFieldName(String string, AcroFields acroFields) {
        HashMap hashMap = acroFields.getFields();
        if (hashMap.containsKey(string)) {
            return string;
        }
        if (this.acroFieldsSom == null) {
            this.acroFieldsSom = new AcroFieldsSearch(hashMap.keySet());
        }
        if (this.acroFieldsSom.getAcroShort2LongName().containsKey(string)) {
            return (String)this.acroFieldsSom.getAcroShort2LongName().get(string);
        }
        return this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(string));
    }

    public String findDatasetsName(String string) {
        if (this.datasetsSom.getName2Node().containsKey(string)) {
            return string;
        }
        return this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(string));
    }

    public Node findDatasetsNode(String string) {
        if (string == null) {
            return null;
        }
        if ((string = this.findDatasetsName(string)) == null) {
            return null;
        }
        return (Node)this.datasetsSom.getName2Node().get(string);
    }

    public static String getNodeText(Node node) {
        if (node == null) {
            return "";
        }
        return XfaForm.getNodeText(node, "");
    }

    private static String getNodeText(Node node, String string) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                string = XfaForm.getNodeText(node2, string);
            } else if (node2.getNodeType() == 3) {
                string = String.valueOf(string) + node2.getNodeValue();
            }
            node2 = node2.getNextSibling();
        }
        return string;
    }

    public void setNodeText(Node node, String string) {
        if (node == null) {
            return;
        }
        Node node2 = null;
        while ((node2 = node.getFirstChild()) != null) {
            node.removeChild(node2);
        }
        if (node.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            node.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        node.appendChild(this.domDocument.createTextNode(string));
        this.changed = true;
    }

    public void setXfaPresent(boolean bl) {
        this.xfaPresent = bl;
    }

    public void setDomDocument(Document document) {
        this.domDocument = document;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader pdfReader) {
        this.reader = pdfReader;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.templateSom;
    }

    public void setTemplateSom(Xml2SomTemplate xml2SomTemplate) {
        this.templateSom = xml2SomTemplate;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.datasetsSom;
    }

    public void setDatasetsSom(Xml2SomDatasets xml2SomDatasets) {
        this.datasetsSom = xml2SomDatasets;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.acroFieldsSom;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSearch) {
        this.acroFieldsSom = acroFieldsSearch;
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public static class InverseStore {
        protected ArrayList part = new ArrayList();
        protected ArrayList follow = new ArrayList();

        public String getDefaultName() {
            InverseStore inverseStore = this;
            Object e;
            while (!((e = inverseStore.follow.get(0)) instanceof String)) {
                inverseStore = (InverseStore)e;
            }
            return (String)e;
        }

        public boolean isSimilar(String string) {
            int n = string.indexOf(91);
            string = string.substring(0, n + 1);
            int n2 = 0;
            while (n2 < this.part.size()) {
                if (((String)this.part.get(n2)).startsWith(string)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class Stack2
    extends ArrayList {
        private static final long serialVersionUID = -7451476576174095212L;

        public Object peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return this.get(this.size() - 1);
        }

        public Object pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object e = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return e;
        }

        public Object push(Object object) {
            this.add(object);
            return object;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class Xml2Som {
        protected ArrayList order;
        protected HashMap name2Node;
        protected HashMap inverseSearch;
        protected Stack2 stack;
        protected int anform;

        public static String escapeSom(String string) {
            int n = string.indexOf(46);
            if (n < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append('\\');
                n2 = n;
                n = string.indexOf(46, n + 1);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }

        public static String unescapeSom(String string) {
            int n = string.indexOf(92);
            if (n < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n));
                n2 = n + 1;
                n = string.indexOf(92, n + 1);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.stack.size()) {
                stringBuffer.append('.').append((String)this.stack.get(n));
                ++n;
            }
            return stringBuffer.substring(1);
        }

        public static String getShortName(String string) {
            int n = string.indexOf(".#subform[");
            if (n < 0) {
                return string;
            }
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n));
                n = string.indexOf("]", n + 10);
                if (n < 0) {
                    return stringBuffer.toString();
                }
                n2 = n + 1;
                n = string.indexOf(".#subform[", n2);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }

        public void inverseSearchAdd(String string) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, string);
        }

        public static void inverseSearchAdd(HashMap hashMap, Stack2 stack2, String string) {
            String string2 = (String)stack2.peek();
            InverseStore inverseStore = (InverseStore)hashMap.get(string2);
            if (inverseStore == null) {
                inverseStore = new InverseStore();
                hashMap.put(string2, inverseStore);
            }
            int n = stack2.size() - 2;
            while (n >= 0) {
                InverseStore inverseStore2;
                string2 = (String)stack2.get(n);
                int n2 = inverseStore.part.indexOf(string2);
                if (n2 < 0) {
                    inverseStore.part.add(string2);
                    inverseStore2 = new InverseStore();
                    inverseStore.follow.add(inverseStore2);
                } else {
                    inverseStore2 = (InverseStore)inverseStore.follow.get(n2);
                }
                inverseStore = inverseStore2;
                --n;
            }
            inverseStore.part.add("");
            inverseStore.follow.add(string);
        }

        public String inverseSearchGlobal(ArrayList arrayList) {
            if (arrayList.isEmpty()) {
                return null;
            }
            InverseStore inverseStore = (InverseStore)this.inverseSearch.get(arrayList.get(arrayList.size() - 1));
            if (inverseStore == null) {
                return null;
            }
            int n = arrayList.size() - 2;
            while (n >= 0) {
                String string = (String)arrayList.get(n);
                int n2 = inverseStore.part.indexOf(string);
                if (n2 < 0) {
                    if (inverseStore.isSimilar(string)) {
                        return null;
                    }
                    return inverseStore.getDefaultName();
                }
                inverseStore = (InverseStore)inverseStore.follow.get(n2);
                --n;
            }
            return inverseStore.getDefaultName();
        }

        public static Stack2 splitParts(String string) {
            String string2;
            while (string.startsWith(".")) {
                string = string.substring(1);
            }
            Stack2 stack2 = new Stack2();
            int n = 0;
            int n2 = 0;
            while (true) {
                n2 = n;
                while ((n2 = string.indexOf(46, n2)) >= 0 && string.charAt(n2 - 1) == '\\') {
                    ++n2;
                }
                if (n2 < 0) break;
                string2 = string.substring(n, n2);
                if (!string2.endsWith("]")) {
                    string2 = String.valueOf(string2) + "[0]";
                }
                stack2.add(string2);
                n = n2 + 1;
            }
            string2 = string.substring(n);
            if (!string2.endsWith("]")) {
                string2 = String.valueOf(string2) + "[0]";
            }
            stack2.add(string2);
            return stack2;
        }

        public ArrayList getOrder() {
            return this.order;
        }

        public void setOrder(ArrayList arrayList) {
            this.order = arrayList;
        }

        public HashMap getName2Node() {
            return this.name2Node;
        }

        public void setName2Node(HashMap hashMap) {
            this.name2Node = hashMap;
        }

        public HashMap getInverseSearch() {
            return this.inverseSearch;
        }

        public void setInverseSearch(HashMap hashMap) {
            this.inverseSearch = hashMap;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node node) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(node);
        }

        public Node insertNode(Node node, String string) {
            Stack2 stack2 = Xml2SomDatasets.splitParts(string);
            Document document = node.getOwnerDocument();
            Node node2 = null;
            node = node.getFirstChild();
            int n = 0;
            while (n < stack2.size()) {
                Object object;
                String string2 = (String)stack2.get(n);
                int n2 = string2.lastIndexOf("[");
                String string3 = string2.substring(0, n2);
                n2 = Integer.parseInt(string2.substring(n2 + 1, string2.length() - 1));
                int n3 = -1;
                node2 = node.getFirstChild();
                while (node2 != null) {
                    if (node2.getNodeType() == 1 && ((String)(object = Xml2SomDatasets.escapeSom(node2.getLocalName()))).equals(string3) && ++n3 == n2) break;
                    node2 = node2.getNextSibling();
                }
                while (n3 < n2) {
                    node2 = document.createElementNS(null, string3);
                    node2 = node.appendChild(node2);
                    object = document.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    object.setNodeValue("dataGroup");
                    node2.getAttributes().setNamedItemNS((Node)object);
                    ++n3;
                }
                node = node2;
                ++n;
            }
            Xml2SomDatasets.inverseSearchAdd(this.inverseSearch, stack2, string);
            this.name2Node.put(string, node2);
            this.order.add(string);
            return node2;
        }

        private static boolean hasChildren(Node node) {
            Object object;
            Node node2 = node.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (node2 != null) {
                object = node2.getNodeValue();
                if ("dataGroup".equals(object)) {
                    return true;
                }
                if ("dataValue".equals(object)) {
                    return false;
                }
            }
            if (!node.hasChildNodes()) {
                return false;
            }
            object = node.getFirstChild();
            while (object != null) {
                if (object.getNodeType() == 1) {
                    return true;
                }
                object = object.getNextSibling();
            }
            return false;
        }

        private void processDatasetsInternal(Node node) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 1) {
                    String string = Xml2SomDatasets.escapeSom(node2.getLocalName());
                    Integer n = (Integer)hashMap.get(string);
                    n = n == null ? new Integer(0) : new Integer(n + 1);
                    hashMap.put(string, n);
                    if (Xml2SomDatasets.hasChildren(node2)) {
                        this.stack.push(String.valueOf(string) + "[" + n.toString() + "]");
                        this.processDatasetsInternal(node2);
                        this.stack.pop();
                    } else {
                        this.stack.push(String.valueOf(string) + "[" + n.toString() + "]");
                        String string2 = this.printStack();
                        this.order.add(string2);
                        this.inverseSearchAdd(string2);
                        this.name2Node.put(string2, node2);
                        this.stack.pop();
                    }
                }
                node2 = node2.getNextSibling();
            }
        }
    }

    public static class AcroFieldsSearch
    extends Xml2Som {
        private HashMap acroShort2LongName;

        public AcroFieldsSearch(Collection collection) {
            this.inverseSearch = new HashMap();
            this.acroShort2LongName = new HashMap();
            for (String string : collection) {
                String string2 = AcroFieldsSearch.getShortName(string);
                this.acroShort2LongName.put(string2, string);
                AcroFieldsSearch.inverseSearchAdd(this.inverseSearch, AcroFieldsSearch.splitParts(string2), string);
            }
        }

        public HashMap getAcroShort2LongName() {
            return this.acroShort2LongName;
        }

        public void setAcroShort2LongName(HashMap hashMap) {
            this.acroShort2LongName = hashMap;
        }
    }

    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node node) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(node, null);
        }

        public String getFieldType(String string) {
            Node node = (Node)this.name2Node.get(string);
            if (node == null) {
                return null;
            }
            if (node.getLocalName().equals("exclGroup")) {
                return "exclGroup";
            }
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 1 && node2.getLocalName().equals("ui")) break;
                node2 = node2.getNextSibling();
            }
            if (node2 == null) {
                return null;
            }
            Node node3 = node2.getFirstChild();
            while (node3 != null) {
                if (!(node3.getNodeType() != 1 || node3.getLocalName().equals("extras") && node3.getLocalName().equals("picture"))) {
                    return node3.getLocalName();
                }
                node3 = node3.getNextSibling();
            }
            return null;
        }

        private void processTemplate(Node node, HashMap hashMap) {
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
            }
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 1) {
                    Object object;
                    String string = node2.getLocalName();
                    if (string.equals("subform")) {
                        Node node3 = node2.getAttributes().getNamedItem("name");
                        String string2 = "#subform";
                        boolean bl = true;
                        if (node3 != null) {
                            string2 = Xml2SomTemplate.escapeSom(node3.getNodeValue());
                            bl = false;
                        }
                        if (bl) {
                            object = new Integer(this.anform);
                            ++this.anform;
                        } else {
                            object = (Integer)hashMap2.get(string2);
                            object = object == null ? new Integer(0) : new Integer((Integer)object + 1);
                            hashMap2.put(string2, (Integer)object);
                        }
                        this.stack.push(String.valueOf(string2) + "[" + ((Integer)object).toString() + "]");
                        ++this.templateLevel;
                        if (bl) {
                            this.processTemplate(node2, hashMap);
                        } else {
                            this.processTemplate(node2, null);
                        }
                        --this.templateLevel;
                        this.stack.pop();
                    } else if (string.equals("field") || string.equals("exclGroup")) {
                        Node node4 = node2.getAttributes().getNamedItem("name");
                        if (node4 != null) {
                            String string3 = Xml2SomTemplate.escapeSom(node4.getNodeValue());
                            Integer n = (Integer)hashMap.get(string3);
                            n = n == null ? new Integer(0) : new Integer(n + 1);
                            hashMap.put(string3, n);
                            this.stack.push(String.valueOf(string3) + "[" + n.toString() + "]");
                            object = this.printStack();
                            this.order.add(object);
                            this.inverseSearchAdd((String)object);
                            this.name2Node.put(object, node2);
                            this.stack.pop();
                        }
                    } else if (!this.dynamicForm && this.templateLevel > 0 && string.equals("occur")) {
                        int n = 1;
                        int n2 = 1;
                        int n3 = 1;
                        object = node2.getAttributes().getNamedItem("initial");
                        if (object != null) {
                            try {
                                n = Integer.parseInt(object.getNodeValue().trim());
                            }
                            catch (Exception exception) {}
                        }
                        if ((object = node2.getAttributes().getNamedItem("min")) != null) {
                            try {
                                n2 = Integer.parseInt(object.getNodeValue().trim());
                            }
                            catch (Exception exception) {}
                        }
                        if ((object = node2.getAttributes().getNamedItem("max")) != null) {
                            try {
                                n3 = Integer.parseInt(object.getNodeValue().trim());
                            }
                            catch (Exception exception) {}
                        }
                        if (n != n2 || n2 != n3) {
                            this.dynamicForm = true;
                        }
                    }
                }
                node2 = node2.getNextSibling();
            }
        }

        public boolean isDynamicForm() {
            return this.dynamicForm;
        }

        public void setDynamicForm(boolean bl) {
            this.dynamicForm = bl;
        }
    }
}

