/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Map;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public abstract class JRAbstractScriptlet {
    protected Map parametersMap = null;
    protected Map fieldsMap = null;
    protected Map variablesMap = null;
    protected JRFillGroup[] groups = null;

    public void setData(Map map, Map map2, Map map3, JRFillGroup[] jRFillGroupArray) {
        this.parametersMap = map;
        this.fieldsMap = map2;
        this.variablesMap = map3;
        this.groups = jRFillGroupArray;
    }

    public Object getParameterValue(String string) throws JRScriptletException {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter == null) {
            throw new JRScriptletException("Parameter not found : " + string);
        }
        return jRFillParameter.getValue();
    }

    public Object getFieldValue(String string) throws JRScriptletException {
        JRFillField jRFillField = (JRFillField)this.fieldsMap.get(string);
        if (jRFillField == null) {
            throw new JRScriptletException("Field not found : " + string);
        }
        return jRFillField.getValue();
    }

    public Object getVariableValue(String string) throws JRScriptletException {
        JRFillVariable jRFillVariable = (JRFillVariable)this.variablesMap.get(string);
        if (jRFillVariable == null) {
            throw new JRScriptletException("Variable not found : " + string);
        }
        return jRFillVariable.getValue();
    }

    public void setVariableValue(String string, Object object) throws JRScriptletException {
        JRFillVariable jRFillVariable = (JRFillVariable)this.variablesMap.get(string);
        if (jRFillVariable == null) {
            throw new JRScriptletException("Variable not found : " + string);
        }
        if (object != null && !jRFillVariable.getValueClass().isInstance(object)) {
            throw new JRScriptletException("Incompatible value assigned to variable " + string + ". Expected " + jRFillVariable.getValueClassName() + ".");
        }
        jRFillVariable.setValue(object);
    }

    public void callBeforeReportInit() throws JRScriptletException {
        this.beforeReportInit();
        this.beforePageInit();
        this.beforeColumnInit();
        if (this.groups != null && this.groups.length > 0) {
            int n = 0;
            while (n < this.groups.length) {
                this.beforeGroupInit(this.groups[n].getName());
                ++n;
            }
        }
    }

    public void callAfterReportInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            int n = this.groups.length - 1;
            while (n >= 0) {
                this.afterGroupInit(this.groups[n].getName());
                --n;
            }
        }
        this.afterColumnInit();
        this.afterPageInit();
        this.afterReportInit();
    }

    public void callBeforePageInit() throws JRScriptletException {
        this.beforePageInit();
        this.beforeColumnInit();
    }

    public void callAfterPageInit() throws JRScriptletException {
        this.afterColumnInit();
        this.afterPageInit();
    }

    public void callBeforeColumnInit() throws JRScriptletException {
        this.beforeColumnInit();
    }

    public void callAfterColumnInit() throws JRScriptletException {
        this.afterColumnInit();
    }

    public void callBeforeGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup jRFillGroup = null;
            int n = 0;
            while (n < this.groups.length) {
                jRFillGroup = this.groups[n];
                if (jRFillGroup.hasChanged()) {
                    this.beforeGroupInit(jRFillGroup.getName());
                }
                ++n;
            }
        }
    }

    public void callAfterGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup jRFillGroup = null;
            int n = this.groups.length - 1;
            while (n >= 0) {
                jRFillGroup = this.groups[n];
                if (jRFillGroup.hasChanged()) {
                    this.afterGroupInit(jRFillGroup.getName());
                }
                --n;
            }
        }
    }

    public void callBeforeDetailEval() throws JRScriptletException {
        this.beforeDetailEval();
    }

    public void callAfterDetailEval() throws JRScriptletException {
        this.afterDetailEval();
    }

    public abstract void beforeReportInit() throws JRScriptletException;

    public abstract void afterReportInit() throws JRScriptletException;

    public abstract void beforePageInit() throws JRScriptletException;

    public abstract void afterPageInit() throws JRScriptletException;

    public abstract void beforeColumnInit() throws JRScriptletException;

    public abstract void afterColumnInit() throws JRScriptletException;

    public abstract void beforeGroupInit(String var1) throws JRScriptletException;

    public abstract void afterGroupInit(String var1) throws JRScriptletException;

    public abstract void beforeDetailEval() throws JRScriptletException;

    public abstract void afterDetailEval() throws JRScriptletException;
}

