/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.text.MessageFormat;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StackMapFrame
implements Cloneable {
    public static final int USED = 1;
    public static final int SAME_FRAME = 0;
    public static final int CHOP_FRAME = 1;
    public static final int APPEND_FRAME = 2;
    public static final int SAME_FRAME_EXTENDED = 3;
    public static final int FULL_FRAME = 4;
    public static final int SAME_LOCALS_1_STACK_ITEMS = 5;
    public static final int SAME_LOCALS_1_STACK_ITEMS_EXTENDED = 6;
    public int pc;
    public int numberOfStackItems;
    private int numberOfLocals = -1;
    public int localIndex;
    public VerificationTypeInfo[] locals;
    public VerificationTypeInfo[] stackItems;
    private int numberOfDifferentLocals = -1;
    public int tagBits;

    public int getFrameType(StackMapFrame stackMapFrame) {
        int n = this.getOffsetDelta(stackMapFrame);
        switch (this.numberOfStackItems) {
            case 0: {
                switch (this.numberOfDifferentLocals(stackMapFrame)) {
                    case 0: {
                        return n <= 63 ? 0 : 3;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case -3: 
                    case -2: 
                    case -1: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (this.numberOfDifferentLocals(stackMapFrame)) {
                    case 0: {
                        return n <= 63 ? 5 : 6;
                    }
                }
            }
        }
        return 4;
    }

    public void addLocal(int n, VerificationTypeInfo verificationTypeInfo) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[n + 1];
            this.locals[n] = verificationTypeInfo;
        } else {
            int n2 = this.locals.length;
            if (n >= n2) {
                this.locals = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, n2);
            }
            this.locals[n] = verificationTypeInfo;
        }
    }

    public void addStackItem(VerificationTypeInfo verificationTypeInfo) {
        if (this.stackItems == null) {
            this.stackItems = new VerificationTypeInfo[1];
            this.stackItems[0] = verificationTypeInfo;
            this.numberOfStackItems = 1;
        } else {
            int n = this.stackItems.length;
            if (this.numberOfStackItems == n) {
                this.stackItems = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.stackItems, 0, this.stackItems, 0, n);
            }
            this.stackItems[this.numberOfStackItems++] = verificationTypeInfo;
        }
    }

    public void addStackItem(TypeBinding typeBinding) {
        this.addStackItem(new VerificationTypeInfo(typeBinding));
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        int n2;
        StackMapFrame stackMapFrame = (StackMapFrame)super.clone();
        stackMapFrame.numberOfLocals = -1;
        stackMapFrame.numberOfDifferentLocals = -1;
        stackMapFrame.pc = this.pc;
        stackMapFrame.numberOfStackItems = this.numberOfStackItems;
        int n3 = n2 = this.locals == null ? 0 : this.locals.length;
        if (n2 != 0) {
            stackMapFrame.locals = new VerificationTypeInfo[n2];
            n = 0;
            while (n < n2) {
                VerificationTypeInfo verificationTypeInfo = this.locals[n];
                if (verificationTypeInfo != null) {
                    stackMapFrame.locals[n] = (VerificationTypeInfo)verificationTypeInfo.clone();
                }
                ++n;
            }
        }
        if ((n2 = this.numberOfStackItems) != 0) {
            stackMapFrame.stackItems = new VerificationTypeInfo[n2];
            n = 0;
            while (n < n2) {
                stackMapFrame.stackItems[n] = (VerificationTypeInfo)this.stackItems[n].clone();
                ++n;
            }
        }
        return stackMapFrame;
    }

    public int numberOfDiffentStackItems(StackMapFrame stackMapFrame) {
        if (stackMapFrame == null) {
            return this.numberOfStackItems;
        }
        return this.numberOfStackItems - stackMapFrame.numberOfStackItems;
    }

    public int numberOfDifferentLocals(StackMapFrame stackMapFrame) {
        if (this.numberOfDifferentLocals != -1) {
            return this.numberOfDifferentLocals;
        }
        if (stackMapFrame == null) {
            this.numberOfDifferentLocals = 0;
            return 0;
        }
        VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.locals;
        VerificationTypeInfo[] verificationTypeInfoArray2 = this.locals;
        int n = verificationTypeInfoArray == null ? 0 : verificationTypeInfoArray.length;
        int n2 = verificationTypeInfoArray2 == null ? 0 : verificationTypeInfoArray2.length;
        int n3 = stackMapFrame.getNumberOfLocals();
        int n4 = this.getNumberOfLocals();
        int n5 = 0;
        if (n3 == 0) {
            if (n4 != 0) {
                n5 = n4;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2 && n6 < n4) {
                    if (verificationTypeInfoArray2[n7] != null) {
                        switch (verificationTypeInfoArray2[n7].id()) {
                            case 7: 
                            case 8: {
                                ++n7;
                            }
                        }
                        ++n6;
                    } else {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    ++n7;
                }
            }
        } else if (n4 == 0) {
            int n8 = 0;
            n5 = -n3;
            int n9 = 0;
            while (n9 < n && n8 < n3) {
                if (verificationTypeInfoArray[n9] != null) {
                    switch (verificationTypeInfoArray[n9].id()) {
                        case 7: 
                        case 8: {
                            ++n9;
                        }
                    }
                    ++n8;
                } else {
                    this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                    return n5;
                }
                ++n9;
            }
        } else {
            VerificationTypeInfo verificationTypeInfo;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            while (n11 < n2 && n12 < n4) {
                verificationTypeInfo = verificationTypeInfoArray2[n11];
                if (verificationTypeInfo != null) {
                    ++n12;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n11;
                        }
                    }
                }
                if (n10 >= n || n13 >= n3) {
                    if (verificationTypeInfo != null) {
                        ++n5;
                    } else {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    ++n11;
                    break;
                }
                VerificationTypeInfo verificationTypeInfo2 = verificationTypeInfoArray[n10];
                if (verificationTypeInfo2 != null) {
                    ++n13;
                    switch (verificationTypeInfo2.id()) {
                        case 7: 
                        case 8: {
                            ++n10;
                        }
                    }
                }
                if (this.equals(verificationTypeInfo2, verificationTypeInfo) && n10 == n11) {
                    if (n5 != 0) {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                } else {
                    this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                    return n5;
                }
                ++n10;
                ++n11;
            }
            if (n12 < n4) {
                while (n11 < n2 && n12 < n4) {
                    verificationTypeInfo = verificationTypeInfoArray2[n11];
                    if (verificationTypeInfo == null) {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    ++n5;
                    ++n12;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n11;
                        }
                    }
                    ++n11;
                }
            } else if (n13 < n3) {
                n5 = -n5;
                while (n10 < n && n13 < n3) {
                    verificationTypeInfo = verificationTypeInfoArray[n10];
                    if (verificationTypeInfo == null) {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    --n5;
                    ++n13;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n10;
                        }
                    }
                    ++n10;
                }
            }
        }
        this.numberOfDifferentLocals = n5;
        return n5;
    }

    public int getNumberOfLocals() {
        if (this.numberOfLocals != -1) {
            return this.numberOfLocals;
        }
        int n = 0;
        int n2 = this.locals == null ? 0 : this.locals.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.locals[n3] != null) {
                switch (this.locals[n3].id()) {
                    case 7: 
                    case 8: {
                        ++n3;
                    }
                }
                ++n;
            }
            ++n3;
        }
        this.numberOfLocals = n;
        return n;
    }

    public int getOffsetDelta(StackMapFrame stackMapFrame) {
        if (stackMapFrame == null) {
            return this.pc;
        }
        return stackMapFrame.pc == -1 ? this.pc : this.pc - stackMapFrame.pc - 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printFrame(stringBuffer, this);
        return String.valueOf(stringBuffer);
    }

    private void printFrame(StringBuffer stringBuffer, StackMapFrame stackMapFrame) {
        String string = "[pc : {0} locals: {1} stack items: {2}\n{3}\n{4}\n]";
        int n = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
        stringBuffer.append(MessageFormat.format(string, Integer.toString(stackMapFrame.pc), Integer.toString(stackMapFrame.getNumberOfLocals()), Integer.toString(stackMapFrame.numberOfStackItems), this.print(stackMapFrame.locals, n), this.print(stackMapFrame.stackItems, stackMapFrame.numberOfStackItems)));
    }

    private String print(VerificationTypeInfo[] verificationTypeInfoArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (verificationTypeInfoArray != null) {
            int n2 = 0;
            while (n2 < n) {
                if (n2 != 0) {
                    stringBuffer.append(',');
                }
                if (verificationTypeInfoArray[n2] == null) {
                    stringBuffer.append("top");
                } else {
                    switch (verificationTypeInfoArray[n2].tag) {
                        case 5: {
                            stringBuffer.append("null");
                            break;
                        }
                        case 6: {
                            stringBuffer.append("uninitialized_this");
                            break;
                        }
                        case 0: {
                            stringBuffer.append("top");
                            break;
                        }
                        case 8: {
                            stringBuffer.append("uninitialized(").append(verificationTypeInfoArray[n2].readableName()).append(")");
                            break;
                        }
                        default: {
                            stringBuffer.append(verificationTypeInfoArray[n2].readableName());
                        }
                    }
                }
                ++n2;
            }
        }
        stringBuffer.append(']');
        return String.valueOf(stringBuffer);
    }

    public void setTopOfStack(TypeBinding typeBinding) {
        this.stackItems[this.numberOfStackItems - 1].setBinding(typeBinding);
    }

    public void initializeReceiver() {
        if (this.numberOfStackItems > 0) {
            this.stackItems[this.numberOfStackItems - 1].tag = 7;
        }
    }

    public void removeLocals(int n) {
        if (this.locals == null || n < 0) {
            return;
        }
        if (n < this.locals.length) {
            this.locals[n] = null;
        }
    }

    public void putLocal(int n, VerificationTypeInfo verificationTypeInfo) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[n + 1];
            this.locals[n] = verificationTypeInfo;
        } else {
            int n2 = this.locals.length;
            if (n >= n2) {
                this.locals = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, n2);
            }
            this.locals[n] = verificationTypeInfo;
        }
    }

    public void replaceWithElementType() {
        VerificationTypeInfo verificationTypeInfo = this.stackItems[this.numberOfStackItems - 1];
        try {
            VerificationTypeInfo verificationTypeInfo2 = (VerificationTypeInfo)verificationTypeInfo.clone();
            verificationTypeInfo2.replaceWithElementType();
            this.stackItems[this.numberOfStackItems - 1] = verificationTypeInfo2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    public int getIndexOfDifferentLocals(int n) {
        int n2 = this.locals.length - 1;
        while (n2 >= 0) {
            VerificationTypeInfo verificationTypeInfo = this.locals[n2];
            if (verificationTypeInfo != null && --n == 0) {
                return n2;
            }
            --n2;
        }
        return 0;
    }

    private boolean equals(VerificationTypeInfo verificationTypeInfo, VerificationTypeInfo verificationTypeInfo2) {
        if (verificationTypeInfo == null) {
            return verificationTypeInfo2 == null;
        }
        if (verificationTypeInfo2 == null) {
            return false;
        }
        return verificationTypeInfo.equals(verificationTypeInfo2);
    }

    public void mergeLocals(StackMapFrame stackMapFrame) {
        int n = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
        int n2 = this.locals == null ? 0 : this.locals.length;
        int n3 = 0;
        int n4 = Math.min(n, n2);
        while (n3 < n4) {
            VerificationTypeInfo verificationTypeInfo = this.locals[n3];
            VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.locals[n3];
            if (verificationTypeInfo == null) {
                if (verificationTypeInfo2 != null) {
                    this.locals[n3] = verificationTypeInfo2;
                }
            } else if (verificationTypeInfo2 == null) {
                this.locals[n3] = null;
            } else {
                int n5 = verificationTypeInfo.tag;
                int n6 = verificationTypeInfo2.tag;
                if (n5 != n6) {
                    this.locals[n3] = null;
                }
            }
            ++n3;
        }
    }
}

