/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.List;
import java.util.Map;

public class DynaProperty
implements Serializable {
    private static final int BOOLEAN_TYPE = 1;
    private static final int BYTE_TYPE = 2;
    private static final int CHAR_TYPE = 3;
    private static final int DOUBLE_TYPE = 4;
    private static final int FLOAT_TYPE = 5;
    private static final int INT_TYPE = 6;
    private static final int LONG_TYPE = 7;
    private static final int SHORT_TYPE = 8;
    protected String name = null;
    protected transient Class type = null;
    protected transient Class contentType;

    public DynaProperty(String string) {
        this(string, Object.class);
    }

    public DynaProperty(String string, Class clazz) {
        this.name = string;
        this.type = clazz;
    }

    public DynaProperty(String string, Class clazz, Class clazz2) {
        this.name = string;
        this.type = clazz;
        this.contentType = clazz2;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Class getContentType() {
        return this.contentType;
    }

    public boolean isIndexed() {
        if (this.type == null) {
            return false;
        }
        if (this.type.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(this.type);
    }

    public boolean isMapped() {
        if (this.type == null) {
            return false;
        }
        return Map.class.isAssignableFrom(this.type);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DynaProperty[name=");
        stringBuffer.append(this.name);
        stringBuffer.append(",type=");
        stringBuffer.append(this.type);
        if (this.isMapped() || this.isIndexed()) {
            stringBuffer.append(" <").append(this.contentType).append(">");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeAnyClass(this.type, objectOutputStream);
        if (this.isMapped() || this.isIndexed()) {
            this.writeAnyClass(this.contentType, objectOutputStream);
        }
        objectOutputStream.defaultWriteObject();
    }

    private void writeAnyClass(Class clazz, ObjectOutputStream objectOutputStream) throws IOException {
        int n = 0;
        if (Boolean.TYPE.equals(clazz)) {
            n = 1;
        } else if (Byte.TYPE.equals(clazz)) {
            n = 2;
        } else if (Character.TYPE.equals(clazz)) {
            n = 3;
        } else if (Double.TYPE.equals(clazz)) {
            n = 4;
        } else if (Float.TYPE.equals(clazz)) {
            n = 5;
        } else if (Integer.TYPE.equals(clazz)) {
            n = 6;
        } else if (Long.TYPE.equals(clazz)) {
            n = 7;
        } else if (Short.TYPE.equals(clazz)) {
            n = 8;
        }
        if (n == 0) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(clazz);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeInt(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.type = this.readAnyClass(objectInputStream);
        if (this.isMapped() || this.isIndexed()) {
            this.contentType = this.readAnyClass(objectInputStream);
        }
        objectInputStream.defaultReadObject();
    }

    private Class readAnyClass(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readBoolean()) {
            switch (objectInputStream.readInt()) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Character.TYPE;
                }
                case 4: {
                    return Double.TYPE;
                }
                case 5: {
                    return Float.TYPE;
                }
                case 6: {
                    return Integer.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 8: {
                    return Short.TYPE;
                }
            }
            throw new StreamCorruptedException("Invalid primitive type. Check version of beanutils used to serialize is compatible.");
        }
        return (Class)objectInputStream.readObject();
    }
}

