/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;

public class PaintMap
implements Cloneable,
Serializable {
    private transient Map store = new HashMap();

    public Paint getPaint(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return (Paint)this.store.get(comparable);
    }

    public boolean containsKey(Comparable comparable) {
        return this.store.containsKey(comparable);
    }

    public void put(Comparable comparable, Paint paint) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        this.store.put(comparable, paint);
    }

    public void clear() {
        this.store.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PaintMap)) {
            return false;
        }
        PaintMap paintMap = (PaintMap)object;
        if (this.store.size() != paintMap.store.size()) {
            return false;
        }
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            Paint paint;
            Paint paint2 = this.getPaint(comparable);
            if (PaintUtilities.equal(paint2, paint = paintMap.getPaint(comparable))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.store.size());
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            objectOutputStream.writeObject(comparable);
            Paint paint = this.getPaint(comparable);
            SerialUtilities.writePaint(paint, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.store = new HashMap();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Paint paint = SerialUtilities.readPaint(objectInputStream);
            this.store.put(comparable, paint);
            ++n2;
        }
    }
}

