/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.io.File;
import java.util.StringTokenizer;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNome;

public class IdentificadorDeclaracao
extends ObjetoNegocio {
    public static final String DEC_COMPLETA = "0";
    public static final String DEC_SIMPLIFICADA = "1";
    private CPF cpf = new CPF(this, "CPF");
    private Alfa nome = new Alfa(this, "Nome", 60);
    private Alfa exercicio = new Alfa(this, "Exerc\u00edcio", 4);
    private Logico transmitida = new Logico(this, "");
    private Alfa tipoDeclaracao = new Alfa(this, "Tipo da Declara\u00e7\u00e3o", 5);
    private Alfa declaracaoRetificadora = new Alfa(this, "\u00c9 Retificadora?", 2);
    private Alfa numReciboDecRetif = new Alfa(this, "N\u00ba do Recibo Dec. Anterior", 12);
    private Alfa numeroReciboDecAnterior = new Alfa(this, "N\u00ba do Recibo Dec. Exerc\u00edcio Anterior", 12);
    private Alfa enderecoDiferente = new Alfa(this, "Endere\u00e7o Novo?", 2);

    public IdentificadorDeclaracao() {
        this.transmitida.converteEmTipoSimNao(Logico.NAO);
        this.cpf.addValidador(new ValidadorCPF(3));
        this.nome.addValidador(new ValidadorNaoNulo(3));
        this.nome.addValidador(new ValidadorNome(3));
        this.nome.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                StringTokenizer stringTokenizer = new StringTokenizer(IdentificadorDeclaracao.this.getNome().asString(), " ");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(String.valueOf(stringTokenizer.nextToken()) + " ");
                }
                IdentificadorDeclaracao.this.getNome().setConteudo(stringBuffer.toString().trim());
            }
        });
        ValidadorNaoNulo validadorNaoNulo = new ValidadorNaoNulo(3);
        validadorNaoNulo.setMensagemValidacao(this.tab.msg("dec_retificadora"));
        this.declaracaoRetificadora.addValidador(validadorNaoNulo);
        ValidadorNaoNulo validadorNaoNulo2 = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (IdentificadorDeclaracao.this.declaracaoRetificadora.asString().equals(Logico.NAO) || IdentificadorDeclaracao.this.declaracaoRetificadora.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        };
        validadorNaoNulo2.setMensagemValidacao(this.tab.msg("num_recibo_dec_retif"));
        this.numReciboDecRetif.addValidador(validadorNaoNulo2);
        this.numReciboDecRetif.addValidador(new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                if (IdentificadorDeclaracao.this.declaracaoRetificadora.asString().equals(Logico.NAO)) {
                    return null;
                }
                if (Validador.validarNrRecibo(this.getInformacao().asString())) {
                    return null;
                }
                return new RetornoValidacao(tab.msg("num_recibo_invalido"), this.getSeveridade());
            }
        });
        this.tipoDeclaracao.setConteudo(DEC_COMPLETA);
        ValidadorNaoNulo validadorNaoNulo3 = new ValidadorNaoNulo(3);
        validadorNaoNulo3.setMensagemValidacao(this.tab.msg("endereco_diferente"));
        this.getEnderecoDiferente().addValidador(validadorNaoNulo3);
        this.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
    }

    public boolean isDeclaracaoGerada() {
        return true;
    }

    public String getPathArquivo() {
        String string = IRPFUtil.DIR_DADOS;
        String string2 = String.valueOf(string) + "/" + this.cpf.asString();
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("/" + this.cpf.asString());
        stringBuffer.append(".xml");
        return stringBuffer.toString();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Alfa getExercicio() {
        return this.exercicio;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.declaracaoRetificadora;
    }

    public Alfa getNumReciboDecRetif() {
        return this.numReciboDecRetif;
    }

    public Logico getTransmitida() {
        return this.transmitida;
    }

    public boolean equals(Object object) {
        return object instanceof IdentificadorDeclaracao && ((IdentificadorDeclaracao)object).getCpf().asString().equals(this.getCpf().asString());
    }

    public Alfa getTipoDeclaracao() {
        return this.tipoDeclaracao;
    }

    public boolean isCompleta() {
        return this.getTipoDeclaracao().asString().equals(DEC_COMPLETA);
    }

    public boolean isRetificadora() {
        return this.getDeclaracaoRetificadora().asString().equals(Logico.SIM);
    }

    public Alfa getEnderecoDiferente() {
        return this.enderecoDiferente;
    }

    public void setNumeroReciboDecAnterior(Alfa alfa) {
        this.numeroReciboDecAnterior = alfa;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.numeroReciboDecAnterior;
    }
}

