/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";
    Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public String destinationPath;
    public String[] destinationPaths;
    public boolean generatePackagesStructure;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount;
    public String log;
    public Logger logger;
    public int maxProblems;
    public boolean noWarn = false;
    public Map options;
    PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public boolean showProgress = false;
    public long startTime;
    public boolean systemExitWhenFinished = true;
    public long[] times;
    public int timesCounter;
    public boolean timing = false;
    public boolean verbose = false;

    public static boolean compile(String string) {
        return Main.compile(string, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false).compile(Main.tokenize(string));
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") || string2.endsWith(".zip");
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isDirectory()) {
                fileArray2[n2] = file.listFiles(filenameFilter);
            }
            ++n2;
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = "";
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = String.valueOf(stringArray[n2]) + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = "";
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = String.valueOf(stringArray[n3]) + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = String.valueOf(stringArray[n4]) + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map);
        this.relocalize();
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, boolean bl) throws InvalidInputException {
        AccessRule[] accessRuleArray;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            String[] stringArray;
            accessRuleArray = new AccessRule[arrayList2.size()];
            boolean bl2 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                char c = stringArray.charAt(0);
                String string3 = stringArray.substring(1);
                if (string3.length() > 0) {
                    switch (c) {
                        case '+': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0);
                            break;
                        }
                        case '~': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000118);
                            break;
                        }
                        case '-': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000133);
                            break;
                        }
                        case '?': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000133, true);
                            break;
                        }
                        default: {
                            bl2 = false;
                            break;
                        }
                    }
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                stringArray = new String[]{this.bind("template.restrictedAccess.type", new String[]{"{0}", string}), this.bind("template.restrictedAccess.constructor", new String[]{"{0}", string}), this.bind("template.restrictedAccess.method", new String[]{"{0}", "{1}", string}), this.bind("template.restrictedAccess.field", new String[]{"{0}", "{1}", string})};
                accessRuleSet = new AccessRuleSet(accessRuleArray, stringArray);
            } else {
                this.logger.logIncorrectClasspath(string);
                return;
            }
        }
        if ((accessRuleArray = FileSystem.getClasspath(string, string2, bl, accessRuleSet)) != null) {
            arrayList.add(accessRuleArray);
        } else {
            this.logger.logIncorrectClasspath(string);
        }
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    /*
     * Unable to fully structure code
     */
    public boolean compile(String[] var1_1) {
        try {
            try {
                this.configure(var1_1);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    var2_2 = 0;
                    while (var2_2 < this.repetitions) {
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(var2_2, this.repetitions);
                        }
                        this.performCompilation();
                        ++var2_2;
                    }
                    if (this.times != null) {
                        this.logger.logAverage(this.times, this.lineCount);
                    }
                    if (this.showProgress) {
                        this.logger.printNewLine();
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException var2_3) {
                this.logger.logException(var2_3);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
lbl36:
                // 5 sources

                while (true) {
                    this.logger.flush();
                    this.logger.close();
                    return false;
                }
            }
            catch (RuntimeException var2_4) {
                this.logger.logException(var2_4);
                if (!this.systemExitWhenFinished) ** GOTO lbl36
                this.logger.flush();
                this.logger.close();
                System.exit(-1);
                ** continue;
            }
        }
        finally {
            this.logger.flush();
            this.logger.close();
        }
        return this.globalErrorsCount == 0;
    }

    protected void handleWarningToken(String string, boolean bl, boolean bl2) throws InvalidInputException {
        if (string.equals("constructorName")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", bl ? "warning" : "ignore");
        } else if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", bl ? "warning" : "ignore");
        } else if (string.equals("maskedCatchBlock") || string.equals("maskedCatchBlocks")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
        } else if (string.equals("deprecation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        } else if (string.equals("allDeprecation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
        } else if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
        } else if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
        } else if (string.equals("unusedImport") || string.equals("unusedImports")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
        } else if (string.equals("unusedPrivate")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
        } else if (string.equals("unusedLabel")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("localHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
        } else if (string.equals("fieldHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
        } else if (string.equals("specialParamHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
        } else if (string.equals("conditionAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", bl ? "warning" : "ignore");
        } else if (string.equals("nls")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", bl ? "warning" : "ignore");
        } else if (string.equals("staticReceiver")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
        } else if (string.equals("indirectStatic")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("noEffectAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", bl ? "warning" : "ignore");
        } else if (string.equals("charConcat") || string.equals("noImplicitStringConversion")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", bl ? "warning" : "ignore");
        } else if (string.equals("semicolon")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", bl ? "warning" : "ignore");
        } else if (string.equals("serial")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", bl ? "warning" : "ignore");
        } else if (string.equals("emptyBlock")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", bl ? "warning" : "ignore");
        } else if (string.equals("uselessTypeCheck")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", bl ? "warning" : "ignore");
        } else if (string.equals("unchecked") || string.equals("unsafe")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", bl ? "warning" : "ignore");
        } else if (string.equals("raw")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", bl ? "warning" : "ignore");
        } else if (string.equals("finalBound")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", bl ? "warning" : "ignore");
        } else if (string.equals("suppress")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
        } else if (string.equals("warningToken")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", bl ? "warning" : "ignore");
        } else if (string.equals("unnecessaryElse")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", bl ? "warning" : "ignore");
        } else if (string.equals("javadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
            }
        } else if (string.equals("allJavadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
            }
        } else if (string.startsWith("tasks")) {
            String string2 = "";
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            if (n >= 0 && n2 >= 0 && n < n2) {
                string2 = string.substring(n + 1, n2).trim();
                string2 = string2.replace('|', ',');
            }
            if (string2.length() == 0) {
                throw new InvalidInputException(this.bind("configure.invalidTaskTag", string));
            }
            this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string2 : "");
        } else if (string.equals("assertIdentifier")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("enumIdentifier")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("finally")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", bl ? "warning" : "ignore");
        } else if (string.equals("unusedThrown")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
        } else if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", bl ? "warning" : "ignore");
        } else if (string.equals("typeHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("varargsCast")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", bl ? "warning" : "ignore");
        } else if (string.equals("null")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", bl ? "warning" : "ignore");
        } else if (string.equals("boxing")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", bl ? "warning" : "ignore");
        } else if (string.equals("over-ann")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("dep-ann")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("intfAnnotation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", bl ? "warning" : "ignore");
        } else if (string.equals("enumSwitch") || string.equals("incomplete-switch")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", bl ? "warning" : "ignore");
        } else if (string.equals("hiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("static-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("unused")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("paramAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("discouraged")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.discouragedReference", bl ? "warning" : "ignore");
        } else if (string.equals("forbidden")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", bl ? "warning" : "ignore");
        } else if (string.equals("fallthrough")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", bl ? "warning" : "ignore");
        } else {
            throw new InvalidInputException(this.bind("configure.invalidWarning", string));
        }
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.logger.logIncorrectExtDirsEntry(object[n2].getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.logger.logIncorrectEndorsedDirsEntry(object[n2].getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public void configure(String[] var1_1) throws InvalidInputException {
        if (var1_1 == null || var1_1.length == 0) {
            this.printUsage();
            return;
        }
        var2_2 = new ArrayList<String>(4);
        var3_3 = null;
        var4_4 = new ArrayList<String>(4);
        var5_5 = new ArrayList<String>(4);
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        var10_10 = var1_1.length;
        var11_11 = 0;
        this.repetitions = 0;
        var12_12 = false;
        var13_13 = false;
        var14_14 = false;
        var15_15 = false;
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = null;
        var20_20 = null;
        var21_21 = "";
        var22_22 = false;
        var23_23 = 0;
        while (var23_23 < var10_10) {
            if (var1_1[var23_23].startsWith("@")) {
                var22_22 = true;
                break;
            }
            ++var23_23;
        }
        var23_24 = null;
        if (var22_22) {
            var23_24 = new String[var10_10];
            var8_8 = 0;
            var24_25 = 0;
            while (var24_25 < var10_10) {
                var25_38 = null;
                var26_44 = var1_1[var24_25].trim();
                if (var26_44.startsWith("@")) {
                    try {
                        var27_48 = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(var26_44.substring(1)), null))));
                        var28_53 = new StringBuffer();
                        while ((var29_56 = var27_48.readLine()) != null) {
                            if ((var29_56 = var29_56.trim()).startsWith("#")) continue;
                            var28_53.append(var29_56).append(" ");
                        }
                        var25_38 = Main.tokenize(var28_53.toString());
                    }
                    catch (IOException v0) {
                        throw new InvalidInputException(this.bind("configure.invalidexpansionargumentname", var26_44));
                    }
                }
                if (var25_38 != null) {
                    var27_49 = var23_24.length;
                    var28_54 = var25_38.length;
                    v1 = var23_24;
                    var23_24 = new String[var27_49 + var28_54 - 1];
                    System.arraycopy(v1, 0, var23_24, 0, var8_8);
                    System.arraycopy(var25_38, 0, var23_24, var8_8, var28_54);
                    var8_8 += var28_54;
                } else {
                    var23_24[var8_8++] = var26_44;
                }
                ++var24_25;
            }
            var8_8 = -1;
        } else {
            var23_24 = var1_1;
            var24_25 = 0;
            while (var24_25 < var10_10) {
                var23_24[var24_25] = var23_24[var24_25].trim();
                ++var24_25;
            }
        }
        var10_10 = var23_24.length;
        block33: while (++var8_8 < var10_10) {
            if (var19_19 != null) {
                throw new InvalidInputException(this.bind("configure.unexpectedCustomEncoding", var21_21, var19_19));
            }
            var21_21 = var23_24[var8_8];
            switch (var11_11) {
                case 0: {
                    var19_19 = null;
                    if (var21_21.endsWith("]")) {
                        var24_26 = var21_21.indexOf(91) + 1;
                        var25_40 = var21_21.length() - 1;
                        if (var24_26 >= 1) {
                            if (var24_26 < var25_40) {
                                var19_19 = var21_21.substring(var24_26, var25_40);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var19_19);
                                }
                                catch (UnsupportedEncodingException v2) {
                                    throw new InvalidInputException(this.bind("configure.unsupportedEncoding", var19_19));
                                }
                            }
                            var21_21 = var21_21.substring(0, var24_26 - 1);
                        }
                    }
                    if (var21_21.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[var10_10 - var8_8];
                            this.encodings = new String[var10_10 - var8_8];
                        } else if (var9_9 == this.filenames.length) {
                            var24_27 = this.filenames.length;
                            this.filenames = new String[var24_27 + var10_10 - var8_8];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, var24_27);
                            this.encodings = new String[var24_27 + var10_10 - var8_8];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, var24_27);
                        }
                        this.filenames[var9_9] = var21_21;
                        this.encodings[var9_9++] = var19_19;
                        var19_19 = null;
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-log")) {
                        if (this.log != null) {
                            throw new InvalidInputException(this.bind("configure.duplicateLog", var21_21));
                        }
                        var11_11 = 5;
                        break;
                    }
                    if (var21_21.equals("-repeat")) {
                        if (this.repetitions > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateRepeat", var21_21));
                        }
                        var11_11 = 6;
                        break;
                    }
                    if (var21_21.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateMaxProblems", var21_21));
                        }
                        var11_11 = 11;
                        break;
                    }
                    if (var21_21.equals("-source")) {
                        var11_11 = 7;
                        break;
                    }
                    if (var21_21.equals("-encoding")) {
                        var11_11 = 8;
                        break;
                    }
                    if (var21_21.equals("-1.3")) {
                        if (var18_18) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var21_21));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-1.4")) {
                        if (var18_18) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var21_21));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-1.5") || var21_21.equals("-5") || var21_21.equals("-5.0")) {
                        if (var18_18) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var21_21));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-1.6") || var21_21.equals("-6") || var21_21.equals("-6.0")) {
                        if (var18_18) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var21_21));
                        }
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-d")) {
                        if (this.destinationPath != null) {
                            var24_28 = new StringBuffer();
                            var24_28.append(var21_21);
                            if (var8_8 + 1 < var10_10) {
                                var24_28.append(' ');
                                var24_28.append(var23_24[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateOutputPath", var24_28.toString()));
                        }
                        var11_11 = 3;
                        break;
                    }
                    if (var21_21.equals("-classpath") || var21_21.equals("-cp")) {
                        var11_11 = 1;
                        break;
                    }
                    if (var21_21.equals("-bootclasspath")) {
                        if (var2_2.size() > 0) {
                            var24_29 = new StringBuffer();
                            var24_29.append(var21_21);
                            if (var8_8 + 1 < var10_10) {
                                var24_29.append(' ');
                                var24_29.append(var23_24[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateBootClasspath", var24_29.toString()));
                        }
                        var11_11 = 9;
                        break;
                    }
                    if (var21_21.equals("-sourcepath")) {
                        if (var4_4.size() > 0) {
                            var24_30 = new StringBuffer();
                            var24_30.append(var21_21);
                            if (var8_8 + 1 < var10_10) {
                                var24_30.append(' ');
                                var24_30.append(var23_24[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateSourcepath", var24_30.toString()));
                        }
                        var11_11 = 13;
                        break;
                    }
                    if (var21_21.equals("-extdirs")) {
                        if (var6_6 != null) {
                            var24_31 = new StringBuffer();
                            var24_31.append(var21_21);
                            if (var8_8 + 1 < var10_10) {
                                var24_31.append(' ');
                                var24_31.append(var23_24[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateExtDirs", var24_31.toString()));
                        }
                        var11_11 = 12;
                        break;
                    }
                    if (var21_21.equals("-endorseddirs")) {
                        if (var7_7 != null) {
                            var24_32 = new StringBuffer();
                            var24_32.append(var21_21);
                            if (var8_8 + 1 < var10_10) {
                                var24_32.append(' ');
                                var24_32.append(var23_24[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateEndorsedDirs", var24_32.toString()));
                        }
                        var11_11 = 15;
                        break;
                    }
                    if (var21_21.equals("-progress")) {
                        var11_11 = 0;
                        this.showProgress = true;
                        break;
                    }
                    if (var21_21.equals("-proceedOnError")) {
                        var11_11 = 0;
                        this.proceedOnError = true;
                        break;
                    }
                    if (var21_21.equals("-time")) {
                        var11_11 = 0;
                        this.timing = true;
                        break;
                    }
                    if (var21_21.equals("-version") || var21_21.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (var21_21.equals("-showversion")) {
                        var13_13 = true;
                        var11_11 = 0;
                        break;
                    }
                    if ("-deprecation".equals(var21_21)) {
                        var15_15 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-help") || var21_21.equals("-?")) {
                        var12_12 = true;
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-verbose")) {
                        this.verbose = true;
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-inlineJSR")) {
                        var11_11 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        break;
                    }
                    if (var21_21.startsWith("-g")) {
                        var11_11 = 0;
                        var24_33 = var21_21;
                        var25_41 = var21_21.length();
                        if (var25_41 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            break;
                        }
                        if (var25_41 > 3) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                            if (var25_41 == 7 && var24_33.equals("-g:none")) continue block33;
                            var26_45 = new StringTokenizer(var24_33.substring(3, var24_33.length()), ",");
                            while (var26_45.hasMoreTokens()) {
                                var27_50 = var26_45.nextToken();
                                if (var27_50.equals("vars")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (var27_50.equals("lines")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (var27_50.equals("source")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new InvalidInputException(this.bind("configure.invalidDebugOption", var24_33));
                            }
                            continue block33;
                        }
                        throw new InvalidInputException(this.bind("configure.invalidDebugOption", var24_33));
                    }
                    if (var21_21.startsWith("-nowarn")) {
                        this.disableWarnings();
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.startsWith("-warn")) {
                        var11_11 = 0;
                        var24_34 = var21_21;
                        var25_42 = var21_21.length();
                        if (var25_42 == 10 && var24_34.equals("-warn:none")) {
                            this.disableWarnings();
                            break;
                        }
                        if (var25_42 <= 6) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningConfiguration", var24_34));
                        }
                        switch (var24_34.charAt(6)) {
                            case '+': {
                                var26_46 = 7;
                                var27_51 = true;
                                break;
                            }
                            case '-': {
                                var26_46 = 7;
                                var27_51 = false;
                                break;
                            }
                            default: {
                                var26_46 = 6;
                                if (!var16_16) {
                                    this.disableWarnings();
                                }
                                var27_51 = true;
                            }
                        }
                        var28_55 = new StringTokenizer(var24_34.substring(var26_46, var24_34.length()), ",");
                        var29_58 = 0;
                        if (var15_15) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (var28_55.hasMoreTokens()) {
                            var30_59 = var28_55.nextToken();
                            ++var29_58;
                            this.handleWarningToken(var30_59, var27_51, var17_17);
                        }
                        if (var29_58 == 0) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningOption", var21_21));
                        }
                        var16_16 = true;
                        break;
                    }
                    if (var21_21.equals("-target")) {
                        var11_11 = 4;
                        break;
                    }
                    if (var21_21.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-enableJavadoc")) {
                        var11_11 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        var17_17 = true;
                        break;
                    }
                    if (var21_21.equals("-Xemacs")) {
                        var11_11 = 0;
                        this.logger.setEmacs();
                        break;
                    }
                    if (var21_21.startsWith("-X")) {
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.startsWith("-J")) {
                        var11_11 = 0;
                        break;
                    }
                    if (var21_21.equals("-O")) {
                        var11_11 = 0;
                        break;
                    }
                    ** GOTO lbl520
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new InvalidInputException(this.bind("configure.duplicateTarget", var21_21));
                    }
                    this.didSpecifyTarget = true;
                    if (var21_21.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (var21_21.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (var21_21.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (var21_21.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (var21_21.equals("1.5") || var21_21.equals("5") || var21_21.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (var21_21.equals("1.6") || var21_21.equals("6") || var21_21.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (var21_21.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        throw new InvalidInputException(this.bind("configure.targetJDK", var21_21));
                    }
                    var11_11 = 0;
                    break;
                }
                case 5: {
                    this.log = var21_21;
                    var11_11 = 0;
                    break;
                }
                case 6: {
                    try {
                        this.repetitions = Integer.parseInt(var21_21);
                        if (this.repetitions <= 0) {
                            throw new InvalidInputException(this.bind("configure.repetition", var21_21));
                        }
                    }
                    catch (NumberFormatException v3) {
                        throw new InvalidInputException(this.bind("configure.repetition", var21_21));
                    }
                    var11_11 = 0;
                    break;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(var21_21);
                        if (this.maxProblems <= 0) {
                            throw new InvalidInputException(this.bind("configure.maxProblems", var21_21));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", var21_21);
                    }
                    catch (NumberFormatException v4) {
                        throw new InvalidInputException(this.bind("configure.maxProblems", var21_21));
                    }
                    var11_11 = 0;
                    break;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new InvalidInputException(this.bind("configure.duplicateSource", var21_21));
                    }
                    this.didSpecifySource = true;
                    if (var21_21.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (var21_21.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (var21_21.equals("1.5") || var21_21.equals("5") || var21_21.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (var21_21.equals("1.6") || var21_21.equals("6") || var21_21.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else {
                        throw new InvalidInputException(this.bind("configure.source", var21_21));
                    }
                    var11_11 = 0;
                    break;
                }
                case 8: {
                    if (var14_14) {
                        throw new InvalidInputException(this.bind("configure.duplicateDefaultEncoding", var21_21));
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var21_21);
                    }
                    catch (UnsupportedEncodingException v5) {
                        throw new InvalidInputException(this.bind("configure.unsupportedEncoding", var21_21));
                    }
                    this.options.put("org.eclipse.jdt.core.encoding", var21_21);
                    var14_14 = true;
                    var11_11 = 0;
                    break;
                }
                case 3: {
                    if (!var21_21.equals("none")) {
                        this.setDestinationPath(var21_21);
                    }
                    var11_11 = 0;
                    break;
                }
                case 1: {
                    var5_5.add(var21_21);
                    var11_11 = 0;
                    break;
                }
                case 9: {
                    var2_2.add(var21_21);
                    var11_11 = 0;
                    break;
                }
                case 13: {
                    var4_4.add(var21_21);
                    var11_11 = 0;
                    break;
                }
                case 12: {
                    var24_35 = new StringTokenizer(var21_21, File.pathSeparator, false);
                    var6_6 = new ArrayList<String>(4);
                    while (var24_35.hasMoreTokens()) {
                        var6_6.add(var24_35.nextToken());
                    }
                    var11_11 = 0;
                    break;
                }
                case 15: {
                    var24_36 = new StringTokenizer(var21_21, File.pathSeparator, false);
                    var7_7 = new ArrayList<String>(4);
                    while (var24_36.hasMoreTokens()) {
                        var7_7.add(var24_36.nextToken());
                    }
                    var11_11 = 0;
                    break;
                }
lbl520:
                // 2 sources

                default: {
                    var20_20 = File.separatorChar == '/' ? var21_21 : var21_21.replace('/', File.separatorChar);
                    var24_37 = new File(var20_20);
                    if (!var24_37.isDirectory()) {
                        throw new InvalidInputException(this.bind("configure.directoryNotExist", var20_20));
                    }
                    var25_43 = FileFinder.find(var24_37, ".JAVA");
                    if (this.filenames != null) {
                        var26_47 = var25_43.length;
                        this.filenames = new String[var26_47 + var9_9];
                        System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
                        this.encodings = new String[var26_47 + var9_9];
                        System.arraycopy(this.encodings, 0, this.encodings, 0, var9_9);
                        System.arraycopy(var25_43, 0, this.filenames, var9_9, var26_47);
                        var27_52 = 0;
                        while (var27_52 < var26_47) {
                            this.encodings[var9_9 + var27_52] = var19_19;
                            ++var27_52;
                        }
                        var9_9 += var26_47;
                        var19_19 = null;
                        var20_20 = null;
                    } else {
                        this.filenames = var25_43;
                        var9_9 = this.filenames.length;
                        this.encodings = new String[var9_9];
                        var26_47 = 0;
                        while (var26_47 < var9_9) {
                            this.encodings[var26_47] = var19_19;
                            ++var26_47;
                        }
                        var19_19 = null;
                        var20_20 = null;
                    }
                    var11_11 = 0;
                }
            }
        }
        if (var12_12 || var9_9 == 0) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(var13_13);
        this.validateOptions(var18_18);
        this.logger.logCommandLineArguments(var23_24);
        this.logger.logOptions(this.options);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
        if (var9_9 != 0) {
            this.filenames = new String[var9_9];
            System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
        }
        this.setPaths(var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var19_19);
    }

    protected void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Map.Entry entry = (Map.Entry)objectArray[n];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++n;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                int n;
                if (compilationResult.lineSeparatorPositions != null) {
                    n = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)n;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    n = Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && n > 0) {
                        CompilationUnitDeclaration[] compilationUnitDeclarationArray = Main.this.batchCompiler.unitsToProcess;
                        int n2 = 0;
                        int n3 = Main.this.batchCompiler.totalUnits;
                        while (n2 < n3) {
                            CompilationResult compilationResult2;
                            CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
                            if (compilationUnitDeclaration != null && (compilationResult2 = compilationUnitDeclaration.compilationResult).hasProblems() && !compilationResult2.hasBeenAccepted) {
                                Main.this.logger.logProblems(compilationResult2.getAllProblems(), compilationResult2.compilationUnit.getContents(), Main.this);
                            }
                            ++n2;
                        }
                        Main.this.logger.endLoggingSource();
                        Main.this.logger.endLoggingSources();
                        Main.this.logger.printStats();
                        Main.this.logger.flush();
                        Main.this.logger.close();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(string)) {
            string = null;
        }
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = this.filenames[n2].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new InvalidInputException(this.bind("unit.more", this.filenames[n2]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[n2]);
            if (!file.exists()) {
                throw new InvalidInputException(this.bind("unit.missing", this.filenames[n2]));
            }
            String string2 = this.encodings[n2];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[n2] = new CompilationUnit(null, this.filenames[n2], string2);
            ++n2;
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String string = System.getProperty("java.home");
            if (string != null) {
                this.javaHomeCache = new File(string);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.out = printWriter;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            for (Object k : map.keySet()) {
                this.options.put(k, map.get(k));
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            if (!this.generatePackagesStructure) {
                this.destinationPath = this.extractDestinationPathFromSourceFile(compilationResult);
            }
            if (this.destinationPath != null) {
                int n = 0;
                int n2 = classFileArray.length;
                while (n < n2) {
                    ClassFile classFile = classFileArray[n];
                    char[] cArray = classFile.fileName();
                    int n3 = cArray.length;
                    char[] cArray2 = new char[n3 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n3, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string}));
                        }
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, string, classFile);
                        LookupEnvironment lookupEnvironment = this.batchCompiler.lookupEnvironment;
                        if (classFile.isShared) {
                            lookupEnvironment.classFilePool.release(classFile);
                        }
                        this.logger.logClassFile(this.generatePackagesStructure, this.destinationPath, string);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(this.destinationPath, string, iOException);
                    }
                    ++n;
                }
            }
        }
    }

    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler((INameEnvironment)fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out);
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        finally {
            this.logger.endLoggingSources();
        }
        this.logger.printStats();
        fileSystem.cleanup();
    }

    public void printUsage() {
        this.logger.logUsage(this.bind("misc.usage", new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) throws InvalidInputException {
        String string3 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparator) + "[]", true);
        int n2 = 0;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens() && n2 != 99) {
            string4 = stringTokenizer.nextToken();
            if (string4.equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, bl);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
                continue;
            }
            if (string4.equals("[")) {
                switch (n2) {
                    case 1: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
                continue;
            }
            if (string4.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
                continue;
            }
            switch (n2) {
                case 0: 
                case 3: {
                    n2 = 1;
                    string3 = string4;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 6;
                    arrayList2.add(string4);
                    break;
                }
                default: {
                    n2 = 99;
                }
            }
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, bl);
                break;
            }
            default: {
                this.logger.logIncorrectClasspath(string);
            }
        }
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    public void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setDestinationPath(String string) {
        this.destinationPath = string;
        this.generatePackagesStructure = true;
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) throws InvalidInputException {
        Object object;
        File[][] fileArray;
        Object object2;
        File file = this.getJavaHome();
        int n = arrayList.size();
        if (n != 0) {
            object2 = new String[n];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            int n2 = 0;
            while (n2 < n) {
                this.processPathEntries(4, arrayList, (String)object2[n2], string2, false, false);
                ++n2;
            }
        } else {
            object2 = System.getProperty("java.version");
            if (object2 != null && ((String)object2).equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return;
            }
            if (file != null) {
                File[] fileArray2 = null;
                fileArray2 = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(file, "../Classes")} : new File[]{new File(file, "lib")};
                fileArray = Main.getLibrariesFiles(fileArray2);
                if (fileArray != null) {
                    int n3 = 0;
                    int n4 = fileArray.length;
                    while (n3 < n4) {
                        File[] fileArray3 = fileArray[n3];
                        if (fileArray3 != null) {
                            int n5 = 0;
                            int n6 = fileArray3.length;
                            while (n5 < n6) {
                                FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray3[n5].getAbsolutePath(), null, false, null);
                                if (classpath != null) {
                                    arrayList.add(classpath);
                                }
                                ++n5;
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
        int n7 = arrayList3.size();
        if (arrayList3.size() != 0) {
            object = new String[n7];
            arrayList3.toArray((T[])object);
            arrayList3.clear();
            int n8 = 0;
            while (n8 < n7) {
                this.processPathEntries(4, arrayList3, (String)object[n8], string2, false, false);
                ++n8;
            }
        } else {
            object = System.getProperty("java.class.path");
            if (object == null || ((String)object).length() == 0) {
                this.logger.logNoClasspath();
                arrayList3.add(FileSystem.getClasspath(System.getProperty("user.dir"), string2, null));
            } else {
                fileArray = new StringTokenizer((String)object, File.pathSeparator);
                while (fileArray.hasMoreTokens()) {
                    String string3 = fileArray.nextToken();
                    FileSystem.Classpath classpath = FileSystem.getClasspath(string3, string2, null);
                    if (classpath != null) {
                        arrayList3.add(classpath);
                        continue;
                    }
                    this.logger.logIncorrectClasspath(string3);
                }
            }
        }
        int n9 = arrayList2.size();
        if (n9 != 0) {
            String[] stringArray = new String[n9];
            arrayList2.toArray(stringArray);
            arrayList2.clear();
            int n10 = 0;
            while (n10 < n9) {
                this.processPathEntries(4, arrayList2, stringArray[n10], string2, true, false);
                ++n10;
            }
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    protected void validateOptions(boolean bl) throws InvalidInputException {
        Object v;
        if (bl) {
            v = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                }
            } else if ("1.5".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        if (this.didSpecifySource) {
            v = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        v = this.options.get("org.eclipse.jdt.core.compiler.source");
        Object v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (v.equals("1.6") && CompilerOptions.versionToJdkLevel(v2) < 0x320000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (v.equals("1.5") && CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (v.equals("1.4") && CompilerOptions.versionToJdkLevel(v2) < 0x300000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new InvalidInputException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    public static class Logger {
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String EXCEPTION = "exception";
        private static final HashMap FIELD_TABLE = new HashMap();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_ID = "id";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.002 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_002.dtd\">";
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;

        static {
            try {
                Class<IProblem> clazz = IProblem.class;
                Field[] fieldArray = clazz.getFields();
                int n = 0;
                int n2 = fieldArray.length;
                while (n < n2) {
                    Field field = fieldArray[n];
                    FIELD_TABLE.put(field.get(null), field.getName());
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            ((GenericXMLWriter)this.log).endTag(string, true, true);
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            char c;
            int n;
            int n2 = categorizedProblem.getSourceStart();
            if (n2 > (n = categorizedProblem.getSourceEnd()) || n2 < 0 && n < 0) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                return;
            }
            int n3 = cArray.length;
            int n4 = n2 >= n3 ? n3 - 1 : n2;
            while (n4 > 0) {
                c = cArray[n4 - 1];
                if (c == '\n' || c == '\r') break;
                --n4;
            }
            int n5 = n >= n3 ? n3 - 1 : n;
            while (n5 + 1 < n3) {
                c = cArray[n5 + 1];
                if (c == '\r' || c == '\n') break;
                ++n5;
            }
            while ((c = cArray[n4]) == ' ' || c == '\t') {
                ++n4;
            }
            while ((c = cArray[n5]) == ' ' || c == '\t') {
                --n5;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n4, n5 - n4 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n2 - n4));
            this.parameters.put(SOURCE_END, Integer.toString(n - n4));
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            return (String)FIELD_TABLE.get(new Integer(n));
        }

        public void logAverage(long[] lArray, long l) {
            Arrays.sort(lArray);
            int n = lArray.length;
            long l2 = 0L;
            int n2 = 1;
            int n3 = n - 1;
            while (n2 < n3) {
                l2 += lArray[n2];
                ++n2;
            }
            long l3 = l2 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l3), String.valueOf((double)((int)((double)l * 10000.0 / (double)l3)) / 10.0)}));
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n + 1, n2) : String.valueOf(string) + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    String string = classpathArray[n2].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isArchiveFileName(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 != null) {
                        this.parameters.put("id", string2);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++n2;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    this.parameters.put("value", stringArray[n2]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n2;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.getBuffer().toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        public void logIncorrectClasspath(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectClasspath", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectClasspath", string));
        }

        public void logIncorrectEndorsedDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectEndorsedDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectEndorsedDirsEntry", string));
        }

        public void logIncorrectExtDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectExtDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectExtDirsEntry", string));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNoClasspath() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.keySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray);
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Object object = objectArray[n];
                    this.parameters.put(KEY, object);
                    this.parameters.put("value", map.get(object));
                    this.printTag(OPTION, this.parameters, true, true);
                    ++n;
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = String.valueOf(new String(categorizedProblem.getOriginatingFileName())) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = ((DefaultProblem)categorizedProblem).errorReportSource(cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = ((DefaultProblem)categorizedProblem).errorReportSource(cArray);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                if ((this.tagBits & 1) != 0) {
                    CategorizedProblem categorizedProblem;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n) {
                        categorizedProblem = categorizedProblemArray[n7];
                        if (categorizedProblem != null) {
                            ++main.globalProblemsCount;
                            this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                            ++n3;
                            if (categorizedProblem.isError()) {
                                ++n2;
                                ++n4;
                                ++main.globalErrorsCount;
                            } else if (categorizedProblem.getID() == 536871362) {
                                ++main.globalTasksCount;
                                ++n6;
                            } else {
                                ++main.globalWarningsCount;
                                ++n5;
                            }
                        }
                        ++n7;
                    }
                    if (n4 + n5 != 0) {
                        this.startLoggingProblems(n4, n5);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                                this.logXmlProblem(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingProblems();
                    }
                    if (n6 != 0) {
                        this.startLoggingTasks(n6);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() == 536871362) {
                                this.logXmlTask(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingTasks();
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n) {
                        if (categorizedProblemArray[n8] != null) {
                            ++main.globalProblemsCount;
                            this.logProblem(categorizedProblemArray[n8], n3, main.globalProblemsCount, cArray);
                            ++n3;
                            if (categorizedProblemArray[n8].isError()) {
                                ++n2;
                                ++main.globalErrorsCount;
                            } else {
                                ++main.globalWarningsCount;
                            }
                        }
                        ++n8;
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(long l, long l2) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", String.valueOf(l)));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            this.parameters.put("id", this.getFieldName(categorizedProblem.getID()));
            this.parameters.put(PROBLEM_SEVERITY, categorizedProblem.isError() ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            String[] stringArray = categorizedProblem.getArguments();
            int n3 = stringArray.length;
            if (n3 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                int n4 = 0;
                while (n4 < n3) {
                    this.parameters.put("value", stringArray[n4]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n4;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl = this.main.timing;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                long l = System.currentTimeMillis() - this.main.startTime;
                this.logTiming(l, this.main.lineCount);
                if (this.main.times != null) {
                    this.main.times[this.main.timesCounter++] = l;
                }
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) throws InvalidInputException {
            block6: {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
                try {
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        if (string.substring(n).toLowerCase().equals(".xml")) {
                            this.log = new GenericXMLWriter((OutputStream)new FileOutputStream(string, false), Util.LINE_SEPARATOR, true);
                            this.tagBits |= 1;
                            try {
                                this.log.println("<!-- " + new String(dateFormat.format(date).getBytes(), "UTF-8") + " -->");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                            this.log.println(XML_DTD_DECLARATION);
                            this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                            this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                            this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                            this.printTag(COMPILER, this.parameters, true, false);
                            break block6;
                        }
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                        break block6;
                    }
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InvalidInputException(this.main.bind("configure.cannotOpenLog"));
                }
            }
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                char[] cArray = iCompilationUnit.getFileName();
                File file = new File(new String(cArray));
                if (cArray != null && iCompilationUnit != null) {
                    this.parameters.put(PATH, file.getAbsolutePath());
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }
}

