/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class StandardEntityCollection
implements EntityCollection,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5384773031184897047L;
    private List entities = new ArrayList();

    public int getEntityCount() {
        return this.entities.size();
    }

    public ChartEntity getEntity(int n) {
        return (ChartEntity)this.entities.get(n);
    }

    public void clear() {
        this.entities.clear();
    }

    public void add(ChartEntity chartEntity) {
        if (chartEntity == null) {
            throw new IllegalArgumentException("Null 'entity' argument.");
        }
        this.entities.add(chartEntity);
    }

    public void addAll(EntityCollection entityCollection) {
        this.entities.addAll(entityCollection.getEntities());
    }

    public ChartEntity getEntity(double d, double d2) {
        int n = this.entities.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(n2);
            if (chartEntity.getArea().contains(d, d2)) {
                return chartEntity;
            }
            --n2;
        }
        return null;
    }

    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    public Iterator iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StandardEntityCollection) {
            StandardEntityCollection standardEntityCollection = (StandardEntityCollection)object;
            return ObjectUtilities.equal(this.entities, standardEntityCollection.entities);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardEntityCollection standardEntityCollection = (StandardEntityCollection)super.clone();
        standardEntityCollection.entities = new ArrayList(this.entities.size());
        int n = 0;
        while (n < this.entities.size()) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(n);
            standardEntityCollection.entities.add(chartEntity.clone());
            ++n;
        }
        return standardEntityCollection;
    }
}

