/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.resumo.ObservadorCalcImpostoHabilitaDesabilita;
import serpro.ppgd.irpf.resumo.ObservadorCalcQuotas;
import serpro.ppgd.irpf.resumo.ObservadorDebitoAutomatico;
import serpro.ppgd.irpf.resumo.ValidadorInfoBancariasVazias;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class CalculoImposto
extends ObjetoNegocio {
    public static final String CAMPO_DEBITO_AUTOMATICO = "D\u00e9bito autom\u00e1tico";
    private Valor baseCalculo = new Valor(this, "");
    private Valor imposto = new Valor(this, "");
    private Valor deducaoIncentivo = new Valor(this, "");
    private Valor totalContribEmpregadoDomestico = new Valor(this, "");
    private Valor impostoDevido = new Valor(this, "");
    private Valor impostoDevidoII = new Valor(this, "");
    private Valor impostoRetidoFonteTitular = new Valor(this, "");
    private Valor impostoRetidoFonteDependentes = new Valor(this, "");
    private Valor carneLeao = new Valor(this, "");
    private Valor impostoComplementar = new Valor(this, "");
    private Valor impostoPagoExterior = new Valor(this, "");
    private Valor impostoRetidoFonteLei11033 = new Valor(this, "");
    private Valor totalImpostoPago = new Valor(this, "");
    private Valor impostoRestituir = new Valor(this, "");
    private Logico debitoAutomatico = new Logico(this, "D\u00e9bito autom\u00e1tico");
    private Alfa indicadorPrimeiraQuota = new Alfa(this, "");
    private Codigo banco = new Codigo(this, "Banco", CadastroTabelasIRPF.recuperarBancos());
    private Alfa agencia = new Alfa(this, "Ag\u00eancia");
    private Alfa contaCredito = new Alfa(this, "Conta para d\u00e9bito");
    private Alfa dvContaCredito = new Alfa(this, "");
    private Valor saldoImpostoPagar = new Valor(this, "");
    private Inteiro numQuotas = new Inteiro(this, "");
    private Valor valorQuota = new Valor(this, "");
    private Valor impostoEspecie = new Valor(this, "");
    private Valor rendPJRecebidoTitular = new Valor(this, "");
    private Valor rendPJRecebidoDependentes = new Valor(this, "");
    private Valor rendPFEXTRecebidoTitular = new Valor(this, "");
    private Valor rendPFEXTRecebidoDependentes = new Valor(this, "");
    private Valor resultadoTributavelAR = new Valor(this, "");
    private Valor totalResultadosTributaveis = new Valor(this, "");
    private Valor descontoSimplificado = new Valor(this, "");
    private Valor carneLeaoMaisImpostoComplementar = new Valor(this, "");
    private ObservadorCalcImpostoHabilitaDesabilita observadorCalcImpostoHabilitaDesabilita = new ObservadorCalcImpostoHabilitaDesabilita(this);
    private ObservadorDebitoAutomatico observadorDebitoAutomatico;
    private IdentificadorDeclaracao identificadorDec;

    public CalculoImposto(IdentificadorDeclaracao identificadorDeclaracao, Contribuinte contribuinte) {
        this.setFicha("C\u00e1lculo do Imposto");
        this.identificadorDec = identificadorDeclaracao;
        this.observadorDebitoAutomatico = new ObservadorDebitoAutomatico(this, this.identificadorDec, contribuinte);
        this.getImposto().setReadOnly(true);
        this.getDeducaoIncentivo().setReadOnly(true);
        this.getTotalContribEmpregadoDomestico().setReadOnly(true);
        this.getImpostoDevido().setReadOnly(true);
        this.getImpostoDevidoII().setReadOnly(true);
        this.getCarneLeao().setReadOnly(true);
        this.getImpostoComplementar().setReadOnly(true);
        this.getImpostoPagoExterior().setReadOnly(true);
        this.getTotalImpostoPago().setReadOnly(true);
        this.getRendPJRecebidoTitular().setReadOnly(true);
        this.getRendPJRecebidoDependentes().setReadOnly(true);
        this.getRendPFEXTRecebidoTitular().setReadOnly(true);
        this.getRendPFEXTRecebidoDependentes().setReadOnly(true);
        this.getResultadoTributavelAR().setReadOnly(true);
        this.getTotalResultadosTributaveis().setReadOnly(true);
        this.getDescontoSimplificado().setReadOnly(true);
        this.getBaseCalculo().setReadOnly(true);
        this.getImpostoRetidoFonteTitular().setReadOnly(true);
        this.getImpostoRetidoFonteDependentes().setReadOnly(true);
        this.getCarneLeaoMaisImpostoComplementar().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033().setReadOnly(true);
        this.getSaldoImpostoPagar().setReadOnly(true);
        this.getImpostoRestituir().setReadOnly(true);
        this.getValorQuota().setReadOnly(true);
        this.getDebitoAutomatico().addOpcao("autorizado", "Sim");
        this.getDebitoAutomatico().addOpcao("N", "N\u00e3o");
        this.getDebitoAutomatico().setConteudo("N");
        this.getDebitoAutomatico().addObservador(this.observadorDebitoAutomatico);
        this.identificadorDec.getDeclaracaoRetificadora().addObservador(this.observadorDebitoAutomatico);
        contribuinte.getExterior().addObservador(this.observadorDebitoAutomatico);
        this.observadorDebitoAutomatico.habilitadesabilitaDadosBancarios();
        this.getSaldoImpostoPagar().addObservador(this.observadorCalcImpostoHabilitaDesabilita);
        this.getSaldoImpostoPagar().addObservador(this.observadorDebitoAutomatico);
        this.observadorCalcImpostoHabilitaDesabilita.habilitadesabilitaDados();
        this.getImpostoRestituir().addObservador(this.observadorCalcImpostoHabilitaDesabilita);
        this.getImpostoRestituir().addObservador(this.observadorDebitoAutomatico);
        this.getDebitoAutomatico().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (!CalculoImposto.this.getDebitoAutomatico().isHabilitado()) {
                    return null;
                }
                this.setMensagemValidacao(tab.msg("debito_autom"));
                return super.validarImplementado();
            }
        });
        this.getIndicadorPrimeiraQuota().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (CalculoImposto.this.getIndicadorPrimeiraQuota().isReadOnly()) {
                    return null;
                }
                this.setMensagemValidacao(tab.msg("quota_vazia"));
                return super.validarImplementado();
            }
        });
        this.getNumQuotas().setLimiteMinimo(1);
        this.getNumQuotas().setLimiteMaximo(8);
        this.getNumQuotas().addObservador(new ObservadorCalcQuotas(this));
        this.getSaldoImpostoPagar().addObservador(new ObservadorCalcQuotas(this));
        this.getBanco().addValidador(new ValidadorInfoBancariasVazias(3, this));
    }

    public Alfa getAgencia() {
        return this.agencia;
    }

    public Codigo getBanco() {
        return this.banco;
    }

    public Valor getBaseCalculo() {
        return this.baseCalculo;
    }

    public Valor getCarneLeao() {
        return this.carneLeao;
    }

    public Alfa getContaCredito() {
        return this.contaCredito;
    }

    public Valor getDeducaoIncentivo() {
        return this.deducaoIncentivo;
    }

    public Alfa getDvContaCredito() {
        return this.dvContaCredito;
    }

    public Valor getImposto() {
        return this.imposto;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Inteiro getNumQuotas() {
        return this.numQuotas;
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor getValorQuota() {
        return this.valorQuota;
    }

    public Valor getCarneLeaoMaisImpostoComplementar() {
        return this.carneLeaoMaisImpostoComplementar;
    }

    public Valor getDescontoSimplificado() {
        return this.descontoSimplificado;
    }

    public Valor getRendPJRecebidoDependentes() {
        return this.rendPJRecebidoDependentes;
    }

    public Valor getRendPFEXTRecebidoDependentes() {
        return this.rendPFEXTRecebidoDependentes;
    }

    public Valor getRendPJRecebidoTitular() {
        return this.rendPJRecebidoTitular;
    }

    public Valor getRendPFEXTRecebidoTitular() {
        return this.rendPFEXTRecebidoTitular;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getTotalResultadosTributaveis() {
        return this.totalResultadosTributaveis;
    }

    public Logico getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }

    public Valor getImpostoEspecie() {
        return this.impostoEspecie;
    }

    public void setImpostoEspecie(Valor valor) {
        this.impostoEspecie = valor;
    }

    public Alfa getIndicadorPrimeiraQuota() {
        return this.indicadorPrimeiraQuota;
    }

    public void setQuota(Alfa alfa) {
        this.indicadorPrimeiraQuota = alfa;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getBanco());
        list.add(this.getAgencia());
        list.add(this.getContaCredito());
        list.add(this.getDebitoAutomatico());
        list.add(this.getIndicadorPrimeiraQuota());
        list.add(this.getSaldoImpostoPagar());
        return list;
    }
}

