/* ModeloDeclaracao - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class ModeloDeclaracao extends ObjetoNegocio
{
  public static final String LIMITE_ANUAL_27_MEIO_PORCENT = "51.259,08";
  public static final String LIMITE_ANUAL_22_MEIO_PORCENT = "41.023,09";
  public static final String LIMITE_ANUAL_15_PORCENT = "30.766,93";
  public static final String LIMITE_ANUAL_7_MEIO_PORCENT = "20.529,37";
  public static final String LIMITE_MENSAL_27_MEIO_PORCENT = "9.486,91";
  public static final String LIMITE_MENSAL_22_MEIO_PORCENT = "6.923,95";
  public static final String LIMITE_MENSAL_15_PORCENT = "3.847,22";
  public static final String LIMITE_MENSAL_7_MEIO_PORCENT = "1.539,70";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_27_MEIO_PORCENT = "790,5758";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_22_MEIO_PORCENT = "576,9958";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_15_PORCENT = "320,6016";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_7_MEIO_PORCENT = "128,3083";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_27_MEIO_PORCENT = "4.271,59";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_22_MEIO_PORCENT = "3.418,59";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_15_PORCENT = "2.563,91";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_7_MEIO_PORCENT = "1.710,78";
  public static final String NOME_TOTAL_REND_RECEB_MAIS_EXTERIOR = "Total de Rendimentos Recebidos";
  public static final String NOME_TOTAL_LIVRO_CAIXA_TIT_DEP = "Total Livro Caixa - TIT + DEP";
  protected DeclaracaoIRPF declaracaoIRPF = null;
  protected Valor impostoDevido = new Valor (this, "");
  protected Valor impostoDevidoII = new Valor (this, "");
  protected Valor baseCalculo = new Valor (this, "");
  protected Valor saldoImpostoPagar = new Valor (this, "");
  protected Valor impostoRestituir = new Valor (this, "");
  protected Valor rendRecebidoExterior = new Valor (this, "");
  protected Valor totalRendRecebidosMaisExterior = new Valor (this, "Total de Rendimentos Recebidos");
  protected Valor totalLivroCaixa = new Valor (this, "Total Livro Caixa - TIT + DEP");
  protected Valor totalDoacoesCampanhasEleitorais = new Valor (this, "");
  
  public ModeloDeclaracao (DeclaracaoIRPF dec)
  {
    declaracaoIRPF = dec;
    totalRendRecebidosMaisExterior.setReadOnly (true);
  }
  
  public Valor getTotalRendRecebidosMaisExterior ()
  {
    return totalRendRecebidosMaisExterior;
  }
  
  public Valor getTotalLivroCaixa ()
  {
    return totalLivroCaixa;
  }
  
  public Valor calculaImposto (Valor _baseCalculo)
  {
    Valor retorno = new Valor ();
    /* FIXME: cálculos para declaração de espólio e saída não usam
     * todos os meses.  */
    if (_baseCalculo.comparacao ("<", LIMITE_ANUAL_7_MEIO_PORCENT))
      retorno.clear ();
    else if (_baseCalculo.comparacao ("<", LIMITE_ANUAL_15_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,075"));
	imposto.append ('-', LIMITE_MENSAL_7_MEIO_PORCENT);
	retorno.setConteudo (imposto);
      }
    else if (_baseCalculo.comparacao ("<", LIMITE_ANUAL_22_MEIO_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,15"));
	imposto.append ('-', LIMITE_MENSAL_15_PORCENT);
	retorno.setConteudo (imposto);
      }
    else if (_baseCalculo.comparacao ("<", LIMITE_ANUAL_27_MEIO_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,225"));
	imposto.append ('-', LIMITE_MENSAL_22_MEIO_PORCENT);
	retorno.setConteudo (imposto);
      }
    else
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo);
	imposto.converteQtdCasasDecimais (3);
	imposto.setConteudo (imposto.operacao ('*', "0,275"));
	imposto.append ('-', LIMITE_MENSAL_27_MEIO_PORCENT);
	imposto.converteQtdCasasDecimais (2);
	retorno.setConteudo (imposto);
      }
    return retorno;
  }
  
  public Valor getImpostoDevido ()
  {
    return impostoDevido;
  }
  
  public Valor getBaseCalculo ()
  {
    return baseCalculo;
  }
  
  public Valor getSaldoImpostoPagar ()
  {
    return saldoImpostoPagar;
  }
  
  public Valor getImpostoRestituir ()
  {
    return impostoRestituir;
  }
  
  public Valor getRendRecebidoExterior ()
  {
    return rendRecebidoExterior;
  }
  
  public abstract void resumoRendimentosTributaveis ();
  
  public abstract void resumoCalculoImposto ();
  
  public abstract void resumoOutrasInformacoes ();
  
  public abstract void aplicaValoresNaDeclaracao ();
  
  public abstract Valor recuperarTotalRendimentosTributaveis ();
  
  public abstract Valor recuperarTotalImpostoPago ();
  
  public String recuperarCodInImpostoAntecipado ()
  {
    String string = "0";
    if (! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteTitular ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteDependentes ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoComplementar ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getCarneLeao ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteLei11033 ().isVazio ())
      string = "1";
    return string;
  }
  
  public abstract String recuperarCodInImpostoPago ();
  
  public Valor getImpostoDevidoII ()
  {
    return impostoDevidoII;
  }
}
