/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;

import serpro.ppgd.irpf.ColecaoItemQuadroAuxiliar;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva
extends ObjetoNegocio {
    private Valor decimoTerceiro = new Valor();
    private Valor ganhosCapital = new Valor();
    private Valor ganhosCapitalEstrangeira = new Valor();
    private Valor ganhosCapitalEmEspecie = new Valor();
    private Valor ganhosRendaVariavel = new Valor();
    private Valor rendAplicacoes = new Valor();
    private ColecaoItemQuadroAuxiliar rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroAuxiliar();
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar;
    private Valor decimoTerceiroDependentes = new Valor();
    private Valor rendExcetoDecimoTerceiro = new Valor();
    private ColecaoItemQuadroAuxiliar rendExcetoDecimoTerceiroQuadroAuxiliar = new ColecaoItemQuadroAuxiliar();
    private Valor total = new Valor();

    public RendTributacaoExclusiva(DeclaracaoIRPF declaracaoIRPF) {
        this.outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Outros rendimentos de tributa\u00e7\u00e3o exclusiva na fonte");
        this.getDecimoTerceiro().setReadOnly(true);
        this.getGanhosCapital().setReadOnly(true);
        this.getGanhosCapitalEstrangeira().setReadOnly(true);
        this.getGanhosCapitalEmEspecie().setReadOnly(true);
        this.getGanhosRendaVariavel().setReadOnly(true);
        this.getDecimoTerceiroDependentes().setReadOnly(true);
        this.getTotal().setReadOnly(true);
    }

    public void addObservador(Observador observador) {
        this.ganhosCapital.addObservador(observador);
        this.ganhosCapitalEstrangeira.addObservador(observador);
        this.ganhosCapitalEmEspecie.addObservador(observador);
        this.ganhosRendaVariavel.addObservador(observador);
        this.rendAplicacoes.addObservador(observador);
        this.outrosQuadroAuxiliar.addObservador(observador);
        this.decimoTerceiroDependentes.addObservador(observador);
        this.rendExcetoDecimoTerceiro.addObservador(observador);
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public ColecaoItemQuadroAuxiliar getRendAplicacoesQuadroAuxiliar() {
        return this.rendAplicacoesQuadroAuxiliar;
    }

    public ColecaoItemQuadroAuxiliar getRendExcetoDecimoTerceiroQuadroAuxiliar() {
        return this.rendExcetoDecimoTerceiroQuadroAuxiliar;
    }

    public Valor getTotal() {
        return this.total;
    }

    public void setTotal(Valor valor) {
        this.total = valor;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public void setDecimoTerceiro(Valor valor) {
        this.decimoTerceiro = valor;
    }

    public Valor getDecimoTerceiroDependentes() {
        return this.decimoTerceiroDependentes;
    }

    public void setDecimoTerceiroDependentes(Valor valor) {
        this.decimoTerceiroDependentes = valor;
    }

    public Valor getGanhosCapital() {
        return this.ganhosCapital;
    }

    public void setGanhosCapital(Valor valor) {
        this.ganhosCapital = valor;
    }

    public Valor getGanhosCapitalEmEspecie() {
        return this.ganhosCapitalEmEspecie;
    }

    public void setGanhosCapitalEmEspecie(Valor valor) {
        this.ganhosCapitalEmEspecie = valor;
    }

    public Valor getGanhosCapitalEstrangeira() {
        return this.ganhosCapitalEstrangeira;
    }

    public void setGanhosCapitalEstrangeira(Valor valor) {
        this.ganhosCapitalEstrangeira = valor;
    }

    public Valor getGanhosRendaVariavel() {
        return this.ganhosRendaVariavel;
    }

    public void setGanhosRendaVariavel(Valor valor) {
        this.ganhosRendaVariavel = valor;
    }

    public Valor getOutros() {
        return this.getOutrosQuadroAuxiliar().getTotais();
    }

    public Valor getRendAplicacoes() {
        return this.rendAplicacoes;
    }

    public void setRendAplicacoes(Valor valor) {
        this.rendAplicacoes = valor;
    }

    public Valor getRendExcetoDecimoTerceiro() {
        return this.rendExcetoDecimoTerceiro;
    }

    public void setRendExcetoDecimoTerceiro(Valor valor) {
        this.rendExcetoDecimoTerceiro = valor;
    }

    public Valor recuperarExclusivosTitular() {
        Valor valor = new Valor();
        valor.append('+', this.ganhosCapital);
        valor.append('+', this.ganhosCapitalEstrangeira);
        valor.append('+', this.ganhosCapitalEmEspecie);
        valor.append('+', this.decimoTerceiro);
        valor.append('+', this.rendAplicacoes);
        valor.append('+', this.getOutros());
        valor.append('+', this.ganhosRendaVariavel);
        return valor;
    }

    public Valor recuperarExclusivosDependentes() {
        return this.decimoTerceiroDependentes.operacao('+', this.rendExcetoDecimoTerceiro);
    }

    public Valor recuperarTotalTitularExceto13_RV_e_GC() {
        return this.getRendAplicacoes().operacao('+', this.getOutros());
    }
}

