/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.negocio.Valor;

public class ModeloCompleta
extends ModeloDeclaracao {
    public static final String CONTRIB_EMPR_MAX = "1.200,32";
    private Valor rendRecebidoPJTitular = new Valor(this, "");
    private Valor rendRecebidoPJDependentes = new Valor(this, "");
    private Valor rendRecebidoPFEXTTitular = new Valor(this, "");
    private Valor rendRecebidoPFEXTDependentes = new Valor(this, "");
    private Valor resultadoTributavelAR = new Valor(this, "");
    private Valor totalRendimentos = new Valor(this, "");
    private Valor previdenciaOficial = new Valor(this, "");
    private Valor previdenciaFAPI = new Valor(this, "");
    private Valor deducaoDependentes = new Valor(this, "");
    private Valor despesasInstrucao = new Valor(this, "");
    private Valor despesasMedicas = new Valor(this, "");
    private Valor pensaoAlimenticia = new Valor(this, "");
    private Valor pensaoCartoral = new Valor(this, "");
    private Valor livroCaixa = new Valor(this, "");
    private Valor totalDeducoes = new Valor(this, "");
    private Valor totalContribEmpregadoDomestico = new Valor(this, "");
    private Valor imposto = new Valor(this, "");
    private Valor deducaoIncentivo = new Valor(this, "");
    private Valor impostoRetidoFonteTitular = new Valor(this, "");
    private Valor impostoRetidoFonteDependentes = new Valor(this, "");
    private Valor carneLeao = new Valor(this, "");
    private Valor impostoComplementar = new Valor(this, "");
    private Valor impostoPagoExterior = new Valor(this, "");
    private Valor impostoRetidoFonteLei11033 = new Valor(this, "");
    private Valor totalImpostoPago = new Valor(this, "");
    private Valor bensDireitosExercicioAnterior = new Valor(this, "");
    private Valor bensDireitosExercicioAtual = new Valor(this, "");
    private Valor dividasExercicioAnterior = new Valor(this, "");
    private Valor dividasExercicioAtual = new Valor(this, "");
    private Valor rendIsentosNaoTributaveis = new Valor(this, "");
    private Valor rendSujeitoTribExclusiva = new Valor(this, "");
    private Valor impostoPagoGCAP = new Valor(this, "");
    private Valor impostoPagoME = new Valor(this, "");
    private Valor totalImpostoRetidoNaFonte = new Valor(this, "");
    private Valor impostoPagoSobreRendaVariavel = new Valor(this, "");

    public ModeloCompleta(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF);
    }

    public void resumoRendimentosTributaveis() {
        this.rendRecebidoPJTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        this.rendRecebidoPJDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        this.rendRecebidoPFEXTTitular.clear();
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPessoaFisica());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoPFEXTDependentes.clear();
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPessoaFisica());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.rendRecebidoExterior.clear();
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.resultadoTributavelAR.clear();
        if (this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
        }
        if (this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        }
        this.totalRendimentos.clear();
        this.totalRendimentos.append('+', this.rendRecebidoPJTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPJDependentes);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTDependentes);
        this.totalRendimentos.append('+', this.resultadoTributavelAR);
        this.previdenciaOficial.clear();
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial());
        this.previdenciaFAPI.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFAPI());
        this.deducaoDependentes.setConteudo(this.declaracaoIRPF.getDependentes().getTotalDeducaoDependentes());
        this.despesasInstrucao.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDeducoesInstrucao());
        this.despesasMedicas.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDespesasMedicas());
        this.pensaoAlimenticia.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalPensao());
        this.pensaoCartoral.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalPensaoCartoral());
        this.livroCaixa.clear();
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalLivroCaixa());
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalLivroCaixa());
        this.totalDeducoes.clear();
        this.totalDeducoes.append('+', this.previdenciaOficial);
        this.totalDeducoes.append('+', this.previdenciaFAPI);
        this.totalDeducoes.append('+', this.deducaoDependentes);
        this.totalDeducoes.append('+', this.despesasInstrucao);
        this.totalDeducoes.append('+', this.despesasMedicas);
        this.totalDeducoes.append('+', this.pensaoAlimenticia);
        this.totalDeducoes.append('+', this.pensaoCartoral);
        this.totalDeducoes.append('+', this.livroCaixa);
    }

    public void resumoCalculoImposto() {
        this.baseCalculo.clear();
        this.baseCalculo.append('+', this.totalRendimentos);
        this.baseCalculo.append('-', this.totalDeducoes);
        if (this.baseCalculo.comparacao("<", "0,00")) {
            this.baseCalculo.clear();
        }
        this.imposto.setConteudo(this.calculaImposto(this.baseCalculo));
        this.deducaoIncentivo.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDeducaoIncentivo());
        this.impostoDevido.clear();
        this.impostoDevido.append('+', this.imposto);
        this.impostoDevido.append('-', this.deducaoIncentivo);
        if (this.impostoDevido.comparacao("<", "0,00")) {
            this.impostoDevido.clear();
        }
        this.totalContribEmpregadoDomestico.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico());
        if (this.totalContribEmpregadoDomestico.comparacao(">", CONTRIB_EMPR_MAX)) {
            this.totalContribEmpregadoDomestico.setConteudo(CONTRIB_EMPR_MAX);
        }
        this.impostoDevidoII.clear();
        this.impostoDevidoII.append('+', this.impostoDevido);
        this.impostoDevidoII.append('-', this.totalContribEmpregadoDomestico);
        if (this.impostoDevidoII.comparacao("<", "0,00")) {
            this.impostoDevidoII.clear();
        }
        this.aliquotaEfetiva.clear();
        if (this.totalRendimentos.comparacao(">", "0,00")) {
            this.aliquotaEfetiva.append('+', this.impostoDevidoII);
            this.aliquotaEfetiva.append('*', "100,00");
            this.aliquotaEfetiva.append('/', this.totalRendimentos);
        }
        this.impostoRetidoFonteTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisImpostoRetidoFonte());
        this.carneLeao.clear();
        this.carneLeao.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalDarfPago());
        this.carneLeao.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalDarfPago());
        this.impostoComplementar.setConteudo(this.declaracaoIRPF.getImpostoPago().getImpostoComplementar());
        Valor valor = new Valor();
        this.aplicaLimitesImpostoPagoExterior(valor);
        this.impostoPagoExterior.setConteudo(valor);
        this.impostoRetidoFonteLei11033.setConteudo(this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.totalImpostoPago.clear();
        this.totalImpostoPago.append('+', this.impostoRetidoFonteTitular);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteDependentes);
        this.totalImpostoPago.append('+', this.carneLeao);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteLei11033);
        this.totalImpostoPago.append('+', this.impostoComplementar);
        this.totalImpostoPago.append('+', this.impostoPagoExterior);
        this.saldoImpostoPagar.clear();
        this.impostoRestituir.clear();
        if (this.impostoDevidoII.comparacao("<", this.totalImpostoPago)) {
            this.impostoRestituir.clear();
            this.impostoRestituir.append('+', this.totalImpostoPago);
            this.impostoRestituir.append('-', this.impostoDevidoII);
        } else {
            this.saldoImpostoPagar.clear();
            this.saldoImpostoPagar.append('+', this.impostoDevidoII);
            this.saldoImpostoPagar.append('-', this.totalImpostoPago);
        }
    }

    public void resumoOutrasInformacoes() {
        this.bensDireitosExercicioAnterior.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAnterior());
        this.bensDireitosExercicioAtual.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAtual());
        this.dividasExercicioAnterior.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAnterior());
        this.dividasExercicioAtual.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAtual());
        this.rendIsentosNaoTributaveis.setConteudo(this.declaracaoIRPF.getRendIsentos().getTotal());
        this.rendSujeitoTribExclusiva.setConteudo(this.declaracaoIRPF.getRendTributacaoExclusiva().getTotal());
        this.impostoPagoGCAP.setConteudo(this.declaracaoIRPF.getGanhosDeCapital().getTotalImpostoPagoSobreGanhosCapital());
        this.impostoPagoME.setConteudo(this.declaracaoIRPF.getMoedaEstrangeira().getTotalImpostoPagoSobreGanhosCapital());
        this.totalImpostoRetidoNaFonte.clear();
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        Valor valor = new Valor(this.declaracaoIRPF.getRendaVariavel().getTotalImpostoPago().asString());
        valor.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoPagoComFundInvest());
        this.impostoPagoSobreRendaVariavel.setConteudo(valor);
        this.totalDoacoesCampanhasEleitorais.setConteudo(this.declaracaoIRPF.getDoacoes().getTotalDoacoes());
    }

    private void aplicaLimitesImpostoPagoExterior(Valor valor) {
        if (!valor.comparacao(">", "0,00")) {
            ImpostoPago impostoPago = this.declaracaoIRPF.getImpostoPago();
            impostoPago.getImpostoDevidoComRendExterior().clear();
            impostoPago.getImpostoDevidoSemRendExterior().clear();
            impostoPago.getLimiteLegalImpPagoExterior().clear();
            return;
        }
        valor.setConteudo(this.declaracaoIRPF.getImpostoPago().getImpostoPagoExterior());
        Valor valor2 = new Valor();
        valor2.append('+', this.totalRendimentos);
        valor2.append('-', this.totalDeducoes);
        Valor valor3 = this.calculaImposto(valor2);
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoComRendExterior().setConteudo(valor3);
        Valor valor4 = new Valor();
        valor4.append('+', this.totalRendimentos);
        valor4.append('-', this.totalDeducoes);
        valor4.append('-', this.rendRecebidoExterior);
        Valor valor5 = this.calculaImposto(valor4);
        Valor valor6 = valor3.operacao('-', valor5);
        if (valor.comparacao(">", valor6)) {
            valor.setConteudo(valor6);
        }
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoSemRendExterior().setConteudo(valor5);
        this.declaracaoIRPF.getImpostoPago().getLimiteLegalImpPagoExterior().setConteudo(valor);
    }

    public void aplicaValoresNaDeclaracao() {
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJTitular().setConteudo(this.rendRecebidoPJTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJDependentes().setConteudo(this.rendRecebidoPJDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTTitular().setConteudo(this.rendRecebidoPFEXTTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTDependentes().setConteudo(this.rendRecebidoPFEXTDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendTributavelAR().setConteudo(this.resultadoTributavelAR);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().setConteudo(this.totalRendimentos);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaOficial().setConteudo(this.previdenciaOficial);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaFAPI().setConteudo(this.previdenciaFAPI);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDependentes().setConteudo(this.deducaoDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasInstrucao().setConteudo(this.despesasInstrucao);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasMedicas().setConteudo(this.despesasMedicas);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoAlimenticia().setConteudo(this.pensaoAlimenticia);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoCartoral().setConteudo(this.pensaoCartoral);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getLivroCaixa().setConteudo(this.livroCaixa);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes().setConteudo(this.totalDeducoes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getBaseCalculo().setConteudo(this.baseCalculo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImposto().setConteudo(this.imposto);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getDeducaoIncentivo().setConteudo(this.deducaoIncentivo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalContribEmpregadoDomestico().setConteudo(this.totalContribEmpregadoDomestico);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevido().setConteudo(this.impostoDevido);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoII().setConteudo(this.impostoDevidoII);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao().setConteudo(this.carneLeao);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().setConteudo(this.impostoComplementar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().setConteudo(this.impostoPagoExterior);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().setConteudo(this.impostoRetidoFonteLei11033);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalImpostoPago().setConteudo(this.totalImpostoPago);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().setConteudo(this.saldoImpostoPagar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir().setConteudo(this.impostoRestituir);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAnterior().setConteudo(this.bensDireitosExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAtual().setConteudo(this.bensDireitosExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAnterior().setConteudo(this.dividasExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAtual().setConteudo(this.dividasExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().setConteudo(this.rendIsentosNaoTributaveis);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().setConteudo(this.rendSujeitoTribExclusiva);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoGCAP().setConteudo(this.impostoPagoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoME().setConteudo(this.impostoPagoME);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalImpostoRetidoNaFonte().setConteudo(this.totalImpostoRetidoNaFonte);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoSobreRendaVariavel().setConteudo(this.impostoPagoSobreRendaVariavel);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais().setConteudo(this.totalDoacoesCampanhasEleitorais);
    }

    public Valor getBensDireitosExercicioAnterior() {
        return this.bensDireitosExercicioAnterior;
    }

    public Valor getBensDireitosExercicioAtual() {
        return this.bensDireitosExercicioAtual;
    }

    public Valor getCarneLeao() {
        return this.carneLeao;
    }

    public Valor getDeducaoDependentes() {
        return this.deducaoDependentes;
    }

    public Valor getDeducaoIncentivo() {
        return this.deducaoIncentivo;
    }

    public Valor getDespesasInstrucao() {
        return this.despesasInstrucao;
    }

    public Valor getDespesasMedicas() {
        return this.despesasMedicas;
    }

    public Valor getDividasExercicioAnterior() {
        return this.dividasExercicioAnterior;
    }

    public Valor getDividasExercicioAtual() {
        return this.dividasExercicioAtual;
    }

    public Valor getImposto() {
        return this.imposto;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public Valor getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public Valor getImpostoPagoGCAP() {
        return this.impostoPagoGCAP;
    }

    public Valor getImpostoPagoME() {
        return this.impostoPagoME;
    }

    public Valor getImpostoPagoSobreRendaVariavel() {
        return this.impostoPagoSobreRendaVariavel;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Valor getLivroCaixa() {
        return this.livroCaixa;
    }

    public Valor getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public Valor getPensaoCartoral() {
        return this.pensaoCartoral;
    }

    public Valor getPrevidenciaFAPI() {
        return this.previdenciaFAPI;
    }

    public Valor getPrevidenciaOficial() {
        return this.previdenciaOficial;
    }

    public Valor getRendIsentosNaoTributaveis() {
        return this.rendIsentosNaoTributaveis;
    }

    public Valor getRendRecebidoPFEXTDependentes() {
        return this.rendRecebidoPFEXTDependentes;
    }

    public Valor getRendRecebidoPFEXTTitular() {
        return this.rendRecebidoPFEXTTitular;
    }

    public Valor getRendRecebidoPJDependentes() {
        return this.rendRecebidoPJDependentes;
    }

    public Valor getRendRecebidoPJTitular() {
        return this.rendRecebidoPJTitular;
    }

    public Valor getRendSujeitoTribExclusiva() {
        return this.rendSujeitoTribExclusiva;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getTotalDeducoes() {
        return this.totalDeducoes;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor getTotalImpostoRetidoNaFonte() {
        return this.totalImpostoRetidoNaFonte;
    }

    public Valor getTotalRendimentos() {
        return this.totalRendimentos;
    }

    public Valor recuperarTotalImpostoPago() {
        Valor valor = new Valor();
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033());
        return valor;
    }

    public String recuperarCodInImpostoPago() {
        int n = 0;
        String string = "";
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio()) {
            ++n;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().isVazio()) {
            n += 8;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().isVazio()) {
            n += 4;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao().isVazio()) {
            n += 2;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio()) {
            n += 16;
        }
        string = n < 9 ? "0" + n : "" + n;
        return string;
    }

    public Valor recuperarTotalRendimentosTributaveis() {
        Valor valor = new Valor(this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().getConteudoFormatado());
        return valor;
    }
}

