/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String key = null;
    protected byte positionType;
    protected byte stretchType;
    protected boolean isPrintRepeatedValues = true;
    protected Byte mode;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean isRemoveLineWhenBlank = false;
    protected boolean isPrintInFirstWholeBand = false;
    protected boolean isPrintWhenDetailOverflows = false;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRExpression printWhenExpression = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRElementGroup elementGroup = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;

    protected JRBaseElement(JRDefaultStyleProvider jRDefaultStyleProvider) {
        this.defaultStyleProvider = jRDefaultStyleProvider;
    }

    protected JRBaseElement(JRElement jRElement, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRElement, this);
        this.defaultStyleProvider = jRBaseObjectFactory.getDefaultStyleProvider();
        this.parentStyle = jRBaseObjectFactory.getStyle(jRElement.getStyle());
        this.key = jRElement.getKey();
        this.positionType = jRElement.getPositionType();
        this.stretchType = jRElement.getStretchType();
        this.isPrintRepeatedValues = jRElement.isPrintRepeatedValues();
        this.mode = jRElement.getOwnMode();
        this.x = jRElement.getX();
        this.y = jRElement.getY();
        this.width = jRElement.getWidth();
        this.height = jRElement.getHeight();
        this.isRemoveLineWhenBlank = jRElement.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = jRElement.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = jRElement.isPrintWhenDetailOverflows();
        this.forecolor = jRElement.getOwnForecolor();
        this.backcolor = jRElement.getOwnBackcolor();
        this.printWhenExpression = jRBaseObjectFactory.getExpression(jRElement.getPrintWhenExpression());
        this.printWhenGroupChanges = jRBaseObjectFactory.getGroup(jRElement.getPrintWhenGroupChanges());
        this.elementGroup = jRBaseObjectFactory.getElementGroup(jRElement.getElementGroup());
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public byte getPositionType() {
        return this.positionType;
    }

    @Override
    public void setPositionType(byte by) {
        this.positionType = by;
    }

    @Override
    public byte getStretchType() {
        return this.stretchType;
    }

    @Override
    public void setStretchType(byte by) {
        this.stretchType = by;
    }

    @Override
    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    @Override
    public void setPrintRepeatedValues(boolean bl) {
        this.isPrintRepeatedValues = bl;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    @Override
    public Byte getOwnMode() {
        return this.mode;
    }

    @Override
    public void setMode(byte by) {
        this.mode = new Byte(by);
    }

    @Override
    public void setMode(Byte by) {
        this.mode = by;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int n) {
        this.x = n;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    @Override
    public void setRemoveLineWhenBlank(boolean bl) {
        this.isRemoveLineWhenBlank = bl;
    }

    @Override
    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    @Override
    public void setPrintInFirstWholeBand(boolean bl) {
        this.isPrintInFirstWholeBand = bl;
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    @Override
    public void setPrintWhenDetailOverflows(boolean bl) {
        this.isPrintWhenDetailOverflows = bl;
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public void setForecolor(Color color) {
        this.forecolor = color;
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color color) {
        this.backcolor = color;
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }
}

