/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    protected JRXmlWriteHelper xmlWriter = null;
    protected String encoding = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected Map stylesMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected File destFile = null;
    protected File imagesDir = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private static int imageId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block16: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Object object;
                StringBuffer stringBuffer;
                this.setExportContext();
                this.setInput();
                this.setPageRange();
                this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
                if (this.dtdLocation == null) {
                    this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = "UTF-8";
                }
                if ((stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
                    StringBuffer stringBuffer2 = this.exportReportToBuffer();
                    stringBuffer.append(stringBuffer2.toString());
                    break block16;
                }
                Writer writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (writer != null) {
                    try {
                        this.exportReportToStream(writer);
                        break block16;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(outputStream, this.encoding));
                        break block16;
                    }
                    catch (Exception exception) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), exception);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    object = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (object != null) {
                        this.destFile = new File((String)object);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + "_files");
                object = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (object == null) {
                    object = Boolean.TRUE;
                }
                this.isEmbeddingImages = (Boolean)object;
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void exportReportToFile() throws JRException {
        Object object;
        this.rendererToImagePathMap = new HashMap();
        this.imageNameToImageDataMap = new HashMap();
        Writer writer = null;
        try {
            object = new FileOutputStream(this.destFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)object, this.encoding));
            this.exportReportToStream(writer);
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file : " + this.destFile, iOException);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!this.isEmbeddingImages && (object = this.imageNameToImageDataMap.keySet()) != null && object.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[] byArray = (byte[])this.imageNameToImageDataMap.get(string);
                File file = new File(this.imagesDir, string);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    throw new JRException("Error writing to image file : " + file, iOException);
                }
                finally {
                    if (fileOutputStream == null) continue;
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.exportReportToStream(stringWriter);
        }
        catch (IOException iOException) {
            throw new JRException("Error while exporting report to buffer", iOException);
        }
        return stringWriter.getBuffer();
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        List list;
        JRStyle[] jRStyleArray;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        this.xmlWriter.writePublicDoctype("jasperPrint", "-//JasperReports//DTD Report Design//EN", this.dtdLocation);
        this.xmlWriter.startElement("jasperPrint");
        this.xmlWriter.addAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addAttribute("timezone", this.jasperPrint.getTimeZoneId());
        JRReportFont[] jRReportFontArray = this.jasperPrint.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            for (int i = 0; i < jRReportFontArray.length; ++i) {
                this.fontsMap.put(jRReportFontArray[i].getName(), jRReportFontArray[i]);
                this.exportReportFont(jRReportFontArray[i]);
            }
        }
        if ((jRStyleArray = this.jasperPrint.getStyles()) != null && jRStyleArray.length > 0) {
            for (int i = 0; i < jRStyleArray.length; ++i) {
                this.stylesMap.put(jRStyleArray[i].getName(), jRStyleArray[i]);
                this.exportStyle(jRStyleArray[i]);
            }
        }
        if ((list = this.jasperPrint.getPages()) != null && list.size() > 0) {
            JRPrintPage jRPrintPage = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                jRPrintPage = (JRPrintPage)list.get(i);
                this.exportPage(jRPrintPage);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportReportFont(JRReportFont jRReportFont) throws IOException {
        this.xmlWriter.startElement("reportFont");
        this.xmlWriter.addAttribute("name", jRReportFont.getName());
        this.xmlWriter.addAttribute("isDefault", jRReportFont.isDefault());
        this.xmlWriter.addAttribute("fontName", jRReportFont.getFontName());
        this.xmlWriter.addAttribute("size", jRReportFont.getFontSize());
        this.xmlWriter.addAttribute("isBold", jRReportFont.isBold());
        this.xmlWriter.addAttribute("isItalic", jRReportFont.isItalic());
        this.xmlWriter.addAttribute("isUnderline", jRReportFont.isUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", jRReportFont.isStrikeThrough());
        this.xmlWriter.addAttribute("pdfFontName", jRReportFont.getPdfFontName());
        this.xmlWriter.addAttribute("pdfEncoding", jRReportFont.getPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", jRReportFont.isPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    protected void exportStyle(JRStyle jRStyle) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addAttribute("name", jRStyle.getName());
        this.xmlWriter.addAttribute("isDefault", jRStyle.isDefault());
        if (jRStyle.getStyle() != null) {
            JRStyle jRStyle2 = (JRStyle)this.stylesMap.get(jRStyle.getStyle().getName());
            if (jRStyle2 != null) {
                this.xmlWriter.addAttribute("style", jRStyle.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + jRStyle.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", jRStyle.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("forecolor", jRStyle.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", jRStyle.getOwnBackcolor());
        this.xmlWriter.addAttribute("pen", jRStyle.getOwnPen(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("fill", jRStyle.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.addAttribute("radius", jRStyle.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", jRStyle.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", jRStyle.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", jRStyle.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("rotation", jRStyle.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("lineSpacing", jRStyle.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", jRStyle.isOwnStyledText());
        this.xmlWriter.addAttribute("border", jRStyle.getOwnBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("borderColor", jRStyle.getOwnBorderColor());
        this.xmlWriter.addAttribute("padding", jRStyle.getOwnPadding());
        this.xmlWriter.addAttribute("topBorder", jRStyle.getOwnTopBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("topBorderColor", jRStyle.getOwnTopBorderColor());
        this.xmlWriter.addAttribute("topPadding", jRStyle.getOwnTopPadding());
        this.xmlWriter.addAttribute("leftBorder", jRStyle.getOwnLeftBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("leftBorderColor", jRStyle.getOwnLeftBorderColor());
        this.xmlWriter.addAttribute("leftPadding", jRStyle.getOwnLeftPadding());
        this.xmlWriter.addAttribute("bottomBorder", jRStyle.getOwnBottomBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("bottomBorderColor", jRStyle.getOwnBottomBorderColor());
        this.xmlWriter.addAttribute("bottomPadding", jRStyle.getOwnBottomPadding());
        this.xmlWriter.addAttribute("rightBorder", jRStyle.getOwnRightBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("rightBorderColor", jRStyle.getOwnRightBorderColor());
        this.xmlWriter.addAttribute("rightPadding", jRStyle.getOwnRightPadding());
        this.xmlWriter.addAttribute("fontName", jRStyle.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", jRStyle.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", jRStyle.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", jRStyle.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", jRStyle.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", jRStyle.isOwnStrikeThrough());
        this.xmlWriter.addAttribute("pdfFontName", jRStyle.getOwnPdfFontName());
        this.xmlWriter.addAttribute("pdfEncoding", jRStyle.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", jRStyle.isOwnPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection collection) throws IOException, JRException {
        if (collection != null && collection.size() > 0) {
            for (JRPrintElement jRPrintElement : collection) {
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    protected void exportLine(JRPrintLine jRPrintLine) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", jRPrintLine.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.exportReportElement(jRPrintLine);
        this.exportGraphicElement(jRPrintLine);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement jRPrintElement) throws IOException {
        this.xmlWriter.startElement("reportElement");
        this.xmlWriter.addAttribute("key", jRPrintElement.getKey());
        JRStyle jRStyle = jRPrintElement.getStyle();
        if (jRStyle != null) {
            this.xmlWriter.addAttribute("style", jRStyle.getName());
        }
        this.xmlWriter.addAttribute("mode", jRPrintElement.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("x", jRPrintElement.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", jRPrintElement.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", jRPrintElement.getWidth());
        this.xmlWriter.addAttribute("height", jRPrintElement.getHeight());
        this.xmlWriter.addAttribute("forecolor", jRPrintElement.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", jRPrintElement.getOwnBackcolor());
        this.xmlWriter.closeElement();
    }

    protected void exportGraphicElement(JRPrintGraphicElement jRPrintGraphicElement) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("pen", jRPrintGraphicElement.getOwnPen(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("fill", jRPrintGraphicElement.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.closeElement();
    }

    protected void exportRectangle(JRPrintRectangle jRPrintRectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", jRPrintRectangle.getOwnRadius());
        this.exportReportElement(jRPrintRectangle);
        this.exportGraphicElement(jRPrintRectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse jRPrintEllipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(jRPrintEllipse);
        this.exportGraphicElement(jRPrintEllipse);
        this.xmlWriter.closeElement();
    }

    protected void exportImage(JRPrintImage jRPrintImage) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", jRPrintImage.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", jRPrintImage.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", jRPrintImage.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("isLazy", jRPrintImage.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", jRPrintImage.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.xmlWriter.addAttribute("hyperlinkType", jRPrintImage.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", jRPrintImage.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addAttribute("anchorName", jRPrintImage.getAnchorName());
        this.xmlWriter.addAttribute("hyperlinkReference", jRPrintImage.getHyperlinkReference());
        this.xmlWriter.addAttribute("hyperlinkAnchor", jRPrintImage.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", jRPrintImage.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", jRPrintImage.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", jRPrintImage.getBookmarkLevel(), 0);
        this.exportReportElement(jRPrintImage);
        this.exportBox(jRPrintImage);
        this.exportGraphicElement(jRPrintImage);
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !jRPrintImage.isLazy(), false);
            String string = "";
            if (jRRenderable.getType() == 1) {
                jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), jRPrintImage.getBackcolor());
            }
            if (this.isEmbeddingImages && !jRPrintImage.isLazy()) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jRRenderable.getImageData());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Base64Encoder base64Encoder = new Base64Encoder(byteArrayInputStream, byteArrayOutputStream);
                    base64Encoder.process();
                    string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                }
                catch (IOException iOException) {
                    throw new JRException("Error embedding image into XML.", iOException);
                }
            } else if (jRRenderable.getType() == 0 && this.rendererToImagePathMap.containsKey(jRRenderable)) {
                string = (String)this.rendererToImagePathMap.get(jRRenderable);
            } else {
                if (jRPrintImage.isLazy()) {
                    string = ((JRImageRenderer)jRRenderable).getImageLocation();
                } else {
                    string = "img_" + JRXmlExporter.getNextImageId();
                    this.imageNameToImageDataMap.put(string, jRRenderable.getImageData());
                    string = new File(this.imagesDir, string).getPath();
                }
                this.rendererToImagePathMap.put(jRRenderable, string);
            }
            this.xmlWriter.writeCDATA(string);
            this.xmlWriter.closeElement();
        }
        this.exportHyperlinkParameters(jRPrintImage);
        this.xmlWriter.closeElement();
    }

    protected void exportText(JRPrintText jRPrintText) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", jRPrintText.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("verticalAlignment", jRPrintText.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("textHeight", jRPrintText.getTextHeight());
        this.xmlWriter.addAttribute("rotation", jRPrintText.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("runDirection", jRPrintText.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.xmlWriter.addAttribute("lineSpacing", jRPrintText.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", jRPrintText.isOwnStyledText());
        this.xmlWriter.addAttribute("lineSpacingFactor", jRPrintText.getLineSpacingFactor());
        this.xmlWriter.addAttribute("leadingOffset", jRPrintText.getLeadingOffset());
        this.xmlWriter.addAttribute("hyperlinkType", jRPrintText.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", jRPrintText.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addAttribute("anchorName", jRPrintText.getAnchorName());
        this.xmlWriter.addAttribute("hyperlinkReference", jRPrintText.getHyperlinkReference());
        this.xmlWriter.addAttribute("hyperlinkAnchor", jRPrintText.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", jRPrintText.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", jRPrintText.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", jRPrintText.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", jRPrintText.getValueClassName());
        this.xmlWriter.addAttribute("pattern", jRPrintText.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", jRPrintText.getFormatFactoryClass());
        this.xmlWriter.addAttribute("locale", jRPrintText.getLocaleCode());
        this.xmlWriter.addAttribute("timezone", jRPrintText.getTimeZoneId());
        this.exportReportElement(jRPrintText);
        this.exportBox(jRPrintText);
        this.exportFont(jRPrintText);
        if (jRPrintText.getText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", jRPrintText.getText());
        }
        this.exportHyperlinkParameters(jRPrintText);
        this.xmlWriter.closeElement();
    }

    private void exportBox(JRBox jRBox) throws IOException {
        if (jRBox != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("border", jRBox.getOwnBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("borderColor", jRBox.getOwnBorderColor());
            this.xmlWriter.addAttribute("padding", jRBox.getOwnPadding());
            this.xmlWriter.addAttribute("topBorder", jRBox.getOwnTopBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("topBorderColor", jRBox.getOwnTopBorderColor());
            this.xmlWriter.addAttribute("topPadding", jRBox.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftBorder", jRBox.getOwnLeftBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("leftBorderColor", jRBox.getOwnLeftBorderColor());
            this.xmlWriter.addAttribute("leftPadding", jRBox.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomBorder", jRBox.getOwnBottomBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("bottomBorderColor", jRBox.getOwnBottomBorderColor());
            this.xmlWriter.addAttribute("bottomPadding", jRBox.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightBorder", jRBox.getOwnRightBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("rightBorderColor", jRBox.getOwnRightBorderColor());
            this.xmlWriter.addAttribute("rightPadding", jRBox.getOwnRightPadding());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFont(JRFont jRFont) throws IOException {
        if (jRFont != null) {
            this.xmlWriter.startElement("font");
            if (jRFont.getReportFont() != null) {
                JRFont jRFont2 = (JRFont)this.fontsMap.get(jRFont.getReportFont().getName());
                if (jRFont2 != null) {
                    this.xmlWriter.addAttribute("reportFont", jRFont.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + jRFont.getReportFont().getName());
                }
            }
            this.xmlWriter.addAttribute("fontName", jRFont.getOwnFontName());
            this.xmlWriter.addAttribute("size", jRFont.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", jRFont.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", jRFont.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", jRFont.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", jRFont.isOwnStrikeThrough());
            this.xmlWriter.addAttribute("pdfFontName", jRFont.getOwnPdfFontName());
            this.xmlWriter.addAttribute("pdfEncoding", jRFont.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", jRFont.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFrame(JRPrintFrame jRPrintFrame) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(jRPrintFrame, true);
        try {
            this.exportReportElement(jRPrintFrame);
            this.exportBox(jRPrintFrame);
            this.exportElements(jRPrintFrame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    protected void exportHyperlinkParameters(JRPrintHyperlink jRPrintHyperlink) throws IOException {
        JRPrintHyperlinkParameters jRPrintHyperlinkParameters = jRPrintHyperlink.getHyperlinkParameters();
        if (jRPrintHyperlinkParameters != null) {
            for (JRPrintHyperlinkParameter jRPrintHyperlinkParameter : jRPrintHyperlinkParameters.getParameters()) {
                this.exportHyperlinkParameter(jRPrintHyperlinkParameter);
            }
        }
    }

    protected void exportHyperlinkParameter(JRPrintHyperlinkParameter jRPrintHyperlinkParameter) throws IOException {
        this.xmlWriter.startElement("hyperlinkParameter");
        this.xmlWriter.addAttribute("name", jRPrintHyperlinkParameter.getName());
        this.xmlWriter.addAttribute("class", jRPrintHyperlinkParameter.getValueClass(), "java.lang.String");
        if (jRPrintHyperlinkParameter.getValue() != null) {
            String string = JRValueStringUtils.serialize(jRPrintHyperlinkParameter.getValueClass(), jRPrintHyperlinkParameter.getValue());
            this.xmlWriter.writeCDATAElement("hyperlinkParameterValue", string);
        }
        this.xmlWriter.closeElement();
    }
}

