/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;

public class JRSaver {
    public static void saveObject(Object object, String string) throws JRException {
        JRSaver.saveObject(object, new File(string));
    }

    public static void saveObject(Object object, File file) throws JRException {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            bufferedOutputStream.flush();
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error saving file : " + file, iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void saveObject(Object object, OutputStream outputStream) throws JRException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error saving object to OutputStream", iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void saveClassSource(String string, File file) throws JRException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
            fileWriter.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error saving expressions class file : " + file, iOException);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

