/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog(MethodUtils.class);
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static WeakHashMap cache = new WeakHashMap();

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                if (!Modifier.isPublic(classArray2[i].getModifiers())) continue;
                try {
                    method = classArray2[i].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i], string, classArray)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String string, Class[] classArray) {
        if (log.isTraceEnabled()) {
            log.trace("Matching name=" + string + " on " + clazz);
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, false);
        try {
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(string, classArray);
            if (log.isTraceEnabled()) {
                log.trace("Found straight match: " + method);
                log.trace("isPublic:" + Modifier.isPublic(method.getModifiers()));
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                if (!loggedAccessibleWarning) {
                    boolean bl = false;
                    try {
                        String string2 = System.getProperty("java.specification.version");
                        if (string2.charAt(0) == '1' && (string2.charAt(0) == '0' || string2.charAt(0) == '1' || string2.charAt(0) == '2' || string2.charAt(0) == '3')) {
                            bl = true;
                        }
                    }
                    catch (SecurityException securityException2) {
                        bl = true;
                    }
                    if (bl) {
                        log.warn("Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    loggedAccessibleWarning = true;
                }
                log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", securityException);
            }
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n = classArray.length;
            Method[] methodArray = clazz.getMethods();
            int n2 = methodArray.length;
            for (int i = 0; i < n2; ++i) {
                Class<?>[] classArray2;
                int n3;
                if (!methodArray[i].getName().equals(string)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found matching name:");
                    log.trace(methodArray[i]);
                }
                if ((n3 = (classArray2 = methodArray[i].getParameterTypes()).length) != n) continue;
                boolean bl = true;
                for (int j = 0; j < n3; ++j) {
                    if (log.isTraceEnabled()) {
                        log.trace("Param=" + classArray[j].getName());
                        log.trace("Method=" + classArray2[j].getName());
                    }
                    if (MethodUtils.isAssignmentCompatible(classArray2[j], classArray[j])) continue;
                    if (log.isTraceEnabled()) {
                        log.trace(classArray2[j] + " is not assignable from " + classArray[j]);
                    }
                    bl = false;
                    break;
                }
                if (!bl) continue;
                Method method = MethodUtils.getAccessibleMethod(methodArray[i]);
                if (method != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(method + " accessible version of " + methodArray[i]);
                    }
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        if (!loggedAccessibleWarning) {
                            log.warn("Cannot use JVM pre-1.4 access bug workaround due to restrictive security manager.");
                            loggedAccessibleWarning = true;
                        }
                        log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", securityException);
                    }
                    cache.put(methodDescriptor, method);
                    return method;
                }
                log.trace("Couldn't find accessible method.");
            }
            log.trace("No match found.");
            return null;
        }
    }

    public static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        if (Boolean.class.equals((Object)clazz)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.TYPE;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.TYPE;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.TYPE;
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.TYPE;
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.TYPE;
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.TYPE;
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.TYPE;
        }
        if (log.isDebugEnabled()) {
            log.debug("Not a known primitive wrapper class: " + clazz);
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (classArray == null) {
                classArray = emptyClassArray;
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

