/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Encodable {
    ASN1Sequence seq;

    public static GeneralNames getInstance(Object object) {
        if (object == null || object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public GeneralNames(GeneralName generalName) {
        this.seq = new DERSequence(generalName);
    }

    public GeneralNames(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public GeneralName[] getNames() {
        GeneralName[] generalNameArray = new GeneralName[this.seq.size()];
        for (int i = 0; i != this.seq.size(); ++i) {
            generalNameArray[i] = GeneralName.getInstance(this.seq.getObjectAt(i));
        }
        return generalNameArray;
    }

    @Override
    public DERObject toASN1Object() {
        return this.seq;
    }
}

