/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class AbstractVariableDeclaration
extends Statement
implements InvocationSite {
    public int declarationEnd;
    public int declarationSourceEnd;
    public int declarationSourceStart;
    public int hiddenVariableDepth;
    public Expression initialization;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference type;
    public static final int FIELD = 1;
    public static final int INITIALIZER = 2;
    public static final int ENUM_CONSTANT = 3;
    public static final int LOCAL_VARIABLE = 4;
    public static final int PARAMETER = 5;
    public static final int TYPE_PARAMETER = 6;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public abstract int getKind();

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return false;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        this.printAsExpression(n, stringBuffer);
        switch (this.getKind()) {
            case 3: {
                return stringBuffer.append(',');
            }
        }
        return stringBuffer.append(';');
    }

    public StringBuffer printAsExpression(int n, StringBuffer stringBuffer) {
        AbstractVariableDeclaration.printIndent(n, stringBuffer);
        AbstractVariableDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AbstractVariableDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if (this.type != null) {
            this.type.print(0, stringBuffer).append(' ');
        }
        stringBuffer.append(this.name);
        switch (this.getKind()) {
            case 3: {
                if (this.initialization == null) break;
                this.initialization.printExpression(n, stringBuffer);
                break;
            }
            default: {
                if (this.initialization == null) break;
                stringBuffer.append(" = ");
                this.initialization.printExpression(n, stringBuffer);
            }
        }
        return stringBuffer;
    }

    @Override
    public void resolve(BlockScope blockScope) {
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n) {
        this.hiddenVariableDepth = n;
    }

    @Override
    public void setFieldIndex(int n) {
    }
}

