/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    static final MemberValuePair[] NoValuePairs = new MemberValuePair[0];
    public int declarationSourceEnd;
    public Binding recipient;
    public TypeReference type;
    private AnnotationBinding compilerAnnotation = null;

    public static long getRetentionPolicy(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CLASS)) break;
                return 0x100000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_SOURCE)) break;
                return 0x80000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RUNTIME)) break;
                return 0x180000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'A': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x20000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x8000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                return 0x1000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x10000000000L;
            }
            case 'M': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) break;
                return 0x2000000000L;
            }
            case 'P': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) {
                    return 0x4000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_PACKAGE)) break;
                return 0x40000000000L;
            }
            case 'T': {
                if (!CharOperation.equals(cArray, TypeConstants.TYPE)) break;
                return 0x800000000L;
            }
        }
        return 0L;
    }

    public ElementValuePair[] computeElementValuePairs() {
        return Binding.NO_ELEMENT_VALUE_PAIRS;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l = 0L;
        switch (referenceBinding.id) {
            case 48: {
                FieldBinding fieldBinding;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 51) break;
                l |= Annotation.getRetentionPolicy(fieldBinding.name);
                break;
            }
            case 50: {
                FieldBinding fieldBinding;
                l |= 0x400000000L;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    for (Expression expression2 : expressionArray) {
                        FieldBinding fieldBinding2;
                        if ((expression2.bits & 3) != 1 || (fieldBinding2 = ((Reference)expression2).fieldBinding()) == null || fieldBinding2.declaringClass.id != 52) continue;
                        long l2 = Annotation.getTargetElementType(fieldBinding2.name);
                        if ((l & l2) != 0L) {
                            scope.problemReporter().duplicateTargetInTargetAnnotation(referenceBinding, (NameReference)expression2);
                            continue;
                        }
                        l |= l2;
                    }
                    break;
                }
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 52) break;
                l |= Annotation.getTargetElementType(fieldBinding.name);
                break;
            }
            case 44: {
                l |= 0x200000000000L;
                break;
            }
            case 45: {
                l |= 0x400000000000L;
                break;
            }
            case 46: {
                l |= 0x800000000000L;
                break;
            }
            case 47: {
                l |= 0x1000000000000L;
                break;
            }
            case 49: {
                l |= 0x2000000000000L;
            }
        }
        return l;
    }

    public AnnotationBinding getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public abstract MemberValuePair[] memberValuePairs();

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('@');
        this.type.printExpression(0, stringBuffer);
        return stringBuffer;
    }

    public void recordSuppressWarnings(Scope scope, int n, int n2, boolean bl) {
        long l = 0L;
        block0: for (MemberValuePair memberValuePair : this.memberValuePairs()) {
            if (!CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) continue;
            Expression expression = memberValuePair.value;
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                Expression[] expressionArray = arrayInitializer.expressions;
                if (expressionArray == null) break;
                int n3 = expressionArray.length;
                for (int i = 0; i < n3; ++i) {
                    Constant constant = expressionArray[i].constant;
                    if (constant == Constant.NotAConstant || constant.typeID() != 11) continue;
                    long l2 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
                    if (l2 != 0L) {
                        if (((l |= l2) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue;
                        break block0;
                    }
                    scope.problemReporter().unhandledWarningToken(expressionArray[i]);
                }
                break;
            }
            Constant constant = expression.constant;
            if (constant == Constant.NotAConstant || constant.typeID() != 11) break;
            long l3 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
            if (l3 != 0L) {
                if (((l |= l3) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) break;
                break;
            }
            scope.problemReporter().unhandledWarningToken(expression);
            break;
        }
        if (bl && l != 0L) {
            scope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(l, n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        MemberValuePair[] memberValuePairArray;
        if (this.compilerAnnotation != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.type.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        this.resolvedType = typeBinding;
        if (!typeBinding.isAnnotationType()) {
            blockScope.problemReporter().typeMismatchError(typeBinding, blockScope.getJavaLangAnnotationAnnotation(), this.type);
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray2 = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n = memberValuePairArray2.length;
        if (n > 0) {
            memberValuePairArray = new MemberValuePair[n];
            System.arraycopy(memberValuePairArray2, 0, memberValuePairArray, 0, n);
        } else {
            memberValuePairArray = memberValuePairArray2;
        }
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (true) {
            int n4;
            if (n2 >= n3) {
                long l;
                for (n2 = 0; n2 < n; ++n2) {
                    if (memberValuePairArray[n2] == null) continue;
                    blockScope.problemReporter().undefinedAnnotationValue(referenceBinding, memberValuePairArray[n2]);
                    memberValuePairArray[n2].resolveTypeExpecting(blockScope, null);
                }
                this.compilerAnnotation = new AnnotationBinding(this);
                long l2 = this.detectStandardAnnotation(blockScope, referenceBinding, memberValuePair);
                blockScope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(256L, this.sourceStart, this.declarationSourceEnd);
                if (this.recipient == null) return this.resolvedType;
                if (l2 != 0L) {
                    switch (this.recipient.kind()) {
                        case 16: {
                            ((PackageBinding)this.recipient).tagBits |= l2;
                            break;
                        }
                        case 4: 
                        case 2052: {
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                            sourceTypeBinding.tagBits |= l2;
                            if ((l2 & 0x2000000000000L) == 0L) break;
                            TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
                            n4 = blockScope.referenceCompilationUnit().types[0] == typeDeclaration ? 0 : typeDeclaration.declarationSourceStart;
                            this.recordSuppressWarnings(blockScope, n4, typeDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                            break;
                        }
                        case 8: {
                            MethodBinding methodBinding = (MethodBinding)this.recipient;
                            methodBinding.tagBits |= l2;
                            if ((l2 & 0x2000000000000L) == 0L) break;
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                            AbstractMethodDeclaration abstractMethodDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(methodBinding);
                            this.recordSuppressWarnings(blockScope, abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                            break;
                        }
                        case 1: {
                            FieldBinding fieldBinding = (FieldBinding)this.recipient;
                            fieldBinding.tagBits |= l2;
                            if ((l2 & 0x2000000000000L) == 0L) break;
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                            FieldDeclaration fieldDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(fieldBinding);
                            this.recordSuppressWarnings(blockScope, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                            break;
                        }
                        case 2: {
                            LocalVariableBinding localVariableBinding = (LocalVariableBinding)this.recipient;
                            localVariableBinding.tagBits |= l2;
                            if ((l2 & 0x2000000000000L) == 0L) break;
                            LocalDeclaration localDeclaration = localVariableBinding.declaration;
                            this.recordSuppressWarnings(blockScope, localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                            break;
                        }
                    }
                }
                if (((l = referenceBinding.getAnnotationTagBits()) & 0x7FC00000000L) == 0L) {
                    return this.resolvedType;
                }
                switch (this.recipient.kind()) {
                    case 16: {
                        if ((l & 0x40000000000L) == 0L) break;
                        return this.resolvedType;
                    }
                    case 4: 
                    case 2052: {
                        if (!(((ReferenceBinding)this.recipient).isAnnotationType() ? (l & 0x20800000000L) != 0L : (l & 0x800000000L) != 0L)) break;
                        return this.resolvedType;
                    }
                    case 8: {
                        if (!(((MethodBinding)this.recipient).isConstructor() ? (l & 0x8000000000L) != 0L : (l & 0x2000000000L) != 0L)) break;
                        return this.resolvedType;
                    }
                    case 1: {
                        if ((l & 0x1000000000L) == 0L) break;
                        return this.resolvedType;
                    }
                    case 2: {
                        if (!((((LocalVariableBinding)this.recipient).tagBits & 0x400L) != 0L ? (l & 0x4000000000L) != 0L : (referenceBinding.tagBits & 0x10000000000L) != 0L)) break;
                        return this.resolvedType;
                    }
                }
                blockScope.problemReporter().disallowedTargetForAnnotation(this);
                return this.resolvedType;
            }
            MethodBinding methodBinding = methodBindingArray[n2];
            char[] cArray = methodBinding.selector;
            n4 = 0;
            int n5 = 0;
            while (true) {
                block29: {
                    boolean bl;
                    MemberValuePair memberValuePair2;
                    block30: {
                        block28: {
                            char[] cArray2;
                            if (n5 >= n) break block28;
                            memberValuePair2 = memberValuePairArray[n5];
                            if (memberValuePair2 == null || !CharOperation.equals(cArray2 = memberValuePair2.name, cArray)) break block29;
                            if (memberValuePair == null && CharOperation.equals(cArray2, TypeConstants.VALUE)) {
                                memberValuePair = memberValuePair2;
                            }
                            memberValuePair2.binding = methodBinding;
                            memberValuePair2.resolveTypeExpecting(blockScope, methodBinding.returnType);
                            memberValuePairArray[n5] = null;
                            n4 = 1;
                            bl = false;
                            break block30;
                        }
                        if (n4 != 0 || (methodBinding.modifiers & 0x20000) != 0) break;
                        blockScope.problemReporter().missingValueForAnnotationMember(this, cArray);
                        break;
                    }
                    for (int i = n5 + 1; i < n; ++i) {
                        MemberValuePair memberValuePair3 = memberValuePairArray[i];
                        if (memberValuePair3 == null || !CharOperation.equals(memberValuePair3.name, cArray)) continue;
                        bl = true;
                        blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair3);
                        memberValuePair3.binding = methodBinding;
                        memberValuePair3.resolveTypeExpecting(blockScope, methodBinding.returnType);
                        memberValuePairArray[i] = null;
                    }
                    if (bl) {
                        blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair2);
                        break;
                    }
                }
                ++n5;
            }
            ++n2;
        }
    }

    @Override
    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    @Override
    public abstract void traverse(ASTVisitor var1, CompilationUnitScope var2);
}

