/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    boolean hasBeenResolved = false;
    public Javadoc javadoc;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(MethodScope methodScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && !this.binding.isUsed() && (this.binding.isPrivate() || this.binding.declaringClass != null && this.binding.declaringClass.isLocalType()) && !methodScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            methodScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant() == Constant.NotAConstant && this.binding.declaringClass.isNestedType() && !this.binding.declaringClass.isStatic()) {
            methodScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(methodScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (!(this.initialization == null || (bl = this.binding.isStatic()) && this.binding.constant() != Constant.NotAConstant)) {
            if (!bl) {
                codeStream.aload_0();
            }
            this.initialization.generateCode(blockScope, codeStream, true);
            if (bl) {
                codeStream.putstatic(this.binding);
            } else {
                codeStream.putfield(this.binding);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public int getKind() {
        return this.type == null ? 3 : 1;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        return super.printStatement(n, stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(MethodScope methodScope) {
        if (!this.hasBeenResolved && this.binding != null && this.binding.isValidBinding()) {
            Binding binding;
            Object object;
            int n;
            Binding binding2;
            this.hasBeenResolved = true;
            ClassScope classScope = methodScope.enclosingClassScope();
            if (classScope != null) {
                binding2 = classScope.enclosingSourceType();
                n = 1;
                if (((SourceTypeBinding)binding2).superclass != null && (object = classScope.findField(((SourceTypeBinding)binding2).superclass, this.name, this, false)) != null && this.binding != object && ((Binding)object).isValidBinding()) {
                    methodScope.problemReporter().fieldHiding(this, (Binding)object);
                    n = 0;
                }
                if (n != 0) {
                    object = classScope.parent;
                    if (((Scope)object).kind != 4 && (binding = ((Scope)object).getBinding(this.name, 3, this, false)) != null && this.binding != binding && binding.isValidBinding() && (!(binding instanceof FieldBinding) || ((FieldBinding)binding).isStatic() || !((ReferenceBinding)binding2).isStatic())) {
                        methodScope.problemReporter().fieldHiding(this, binding);
                    }
                }
            }
            if (this.type != null) {
                this.type.resolvedType = this.binding.type;
            }
            binding2 = methodScope.initializedField;
            n = methodScope.lastVisibleFieldID;
            try {
                methodScope.initializedField = this.binding;
                methodScope.lastVisibleFieldID = this.binding.id;
                FieldDeclaration.resolveAnnotations(methodScope, this.annotations, this.binding);
                if ((this.binding.getAnnotationTagBits() & 0x200000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && methodScope.compilerOptions().sourceLevel >= 0x310000L) {
                    methodScope.problemReporter().missingDeprecatedAnnotationForField(this);
                }
                if (this.initialization == null) {
                    this.binding.setConstant(Constant.NotAConstant);
                } else {
                    this.binding.setConstant(Constant.NotAConstant);
                    object = this.binding.type;
                    this.initialization.setExpectedType((TypeBinding)object);
                    if (this.initialization instanceof ArrayInitializer) {
                        binding = this.initialization.resolveTypeExpecting(methodScope, (TypeBinding)object);
                        if (binding != null) {
                            ((ArrayInitializer)this.initialization).binding = (ArrayBinding)binding;
                            this.initialization.computeConversion(methodScope, (TypeBinding)object, (TypeBinding)binding);
                        }
                    } else {
                        binding = this.initialization.resolveType(methodScope);
                        if (binding != null) {
                            if (object != binding) {
                                methodScope.compilationUnitScope().recordTypeConversion((TypeBinding)object, (TypeBinding)binding);
                            }
                            if (this.initialization.isConstantValueOfTypeAssignableToType((TypeBinding)binding, (TypeBinding)object) || ((TypeBinding)object).isBaseType() && BaseTypeBinding.isWidening(((TypeBinding)object).id, ((TypeBinding)binding).id) || ((TypeBinding)binding).isCompatibleWith((TypeBinding)object)) {
                                this.initialization.computeConversion(methodScope, (TypeBinding)object, (TypeBinding)binding);
                                if (((TypeBinding)binding).needsUncheckedConversion((TypeBinding)object)) {
                                    methodScope.problemReporter().unsafeTypeConversion(this.initialization, (TypeBinding)binding, (TypeBinding)object);
                                }
                                if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                    CastExpression.checkNeedForAssignedCast(methodScope, (TypeBinding)object, (CastExpression)this.initialization);
                                }
                            } else if (methodScope.isBoxingCompatibleWith((TypeBinding)binding, (TypeBinding)object) || ((TypeBinding)binding).isBaseType() && methodScope.compilerOptions().sourceLevel >= 0x310000L && !((TypeBinding)object).isBaseType() && this.initialization.isConstantValueOfTypeAssignableToType((TypeBinding)binding, methodScope.environment().computeBoxingType((TypeBinding)object))) {
                                this.initialization.computeConversion(methodScope, (TypeBinding)object, (TypeBinding)binding);
                                if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                    CastExpression.checkNeedForAssignedCast(methodScope, (TypeBinding)object, (CastExpression)this.initialization);
                                }
                            } else {
                                methodScope.problemReporter().typeMismatchError((TypeBinding)binding, (TypeBinding)object, this);
                            }
                            if (this.binding.isFinal()) {
                                this.binding.setConstant(this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID()));
                            }
                        } else {
                            this.binding.setConstant(Constant.NotAConstant);
                        }
                    }
                    if (this.binding == Assignment.getDirectBinding(this.initialization)) {
                        methodScope.problemReporter().assignmentHasNoEffect(this, this.name);
                    }
                }
                if (this.javadoc != null) {
                    this.javadoc.resolve(methodScope);
                } else if (this.binding != null && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
                    methodScope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
                }
            }
            finally {
                methodScope.initializedField = binding2;
                methodScope.lastVisibleFieldID = n;
                if (this.binding.constant() == null) {
                    this.binding.setConstant(Constant.NotAConstant);
                }
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, MethodScope methodScope) {
        if (aSTVisitor.visit(this, methodScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, methodScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, methodScope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, methodScope);
            }
        }
        aSTVisitor.endVisit(this, methodScope);
    }
}

