/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathSourceJar;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    Set knownFileNames;

    public FileSystem(String[] stringArray, String[] stringArray2, String string) {
        int n = stringArray.length;
        this.classpaths = new Classpath[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Classpath classpath = FileSystem.getClasspath(stringArray[i], string, null);
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray2);
    }

    FileSystem(Classpath[] classpathArray, String[] stringArray) {
        int n = classpathArray.length;
        int n2 = 0;
        this.classpaths = new Classpath[n];
        for (int i = 0; i < n; ++i) {
            Classpath classpath = classpathArray[i];
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray);
    }

    public static Classpath getClasspath(String string, String string2, AccessRuleSet accessRuleSet) {
        return FileSystem.getClasspath(string, string2, false, accessRuleSet);
    }

    static Classpath getClasspath(String string, String string2, boolean bl, AccessRuleSet accessRuleSet) {
        ClasspathLocation classpathLocation = null;
        File file = new File(FileSystem.convertPathSeparators(string));
        if (file.isDirectory()) {
            if (file.exists()) {
                classpathLocation = new ClasspathDirectory(file, string2, bl ? 1 : 3, accessRuleSet);
            }
        } else {
            String string3 = string.toLowerCase();
            if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                classpathLocation = bl ? new ClasspathSourceJar(file, true, accessRuleSet, string2) : new ClasspathJar(file, true, accessRuleSet);
            }
        }
        return classpathLocation;
    }

    private void initializeKnownFileNames(String[] stringArray) {
        this.knownFileNames = new HashSet(stringArray.length * 2);
        int n = stringArray.length;
        while (--n >= 0) {
            char[] cArray = stringArray[n].toCharArray();
            char[] cArray2 = null;
            int n2 = CharOperation.lastIndexOf('.', cArray);
            if (n2 != -1) {
                cArray = CharOperation.subarray(cArray, 0, n2);
            }
            CharOperation.replace(cArray, '\\', '/');
            for (int i = 0; i < this.classpaths.length; ++i) {
                char[] cArray3 = this.classpaths[i].normalizedPath();
                if (!(this.classpaths[i] instanceof ClasspathDirectory) || !CharOperation.prefixEquals(cArray3, cArray) || cArray2 != null && cArray3.length >= cArray2.length) continue;
                cArray2 = cArray3;
            }
            if (cArray2 == null) {
                this.knownFileNames.add(new String(cArray));
            } else {
                this.knownFileNames.add(new String(CharOperation.subarray(cArray, cArray2.length, cArray.length)));
            }
            cArray2 = null;
        }
    }

    @Override
    public void cleanup() {
        int n = this.classpaths.length;
        for (int i = 0; i < n; ++i) {
            this.classpaths[i].reset();
        }
    }

    private static String convertPathSeparators(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray) {
        if (this.knownFileNames.contains(string)) {
            return null;
        }
        String string2 = string + ".class";
        String string3 = string.length() == cArray.length ? "" : string2.substring(0, string.length() - cArray.length - 1);
        String string4 = File.separatorChar == '/' ? string3 : string3.replace('/', File.separatorChar);
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        if (string3 == string4) {
            int n = this.classpaths.length;
            for (int i = 0; i < n; ++i) {
                NameEnvironmentAnswer nameEnvironmentAnswer2 = this.classpaths[i].findClass(cArray, string3, string2);
                if (nameEnvironmentAnswer2 == null) continue;
                if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                    if (!nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) continue;
                    return nameEnvironmentAnswer2;
                }
                if (!nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) continue;
                nameEnvironmentAnswer = nameEnvironmentAnswer2;
            }
        } else {
            String string5 = string2.replace('/', File.separatorChar);
            for (Classpath classpath : this.classpaths) {
                NameEnvironmentAnswer nameEnvironmentAnswer3;
                NameEnvironmentAnswer nameEnvironmentAnswer4 = nameEnvironmentAnswer3 = classpath instanceof ClasspathJar ? classpath.findClass(cArray, string3, string2) : classpath.findClass(cArray, string4, string5);
                if (nameEnvironmentAnswer3 == null) continue;
                if (!nameEnvironmentAnswer3.ignoreIfBetter()) {
                    if (!nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) continue;
                    return nameEnvironmentAnswer3;
                }
                if (!nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) continue;
                nameEnvironmentAnswer = nameEnvironmentAnswer3;
            }
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] cArray) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1]);
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray);
        }
        return null;
    }

    @Override
    public boolean isPackage(char[][] cArray, char[] cArray2) {
        String string;
        String string2 = new String(CharOperation.concatWith(cArray, cArray2, '/'));
        String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
        if (string2 == string) {
            int n = this.classpaths.length;
            for (int i = 0; i < n; ++i) {
                if (!this.classpaths[i].isPackage(string2)) continue;
                return true;
            }
        } else {
            for (Classpath classpath : this.classpaths) {
                if (!(classpath instanceof ClasspathJar ? classpath.isPackage(string2) : classpath.isPackage(string))) continue;
                return true;
            }
        }
        return false;
    }

    public static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();

        public char[] normalizedPath();

        public String getPath();

        public void initialize() throws IOException;
    }
}

