/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public BranchLabel continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    private UnconditionalFlowInfo upstreamNullFlowInfo;
    private LoopingFlowContext[] innerFlowContexts = null;
    private UnconditionalFlowInfo[] innerFlowInfos = null;
    private int innerFlowContextsNb = 0;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext flowContext, FlowInfo flowInfo, ASTNode aSTNode, BranchLabel branchLabel, BranchLabel branchLabel2, Scope scope) {
        super(flowContext, aSTNode, branchLabel);
        this.preemptNullDiagnostic = true;
        this.continueLabel = branchLabel2;
        this.associatedScope = scope;
        this.upstreamNullFlowInfo = flowInfo.unconditionalCopy();
    }

    public void complainOnDeferredFinalChecks(BlockScope blockScope, FlowInfo flowInfo) {
        for (int i = 0; i < this.assignCount; ++i) {
            VariableBinding variableBinding = this.finalVariables[i];
            if (variableBinding == null) continue;
            boolean bl = false;
            if (variableBinding instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)variableBinding)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variableBinding, this.finalAssignments[i]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variableBinding)) {
                bl = true;
                blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variableBinding, this.finalAssignments[i]);
            }
            if (!bl) continue;
            FlowContext flowContext = this.parent;
            while (flowContext != null) {
                flowContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                flowContext = flowContext.parent;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void complainOnDeferredNullChecks(BlockScope blockScope, FlowInfo flowInfo) {
        int n;
        for (n = 0; n < this.innerFlowContextsNb; ++n) {
            this.upstreamNullFlowInfo.addPotentialNullInfoFrom(this.innerFlowContexts[n].upstreamNullFlowInfo).addPotentialNullInfoFrom(this.innerFlowInfos[n]);
        }
        this.innerFlowContextsNb = 0;
        flowInfo = this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
        if (this.deferNullDiagnostic) {
            block12: for (n = 0; n < this.nullCount; ++n) {
                LocalVariableBinding localVariableBinding = this.nullLocals[n];
                Expression expression = this.nullReferences[n];
                switch (this.nullCheckTypes[n]) {
                    case 23: {
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                        continue block12;
                    }
                    case 20: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            this.nullReferences[n] = null;
                            blockScope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                            continue block12;
                        }
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                        continue block12;
                    }
                    case 21: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                        continue block12;
                    }
                    case 22: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                        continue block12;
                    }
                }
                this.parent.recordUsingNullReference(blockScope, localVariableBinding, expression, this.nullCheckTypes[n], flowInfo);
            }
            return;
        }
        block13: for (n = 0; n < this.nullCount; ++n) {
            Expression expression = this.nullReferences[n];
            LocalVariableBinding localVariableBinding = this.nullLocals[n];
            switch (this.nullCheckTypes[n]) {
                case 20: {
                    if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                        continue block13;
                    }
                }
                case 21: {
                    if (!flowInfo.isDefinitelyNull(localVariableBinding)) continue block13;
                    this.nullReferences[n] = null;
                    blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    continue block13;
                }
                case 22: {
                    if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                        continue block13;
                    }
                    if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block13;
                    this.nullReferences[n] = null;
                    blockScope.problemReporter().localVariableMayBeNull(localVariableBinding, expression);
                    continue block13;
                }
            }
        }
    }

    @Override
    public BranchLabel continueLabel() {
        return this.continueLabel;
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Looping flow context");
        stringBuffer.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        stringBuffer.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    @Override
    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.initsOnContinue = (this.initsOnContinue.tagBits & 1) == 0 ? this.initsOnContinue.mergedWith(flowInfo.unconditionalInitsWithoutSideEffect()) : flowInfo.unconditionalCopy();
            FlowContext flowContext2 = flowContext;
            while (flowContext2 != this && !(flowContext2 instanceof LoopingFlowContext)) {
                flowContext2 = flowContext2.parent;
            }
            if (flowContext2 == this) {
                this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
            } else {
                int n = 0;
                if (this.innerFlowContexts == null) {
                    this.innerFlowContexts = new LoopingFlowContext[5];
                    this.innerFlowInfos = new UnconditionalFlowInfo[5];
                } else {
                    n = this.innerFlowContexts.length;
                    if (this.innerFlowContextsNb == n - 1) {
                        this.innerFlowContexts = new LoopingFlowContext[n + 5];
                        System.arraycopy(this.innerFlowContexts, 0, this.innerFlowContexts, 0, n);
                        this.innerFlowInfos = new UnconditionalFlowInfo[n + 5];
                        System.arraycopy(this.innerFlowInfos, 0, this.innerFlowInfos, 0, n);
                    }
                }
                this.innerFlowContexts[this.innerFlowContextsNb] = (LoopingFlowContext)flowContext2;
                this.innerFlowInfos[this.innerFlowContextsNb++] = flowInfo.unconditionalInitsWithoutSideEffect();
            }
        }
    }

    @Override
    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (variableBinding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)variableBinding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    @Override
    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            this.nullLocals = new LocalVariableBinding[this.nullCount * 2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[this.nullCount * 2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }

    @Override
    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n) {
            case 20: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isPotentiallyNonNull(localVariableBinding)) {
                    this.recordNullReference(localVariableBinding, expression, 23);
                } else {
                    this.recordNullReference(localVariableBinding, expression, n);
                }
                return;
            }
            case 21: {
                if (flowInfo.isPotentiallyNonNull(localVariableBinding) || flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                this.recordNullReference(localVariableBinding, expression, n);
                return;
            }
            case 22: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableMayBeNull(localVariableBinding, expression);
                    return;
                }
                this.recordNullReference(localVariableBinding, expression, n);
                return;
            }
        }
    }

    @Override
    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }
}

