/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;

    public LocalVariableBinding(char[] cArray, TypeBinding typeBinding, int n, boolean bl) {
        super(cArray, typeBinding, n, bl ? Constant.NotAConstant : null);
        if (bl) {
            this.tagBits |= 0x400L;
        }
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, boolean bl) {
        this(localDeclaration.name, typeBinding, n, bl);
        this.declaration = localDeclaration;
    }

    @Override
    public final int kind() {
        return 2;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        Binding binding;
        StringBuffer stringBuffer = new StringBuffer();
        BlockScope blockScope = this.declaringScope;
        MethodScope methodScope = blockScope instanceof MethodScope ? (MethodScope)blockScope : blockScope.enclosingMethodScope();
        ReferenceContext referenceContext = methodScope.referenceContext;
        if (referenceContext instanceof AbstractMethodDeclaration) {
            binding = ((AbstractMethodDeclaration)referenceContext).binding;
            if (binding != null) {
                stringBuffer.append(((MethodBinding)binding).computeUniqueKey(false));
            }
        } else if (referenceContext instanceof TypeDeclaration && (binding = ((TypeDeclaration)referenceContext).binding) != null) {
            stringBuffer.append(binding.computeUniqueKey(false));
        }
        this.getScopeKey(blockScope, stringBuffer);
        stringBuffer.append('#');
        stringBuffer.append(this.name);
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.declaringScope == null) {
            return Binding.NO_ANNOTATIONS;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        AnnotationBinding[] annotationBindingArray = sourceTypeBinding.retrieveAnnotations(this);
        if ((this.tagBits & 0x200000000L) == 0L && (this.tagBits & 0x400L) != 0L && this.declaration != null && (annotationArray = this.declaration.annotations) != null) {
            int n = annotationArray.length;
            ASTNode.resolveAnnotations(this.declaringScope, annotationArray, this);
            annotationBindingArray = new AnnotationBinding[n];
            for (int i = 0; i < n; ++i) {
                annotationBindingArray[i] = new AnnotationBinding(annotationArray[i]);
            }
            this.setAnnotations(annotationBindingArray);
        }
        return annotationBindingArray;
    }

    private void getScopeKey(BlockScope blockScope, StringBuffer stringBuffer) {
        int n = blockScope.scopeIndex();
        if (n != -1) {
            this.getScopeKey((BlockScope)blockScope.parent, stringBuffer);
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public void recordInitializationEndPC(int n) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = n;
        }
    }

    public void recordInitializationStartPC(int n) {
        int n2;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            n2 = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((n2 = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, n2);
        }
        this.initializationPCs[n2] = n;
        this.initializationPCs[n2 + 1] = -1;
        ++this.initializationCount;
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        if (this.declaringScope == null) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding != null) {
            sourceTypeBinding.storeAnnotations(this, annotationBindingArray);
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        switch (this.useFlag) {
            case 1: {
                string = string + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                string = string + "[pos: unused]";
                break;
            }
            case 2: {
                string = string + "[pos: fake_used]";
            }
        }
        string = string + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            string = string + "[pc: ";
            for (int i = 0; i < this.initializationCount; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + String.valueOf(this.initializationPCs[i << 1]) + "-" + (this.initializationPCs[(i << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(i << 1) + 1]));
            }
            string = string + "]";
        }
        return string;
    }
}

