/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public final class HashtableOfType {
    public char[][] keyTable;
    public ReferenceBinding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfType() {
        this(3);
    }

    public HashtableOfType(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new ReferenceBinding[n2];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public ReferenceBinding get(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public ReferenceBinding put(char[] cArray, ReferenceBinding referenceBinding) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = referenceBinding;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = referenceBinding;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return referenceBinding;
    }

    private void rehash() {
        HashtableOfType hashtableOfType = new HashtableOfType(this.elementSize < 100 ? 100 : this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfType.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfType.keyTable;
        this.valueTable = hashtableOfType.valueTable;
        this.threshold = hashtableOfType.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        for (ReferenceBinding referenceBinding : this.valueTable) {
            if (referenceBinding == null) continue;
            string = string + referenceBinding.toString() + "\n";
        }
        return string;
    }
}

