/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class DateAxis
extends ValueAxis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1013460999649007604L;
    public static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE_IN_MILLISECONDS = 2.0;
    public static final DateTickUnit DEFAULT_DATE_TICK_UNIT = new DateTickUnit(2, 1, new SimpleDateFormat());
    public static final Date DEFAULT_ANCHOR_DATE = new Date();
    private DateTickUnit tickUnit;
    private DateFormat dateFormatOverride;
    private DateTickMarkPosition tickMarkPosition = DateTickMarkPosition.START;
    private static final Timeline DEFAULT_TIMELINE = new DefaultTimeline();
    private TimeZone timeZone;
    private Timeline timeline;

    public DateAxis() {
        this(null);
    }

    public DateAxis(String string) {
        this(string, TimeZone.getDefault());
    }

    public DateAxis(String string, TimeZone timeZone) {
        super(string, DateAxis.createStandardDateTickUnits(timeZone));
        this.setTickUnit(DEFAULT_DATE_TICK_UNIT, false, false);
        this.setAutoRangeMinimumSize(2.0);
        this.setRange(DEFAULT_DATE_RANGE, false, false);
        this.dateFormatOverride = null;
        this.timeZone = timeZone;
        this.timeline = DEFAULT_TIMELINE;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (!this.timeZone.equals(timeZone)) {
            this.timeZone = timeZone;
            this.setStandardTickUnits(DateAxis.createStandardDateTickUnits(timeZone));
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Timeline timeline) {
        if (this.timeline != timeline) {
            this.timeline = timeline;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateTickUnit dateTickUnit) {
        this.setTickUnit(dateTickUnit, true, true);
    }

    public void setTickUnit(DateTickUnit dateTickUnit, boolean bl, boolean bl2) {
        this.tickUnit = dateTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateFormat getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    public void setDateFormatOverride(DateFormat dateFormat) {
        this.dateFormatOverride = dateFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    @Override
    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    @Override
    public void setRange(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        super.setRange(range, bl, bl2);
    }

    public void setRange(Date date, Date date2) {
        if (date.getTime() >= date2.getTime()) {
            throw new IllegalArgumentException("Requires 'lower' < 'upper'.");
        }
        this.setRange(new DateRange(date, date2));
    }

    @Override
    public void setRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Requires 'lower' < 'upper'.");
        }
        this.setRange(new DateRange(d, d2));
    }

    public Date getMinimumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getLowerDate();
        } else {
            date = new Date((long)range.getLowerBound());
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        this.setRange(new DateRange(date, this.getMaximumDate()), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMaximumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getUpperDate();
        } else {
            date = new Date((long)range.getUpperBound());
        }
        return date;
    }

    public void setMaximumDate(Date date) {
        this.setRange(new DateRange(this.getMinimumDate(), date), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public DateTickMarkPosition getTickMarkPosition() {
        return this.tickMarkPosition;
    }

    public void setTickMarkPosition(DateTickMarkPosition dateTickMarkPosition) {
        if (dateTickMarkPosition == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.tickMarkPosition = dateTickMarkPosition;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public boolean isHiddenValue(long l) {
        return !this.timeline.containsDomainValue(new Date(l));
    }

    @Override
    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        d = this.timeline.toTimelineValue((long)d);
        DateRange dateRange = (DateRange)this.getRange();
        double d2 = this.timeline.toTimelineValue(dateRange.getLowerDate());
        double d3 = this.timeline.toTimelineValue(dateRange.getUpperDate());
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d5 = rectangle2D.getX();
            double d6 = rectangle2D.getMaxX();
            d4 = this.isInverted() ? d6 + (d - d2) / (d3 - d2) * (d5 - d6) : d5 + (d - d2) / (d3 - d2) * (d6 - d5);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d7 = rectangle2D.getMinY();
            double d8 = rectangle2D.getMaxY();
            d4 = this.isInverted() ? d7 + (d - d2) / (d3 - d2) * (d8 - d7) : d8 - (d - d2) / (d3 - d2) * (d8 - d7);
        }
        return d4;
    }

    public double dateToJava2D(Date date, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = date.getTime();
        return this.valueToJava2D(d, rectangle2D, rectangleEdge);
    }

    @Override
    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        DateRange dateRange = (DateRange)this.getRange();
        double d2 = this.timeline.toTimelineValue(dateRange.getLowerDate());
        double d3 = this.timeline.toTimelineValue(dateRange.getUpperDate());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        double d6 = this.isInverted() ? d3 - (d - d4) / (d5 - d4) * (d3 - d2) : d2 + (d - d4) / (d5 - d4) * (d3 - d2);
        return this.timeline.toMillisecond((long)d6);
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.nextStandardDate(this.getMinimumDate(), dateTickUnit);
    }

    public Date calculateHighestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.previousStandardDate(this.getMaximumDate(), dateTickUnit);
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(date);
        int n = dateTickUnit.getCount();
        int n2 = calendar.get(dateTickUnit.getCalendarField());
        int n3 = n * (n2 / n);
        switch (dateTickUnit.getUnit()) {
            case 6: {
                int n4 = calendar.get(1);
                int n5 = calendar.get(2);
                int n6 = calendar.get(5);
                int n7 = calendar.get(11);
                int n8 = calendar.get(12);
                int n9 = calendar.get(13);
                calendar.set(n4, n5, n6, n7, n8, n9);
                calendar.set(14, n3);
                return calendar.getTime();
            }
            case 5: {
                int n10 = calendar.get(1);
                int n11 = calendar.get(2);
                int n12 = calendar.get(5);
                int n13 = calendar.get(11);
                int n14 = calendar.get(12);
                int n15 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 500 : 999);
                calendar.set(14, n15);
                calendar.set(n10, n11, n12, n13, n14, n3);
                return calendar.getTime();
            }
            case 4: {
                int n16 = calendar.get(1);
                int n17 = calendar.get(2);
                int n18 = calendar.get(5);
                int n19 = calendar.get(11);
                int n20 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 30 : 59);
                calendar.clear(14);
                calendar.set(n16, n17, n18, n19, n3, n20);
                Date date2 = calendar.getTime();
                if (date2.getTime() >= date.getTime()) {
                    calendar.set(12, n3 - 1);
                    date2 = calendar.getTime();
                }
                return date2;
            }
            case 3: {
                int n21;
                int n22;
                int n23 = calendar.get(1);
                int n24 = calendar.get(2);
                int n25 = calendar.get(5);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n22 = 0;
                    n21 = 0;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n22 = 30;
                    n21 = 0;
                } else {
                    n22 = 59;
                    n21 = 59;
                }
                calendar.clear(14);
                calendar.set(n23, n24, n25, n3, n22, n21);
                Date date3 = calendar.getTime();
                if (date3.getTime() >= date.getTime()) {
                    calendar.set(11, n3 - 1);
                    date3 = calendar.getTime();
                }
                return date3;
            }
            case 2: {
                int n26;
                int n27 = calendar.get(1);
                int n28 = calendar.get(2);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n26 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n26 = 12;
                    boolean bl = false;
                    boolean bl3 = false;
                } else {
                    n26 = 23;
                    int n29 = 59;
                    int n30 = 59;
                }
                calendar.clear(14);
                calendar.set(n27, n28, n3, n26, 0, 0);
                Date date4 = calendar.getTime();
                if (date4.getTime() >= date.getTime()) {
                    calendar.set(5, n3 - 1);
                    date4 = calendar.getTime();
                }
                return date4;
            }
            case 1: {
                int n31 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n31, n3, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime());
                Date date5 = this.calculateDateForPosition(month, this.tickMarkPosition);
                long l = date5.getTime();
                if (l > date.getTime()) {
                    month = (Month)month.previous();
                    date5 = this.calculateDateForPosition(month, this.tickMarkPosition);
                }
                return date5;
            }
            case 0: {
                int n32;
                int n33;
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n33 = 0;
                    n32 = 1;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n33 = 6;
                    n32 = 1;
                } else {
                    n33 = 11;
                    n32 = 31;
                }
                calendar.clear(14);
                calendar.set(n3, n33, n32, 0, 0, 0);
                Date date6 = calendar.getTime();
                if (date6.getTime() >= date.getTime()) {
                    calendar.set(1, n3 - 1);
                    date6 = calendar.getTime();
                }
                return date6;
            }
        }
        return null;
    }

    private Date calculateDateForPosition(RegularTimePeriod regularTimePeriod, DateTickMarkPosition dateTickMarkPosition) {
        if (dateTickMarkPosition == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        Date date = null;
        if (dateTickMarkPosition == DateTickMarkPosition.START) {
            date = new Date(regularTimePeriod.getFirstMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.MIDDLE) {
            date = new Date(regularTimePeriod.getMiddleMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.END) {
            date = new Date(regularTimePeriod.getLastMillisecond());
        }
        return date;
    }

    protected Date nextStandardDate(Date date, DateTickUnit dateTickUnit) {
        Date date2 = this.previousStandardDate(date, dateTickUnit);
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(date2);
        calendar.add(dateTickUnit.getCalendarField(), dateTickUnit.getCount());
        return calendar.getTime();
    }

    public static TickUnitSource createStandardDateTickUnits() {
        return DateAxis.createStandardDateTickUnits(TimeZone.getDefault());
    }

    public static TickUnitSource createStandardDateTickUnits(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        TickUnits tickUnits = new TickUnits();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("HH:mm");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("d-MMM, HH:mm");
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("MMM-yyyy");
        SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy");
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat2.setTimeZone(timeZone);
        simpleDateFormat3.setTimeZone(timeZone);
        simpleDateFormat4.setTimeZone(timeZone);
        simpleDateFormat5.setTimeZone(timeZone);
        simpleDateFormat6.setTimeZone(timeZone);
        simpleDateFormat7.setTimeZone(timeZone);
        tickUnits.add(new DateTickUnit(6, 1, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 5, 6, 1, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 10, 6, 1, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 25, 6, 5, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 50, 6, 10, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 100, 6, 10, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 250, 6, 10, simpleDateFormat));
        tickUnits.add(new DateTickUnit(6, 500, 6, 50, simpleDateFormat));
        tickUnits.add(new DateTickUnit(5, 1, 6, 50, simpleDateFormat2));
        tickUnits.add(new DateTickUnit(5, 5, 5, 1, simpleDateFormat2));
        tickUnits.add(new DateTickUnit(5, 10, 5, 1, simpleDateFormat2));
        tickUnits.add(new DateTickUnit(5, 30, 5, 5, simpleDateFormat2));
        tickUnits.add(new DateTickUnit(4, 1, 5, 5, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 2, 5, 10, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 5, 4, 1, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 10, 4, 1, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 15, 4, 5, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 20, 4, 5, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(4, 30, 4, 5, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(3, 1, 4, 5, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(3, 2, 4, 10, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(3, 4, 4, 30, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(3, 6, 3, 1, simpleDateFormat3));
        tickUnits.add(new DateTickUnit(3, 12, 3, 1, simpleDateFormat4));
        tickUnits.add(new DateTickUnit(2, 1, 3, 1, simpleDateFormat5));
        tickUnits.add(new DateTickUnit(2, 2, 3, 1, simpleDateFormat5));
        tickUnits.add(new DateTickUnit(2, 7, 2, 1, simpleDateFormat5));
        tickUnits.add(new DateTickUnit(2, 15, 2, 1, simpleDateFormat5));
        tickUnits.add(new DateTickUnit(1, 1, 2, 1, simpleDateFormat6));
        tickUnits.add(new DateTickUnit(1, 2, 2, 1, simpleDateFormat6));
        tickUnits.add(new DateTickUnit(1, 3, 1, 1, simpleDateFormat6));
        tickUnits.add(new DateTickUnit(1, 4, 1, 1, simpleDateFormat6));
        tickUnits.add(new DateTickUnit(1, 6, 1, 1, simpleDateFormat6));
        tickUnits.add(new DateTickUnit(0, 1, 1, 1, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 2, 1, 3, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 5, 0, 1, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 10, 0, 1, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 25, 0, 5, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 50, 0, 10, simpleDateFormat7));
        tickUnits.add(new DateTickUnit(0, 100, 0, 20, simpleDateFormat7));
        return tickUnits;
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            long l;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.timeline instanceof SegmentedTimeline ? new DateRange(((SegmentedTimeline)this.timeline).getStartTime(), ((SegmentedTimeline)this.timeline).getStartTime() + 1L) : new DateRange();
            }
            long l2 = this.timeline.toTimelineValue((long)range.getUpperBound());
            long l3 = (long)this.getFixedAutoRange();
            if ((double)l3 > 0.0) {
                l = l2 - l3;
            } else {
                long l4;
                l = this.timeline.toTimelineValue((long)range.getLowerBound());
                double d = l2 - l;
                if (d < (double)(l4 = (long)this.getAutoRangeMinimumSize())) {
                    long l5 = (long)((double)l4 - d) / 2L;
                    l2 += l5;
                    l -= l5;
                }
                l2 += (long)(d * this.getUpperMargin());
                l -= (long)(d * this.getLowerMargin());
            }
            l2 = this.timeline.toMillisecond(l2);
            l = this.timeline.toMillisecond(l);
            DateRange dateRange = new DateRange(new Date(l), new Date(l2));
            this.setRange(dateRange, false, false);
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        long l = 0L;
        if (this.timeline instanceof SegmentedTimeline) {
            l = ((SegmentedTimeline)this.timeline).getStartTime();
        }
        double d = this.valueToJava2D((double)l + 0.0, rectangle2D, rectangleEdge);
        double d2 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.valueToJava2D((double)l + tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d4 = Math.abs(d3 - d);
        double d5 = d2 / d4 * tickUnit.getSize();
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d5);
        double d6 = this.valueToJava2D((double)l + dateTickUnit.getSize(), rectangle2D, rectangleEdge);
        double d7 = Math.abs(d6 - d);
        d2 = this.estimateMaximumTickLabelWidth(graphics2D, dateTickUnit);
        if (d2 > d7) {
            dateTickUnit = (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit);
        }
        this.setTickUnit(dateTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d;
        double d2;
        double d3;
        double d4;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        double d5 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d6 = this.getRange().getLength() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d6);
        double d7 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit);
        double d8 = d7 / (d4 = Math.abs((d3 = this.valueToJava2D(dateTickUnit.getSize(), rectangle2D, rectangleEdge)) - d5)) * dateTickUnit.getSize();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d8);
        double d9 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d9 < (d2 = Math.abs((d = this.valueToJava2D(dateTickUnit2.getSize(), rectangle2D, rectangleEdge)) - d5)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit2);
        this.setTickUnit(dateTickUnit3, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getLeft() + rectangleInsets.getRight();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (this.isVerticalTickLabels()) {
            d += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.dateToString(date);
                string2 = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d2 = fontMetrics.stringWidth(string);
            double d3 = fontMetrics.stringWidth(string2);
            d += Math.max(d2, d3);
        }
        return d;
    }

    private double estimateMaximumTickLabelHeight(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (!this.isVerticalTickLabels()) {
            d += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.dateToString(date);
                string2 = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d2 = fontMetrics.stringWidth(string);
            double d3 = fontMetrics.stringWidth(string2);
            d += Math.max(d2, d3);
        }
        return d;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        block5: while (date.before(date2)) {
            double d;
            TextAnchor textAnchor;
            TextAnchor textAnchor2;
            String string;
            if (!this.isHiddenValue(date.getTime())) {
                DateFormat dateFormat = this.getDateFormatOverride();
                string = dateFormat != null ? dateFormat.format(date) : this.tickUnit.dateToString(date);
                textAnchor2 = null;
                textAnchor = null;
                d = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    d = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor2 = TextAnchor.TOP_CENTER;
                    textAnchor = TextAnchor.TOP_CENTER;
                }
            } else {
                date = dateTickUnit.rollDate(date);
                continue;
            }
            DateTick dateTick = new DateTick(date, string, textAnchor2, textAnchor, d);
            arrayList.add(dateTick);
            date = dateTickUnit.addToDate(date);
            switch (dateTickUnit.getUnit()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: {
                    date = this.calculateDateForPosition(new Month(date), this.tickMarkPosition);
                    continue block5;
                }
                case 0: {
                    date = this.calculateDateForPosition(new Year(date), this.tickMarkPosition);
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        while (date.before(date2)) {
            if (!this.isHiddenValue(date.getTime())) {
                DateFormat dateFormat = this.getDateFormatOverride();
                String string = dateFormat != null ? dateFormat.format(date) : this.tickUnit.dateToString(date);
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    d = rectangleEdge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                DateTick dateTick = new DateTick(date, string, textAnchor, textAnchor2, d);
                arrayList.add(dateTick);
                date = dateTickUnit.addToDate(date);
                continue;
            }
            date = dateTickUnit.rollDate(date);
        }
        return arrayList;
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    @Override
    public void zoomRange(double d, double d2) {
        double d3 = this.timeline.toTimelineValue((long)this.getRange().getLowerBound());
        double d4 = this.timeline.toTimelineValue((long)this.getRange().getUpperBound()) - this.timeline.toTimelineValue((long)this.getRange().getLowerBound());
        DateRange dateRange = null;
        dateRange = this.isInverted() ? new DateRange(this.timeline.toMillisecond((long)(d3 + d4 * (1.0 - d2))), this.timeline.toMillisecond((long)(d3 + d4 * (1.0 - d)))) : new DateRange(this.timeline.toMillisecond((long)(d3 + d4 * d)), this.timeline.toMillisecond((long)(d3 + d4 * d2)));
        this.setRange(dateRange);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DateAxis)) {
            return false;
        }
        DateAxis dateAxis = (DateAxis)object;
        if (!ObjectUtilities.equal(this.tickUnit, dateAxis.tickUnit)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dateFormatOverride, dateAxis.dateFormatOverride)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickMarkPosition, dateAxis.tickMarkPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.timeline, dateAxis.timeline)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.getLabel() != null) {
            return this.getLabel().hashCode();
        }
        return 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DateAxis dateAxis = (DateAxis)super.clone();
        if (this.dateFormatOverride != null) {
            dateAxis.dateFormatOverride = (DateFormat)this.dateFormatOverride.clone();
        }
        return dateAxis;
    }

    private static class DefaultTimeline
    implements Timeline,
    Serializable {
        private DefaultTimeline() {
        }

        @Override
        public long toTimelineValue(long l) {
            return l;
        }

        @Override
        public long toTimelineValue(Date date) {
            return date.getTime();
        }

        @Override
        public long toMillisecond(long l) {
            return l;
        }

        @Override
        public boolean containsDomainValue(long l) {
            return true;
        }

        @Override
        public boolean containsDomainValue(Date date) {
            return true;
        }

        @Override
        public boolean containsDomainRange(long l, long l2) {
            return true;
        }

        @Override
        public boolean containsDomainRange(Date date, Date date2) {
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object instanceof DefaultTimeline;
        }
    }
}

