/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DefaultKeyedValue;
import org.jfree.data.KeyedValue;
import org.jfree.data.KeyedValueComparator;
import org.jfree.data.KeyedValueComparatorType;
import org.jfree.data.KeyedValues;
import org.jfree.data.UnknownKeyException;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class DefaultKeyedValues
implements KeyedValues,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8468154364608194797L;
    private List data = new ArrayList();

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    @Override
    public Number getValue(int n) {
        Number number = null;
        KeyedValue keyedValue = (KeyedValue)this.data.get(n);
        if (keyedValue != null) {
            number = keyedValue.getValue();
        }
        return number;
    }

    @Override
    public Comparable getKey(int n) {
        Comparable comparable = null;
        KeyedValue keyedValue = (KeyedValue)this.data.get(n);
        if (keyedValue != null) {
            comparable = keyedValue.getKey();
        }
        return comparable;
    }

    @Override
    public int getIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n = 0;
        for (KeyedValue keyedValue : this.data) {
            if (keyedValue.getKey().equals(comparable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (KeyedValue keyedValue : this.data) {
            arrayList.add(keyedValue.getKey());
        }
        return arrayList;
    }

    @Override
    public Number getValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Key not found: " + comparable);
        }
        return this.getValue(n);
    }

    public void addValue(Comparable comparable, double d) {
        this.addValue(comparable, new Double(d));
    }

    public void addValue(Comparable comparable, Number number) {
        this.setValue(comparable, number);
    }

    public void setValue(Comparable comparable, double d) {
        this.setValue(comparable, new Double(d));
    }

    public void setValue(Comparable comparable, Number number) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n = this.getIndex(comparable);
        if (n >= 0) {
            DefaultKeyedValue defaultKeyedValue = (DefaultKeyedValue)this.data.get(n);
            defaultKeyedValue.setValue(number);
        } else {
            DefaultKeyedValue defaultKeyedValue = new DefaultKeyedValue(comparable, number);
            this.data.add(defaultKeyedValue);
        }
    }

    public void removeValue(int n) {
        this.data.remove(n);
    }

    public void removeValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            this.removeValue(n);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public void sortByKeys(SortOrder sortOrder) {
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_KEY, sortOrder);
        Collections.sort(this.data, keyedValueComparator);
    }

    public void sortByValues(SortOrder sortOrder) {
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_VALUE, sortOrder);
        Collections.sort(this.data, keyedValueComparator);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues)) {
            return false;
        }
        KeyedValues keyedValues = (KeyedValues)object;
        int n = this.getItemCount();
        if (n != keyedValues.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = keyedValues.getKey(i))) {
                return false;
            }
            Number number = this.getValue(i);
            Number number2 = keyedValues.getValue(i);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)super.clone();
        defaultKeyedValues.data = (List)ObjectUtilities.deepClone(this.data);
        return defaultKeyedValues;
    }
}

