/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorDeducoesPrevPrivadaComFapi
extends ValidadorDefault {
    private static final String MSG_LIMITE_DEDUCAO_PREVI_PRIV_E_FAPI = "<HTML>As dedu\u00e7\u00f5es relativas a Contribui\u00e7\u00f5es a Entidades de Previd\u00eancia Privada e<BR> ao FAPI n\u00e3o podem exceder, em conjunto, a 12% dos rendimentos tribut\u00e1veis.";
    private static final String MSG_FINAL_LIMITE_DEDUCAO_PREVI_PRIV_E_FAPI = "Para  o  c\u00e1lculo do imposto devido, o  programa levar\u00e1 em considera\u00e7\u00e3o o limite legal,<BR> entretanto, nesta ficha devem ser informados os valores efetivamente pagos,<BR> independentemente do limite de dedu\u00e7\u00e3o.</HTML>";
    private Valor previdencia;
    private Valor fAPI;
    private Valor totalRendimentosTributaveis;
    private Valor totalLimitado;
    private Valor fapiComPrevPrivada;
    private Valor limiteDeducPrevPrivada;
    private DeclaracaoIRPF declaracaoIRPF = null;
    private Pagamento pagamento = null;
    private String msg = "";

    public ValidadorDeducoesPrevPrivadaComFapi(byte by, DeclaracaoIRPF declaracaoIRPF, Pagamento pagamento) {
        super(by);
        this.declaracaoIRPF = declaracaoIRPF;
        this.pagamento = pagamento;
    }

    @Override
    public RetornoValidacao validarImplementado() {
        boolean bl;
        this.msg = "";
        boolean bl2 = bl = this.pagamento.getCodigo().asString().equals("14") || this.pagamento.getCodigo().asString().equals("13");
        if (bl) {
            this.previdencia = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"13"}, true);
            this.fAPI = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"14"}, true);
            this.fapiComPrevPrivada = new Valor();
            this.fapiComPrevPrivada.append('+', this.previdencia);
            this.fapiComPrevPrivada.append('+', this.fAPI);
            this.totalLimitado = this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFAPI();
            this.totalRendimentosTributaveis = new Valor();
            this.totalRendimentosTributaveis.setConteudo(this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos());
            this.limiteDeducPrevPrivada = this.totalRendimentosTributaveis.operacao('*', "0,12");
            if (bl && this.fapiComPrevPrivada.comparacao(">", this.totalLimitado)) {
                this.msg = "<HTML>As dedu\u00e7\u00f5es relativas a Contribui\u00e7\u00f5es a Entidades de Previd\u00eancia Privada e<BR> ao FAPI n\u00e3o podem exceder, em conjunto, a 12% dos rendimentos tribut\u00e1veis.<br>De acordo com os dados da sua declara\u00e7\u00e3o, o total destas dedu\u00e7\u00f5es \u00e9: " + this.fapiComPrevPrivada + " e o limite legal \u00e9: " + this.totalLimitado.toString() + " conforme demosntrativo abaixo.<br><br>\"Contribui\u00e7\u00e3o \u00e0 previd\u00eancia privada\": " + this.previdencia.toString() + "<br><br>\"FAPI\": " + this.fAPI.toString() + "<br><br>\"Total de contribui\u00e7\u00e3o \u00e0 previd\u00eancia privada e FAPI\": " + this.fapiComPrevPrivada.toString() + "<br><br>\"Total dos rendimentos tribut\u00e1veis\": " + this.totalRendimentosTributaveis.toString() + "<br><br>\"12% do rendimento tribut\u00e1vel\": " + this.limiteDeducPrevPrivada.toString() + "<br><br>Para  o  c\u00e1lculo do imposto devido, o  programa levar\u00e1 em considera\u00e7\u00e3o o limite legal,<BR> entretanto, nesta ficha devem ser informados os valores efetivamente pagos,<BR> independentemente do limite de dedu\u00e7\u00e3o.</HTML>";
            }
        }
        if (this.msg != null && !this.msg.equals("")) {
            RetornoValidacao retornoValidacao = new RetornoValidacao("<HTML>As dedu\u00e7\u00f5es relativas a Contribui\u00e7\u00f5es a Entidades de Previd\u00eancia Privada e<BR> ao FAPI n\u00e3o podem exceder, em conjunto, a 12% dos rendimentos tribut\u00e1veis.</HTML>");
            retornoValidacao.setMensagemValidacaoExtendida(this.msg);
            return retornoValidacao;
        }
        return null;
    }
}

