/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.barcode.util;

import java.util.Date;
import java.util.GregorianCalendar;

public class JulianDate {
    private int year;
    private int month;
    private int day;
    private GregorianCalendar calendar;

    public JulianDate() {
        this.calendar = new GregorianCalendar();
        this.calendar.setGregorianChange(new Date());
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        ++this.month;
        this.day = this.calendar.get(5);
    }

    public JulianDate(Date date) {
        this.calendar = new GregorianCalendar();
        this.calendar.setGregorianChange(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        ++this.month;
        this.day = this.calendar.get(5);
    }

    public JulianDate(String string) throws Exception {
        if (string.length() == 8) {
            this.day = Integer.parseInt(string.substring(0, 2));
            this.month = Integer.parseInt(string.substring(2, 4));
            this.year = Integer.parseInt(string.substring(4));
        } else if (string.length() == 10) {
            this.day = Integer.parseInt(string.substring(0, 2));
            this.month = Integer.parseInt(string.substring(3, 5));
            this.year = Integer.parseInt(string.substring(6));
        } else {
            throw new Exception("Invalid format.");
        }
        this.calendar = new GregorianCalendar(this.year, this.month - 1, this.day);
    }

    public JulianDate(int n, int n2, int n3) throws Exception {
        this.day = n;
        this.month = n2;
        this.year = n3;
        this.calendar = new GregorianCalendar(n3, n2 - 1, n);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String getJulianDate7Digits() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.calendar.get(6);
        if (n < 10) {
            stringBuffer2.append("00").append(n);
        } else if (n >= 10 && n < 100) {
            stringBuffer2.append("0");
        }
        stringBuffer2.append(n);
        stringBuffer.append(this.year).append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    public String getJulianDate4Digits() {
        return this.getJulianDate7Digits().substring(3);
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }
}

