/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;

public class RulesBase
implements Rules {
    protected HashMap cache = new HashMap();
    protected Digester digester = null;
    protected String namespaceURI = null;
    protected ArrayList rules = new ArrayList();

    public Digester getDigester() {
        return this.digester;
    }

    public void setDigester(Digester digester) {
        this.digester = digester;
        for (Rule rule : this.rules) {
            rule.setDigester(digester);
        }
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public void add(String string, Rule rule) {
        ArrayList<Rule> arrayList;
        int n = string.length();
        if (n > 1 && string.endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        if ((arrayList = (ArrayList<Rule>)this.cache.get(string)) == null) {
            arrayList = new ArrayList<Rule>();
            this.cache.put(string, arrayList);
        }
        arrayList.add(rule);
        this.rules.add(rule);
        if (this.digester != null) {
            rule.setDigester(this.digester);
        }
        if (this.namespaceURI != null) {
            rule.setNamespaceURI(this.namespaceURI);
        }
    }

    public void clear() {
        this.cache.clear();
        this.rules.clear();
    }

    public List match(String string) {
        return this.match(null, string);
    }

    public List match(String string, String string2) {
        List list = this.lookup(string, string2);
        if (list == null || list.size() < 1) {
            String string3 = "";
            for (String string4 : this.cache.keySet()) {
                if (!string4.startsWith("*/") || !string2.equals(string4.substring(2)) && !string2.endsWith(string4.substring(1)) || string4.length() <= string3.length()) continue;
                list = this.lookup(string, string4);
                string3 = string4;
            }
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public List rules() {
        return this.rules;
    }

    protected List lookup(String string, String string2) {
        List list = (List)this.cache.get(string2);
        if (list == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return list;
        }
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (Rule rule : list) {
            if (!string.equals(rule.getNamespaceURI()) && rule.getNamespaceURI() != null) continue;
            arrayList.add(rule);
        }
        return arrayList;
    }
}

