/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class ModeloDeclaracao
extends ObjetoNegocio {
    public static final String LIMITE_ANUAL_27_MEIO_PORCENT = "55.976,16";
    public static final String LIMITE_ANUAL_22_MEIO_PORCENT = "45.012,60";
    public static final String LIMITE_ANUAL_15_PORCENT = "33.919,80";
    public static final String LIMITE_ANUAL_7_MEIO_PORCENT = "26.963,20";
    public static final String DESCONTO_27_MEIO_PORCENT = "10.740,98";
    public static final String DESCONTO_22_MEIO_PORCENT = "7.942,17";
    public static final String DESCONTO_15_PORCENT = "4.566,23";
    public static final String DESCONTO_7_MEIO_PORCENT = "2.022,24";
    public static final String NOME_TOTAL_REND_RECEB_MAIS_EXTERIOR = "Total de Rendimentos Recebidos";
    public static final String NOME_TOTAL_LIVRO_CAIXA_TIT_DEP = "Total Livro Caixa - TIT + DEP";
    protected DeclaracaoIRPF declaracaoIRPF = null;
    protected Valor impostoDevido = new Valor(this, "");
    protected Valor impostoDevidoII = new Valor(this, "");
    protected Valor aliquotaEfetiva = new Valor(this, "");
    protected Valor baseCalculo = new Valor(this, "");
    protected Valor saldoImpostoPagar = new Valor(this, "");
    protected Valor impostoRestituir = new Valor(this, "");
    protected Valor rendRecebidoExterior = new Valor(this, "");
    protected Valor totalRendRecebidosMaisExterior = new Valor(this, "Total de Rendimentos Recebidos");
    protected Valor totalLivroCaixa = new Valor(this, "Total Livro Caixa - TIT + DEP");
    protected Valor totalDoacoesCampanhasEleitorais = new Valor(this, "");

    public ModeloDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        this.declaracaoIRPF = declaracaoIRPF;
        this.aliquotaEfetiva.setPorcentagem(true);
        this.totalRendRecebidosMaisExterior.setReadOnly(true);
    }

    public Valor getTotalRendRecebidosMaisExterior() {
        return this.totalRendRecebidosMaisExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor calculaImposto(Valor valor) {
        Valor valor2 = new Valor();
        if (valor.comparacao("<=", LIMITE_ANUAL_7_MEIO_PORCENT)) {
            valor2.clear();
        } else if (valor.comparacao("<=", LIMITE_ANUAL_15_PORCENT)) {
            Valor valor3 = new Valor();
            valor3.setConteudo(valor);
            valor3.converteQtdCasasDecimais(3);
            valor3.setConteudo(valor3.operacao('*', "0,075"));
            valor3.append('-', DESCONTO_7_MEIO_PORCENT);
            valor3.converteQtdCasasDecimais(2);
            valor2.setConteudo(valor3);
        } else if (valor.comparacao("<=", LIMITE_ANUAL_22_MEIO_PORCENT)) {
            Valor valor4 = new Valor();
            valor4.setConteudo(valor);
            valor4.converteQtdCasasDecimais(3);
            valor4.setConteudo(valor4.operacao('*', "0,15"));
            valor4.append('-', DESCONTO_15_PORCENT);
            valor4.converteQtdCasasDecimais(2);
            valor2.setConteudo(valor4);
        } else if (valor.comparacao("<=", LIMITE_ANUAL_27_MEIO_PORCENT)) {
            Valor valor5 = new Valor();
            valor5.setConteudo(valor);
            valor5.converteQtdCasasDecimais(3);
            valor5.setConteudo(valor5.operacao('*', "0,225"));
            valor5.append('-', DESCONTO_22_MEIO_PORCENT);
            valor5.converteQtdCasasDecimais(2);
            valor2.setConteudo(valor5);
        } else {
            Valor valor6 = new Valor();
            valor6.setConteudo(valor);
            valor6.converteQtdCasasDecimais(3);
            valor6.setConteudo(valor6.operacao('*', "0,275"));
            valor6.append('-', DESCONTO_27_MEIO_PORCENT);
            valor6.converteQtdCasasDecimais(2);
            valor2.setConteudo(valor6);
        }
        return valor2;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getBaseCalculo() {
        return this.baseCalculo;
    }

    public Valor getAliquotaEfetiva() {
        return this.aliquotaEfetiva;
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getRendRecebidoExterior() {
        return this.rendRecebidoExterior;
    }

    public abstract void resumoRendimentosTributaveis();

    public abstract void resumoCalculoImposto();

    public abstract void resumoOutrasInformacoes();

    public abstract void aplicaValoresNaDeclaracao();

    public abstract Valor recuperarTotalRendimentosTributaveis();

    public abstract Valor recuperarTotalImpostoPago();

    public String recuperarCodInImpostoAntecipado() {
        String string = "0";
        if (!(this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio())) {
            string = "1";
        }
        return string;
    }

    public abstract String recuperarCodInImpostoPago();

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }
}

