/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.TrataErroSistemicoIf;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioTabelasBasicasXML;

public abstract class CadastroTabelasIRPF {
    private static RepositorioTabelasBasicasIf repositorioTabelasBasicas = new RepositorioTabelasBasicasXML();
    private static TrataErroSistemicoIf trataErro = FabricaTratamentoErro.getTrataErroSistemico();
    private static boolean testarCRC = true;
    private static Hashtable tabelaMunicipios = new Hashtable();
    private static List colecaoUFs;
    private static List colecaoPaises;
    private static List colecaoPaisesExterior;
    private static List colecaoTipoBens;
    private static List colecaoGrupoBens;
    private static List colecaoTipoBensAR;
    private static List colecaoTipoDividas;
    private static List colecaoTipoPagamentos;
    private static List colecaoDependencias;
    private static List colecaoTipoAtividadesRural;
    private static List colecaoCondicoesExploracao;
    private static List colecaoOcupacoesPrincipal;
    private static List colecaoBancos;
    private static List colecaoBancosDebito;
    private static List colecaoNaturezasOcupacao;
    private static List colecaoRepresentacoes;
    private static List colecaoMunicipios;
    private static List colecaoTipoLogradouro;

    public static List recuperarUFs(int n) {
        try {
            if (colecaoUFs == null) {
                colecaoUFs = repositorioTabelasBasicas.recuperarObjetosTabela("ufssigla.xml", testarCRC);
            }
            CadastroTabelasIRPF.ordenarElementosPorColuna(n, colecaoUFs);
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoUFs;
    }

    public static void salvarUFs() {
        colecaoUFs = null;
        try {
            repositorioTabelasBasicas.salvar("ufssigla.xml", CadastroTabelasIRPF.recuperarUFs(1));
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static void salvarPaises() {
        colecaoUFs = null;
        try {
            repositorioTabelasBasicas.salvar("paises.xml", CadastroTabelasIRPF.recuperarPaises());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static List recuperarPaises() {
        try {
            if (colecaoPaises == null) {
                colecaoPaises = repositorioTabelasBasicas.recuperarObjetosTabela("paises.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoPaises;
    }

    public static List recuperarPaisesExterior() {
        if (colecaoPaisesExterior == null) {
            colecaoPaisesExterior = new Vector();
            colecaoPaisesExterior.addAll(CadastroTabelasIRPF.recuperarPaises());
            colecaoPaisesExterior.remove(0);
        }
        return colecaoPaisesExterior;
    }

    public static List recuperarTipoBens() {
        try {
            if (colecaoTipoBens == null) {
                colecaoTipoBens = repositorioTabelasBasicas.recuperarObjetosTabela("tipoBens.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoBens;
    }

    public static List recuperarGrupoBens() {
        if (colecaoGrupoBens == null) {
            CadastroTabelasIRPF.recuperarTipoBens();
            colecaoGrupoBens = new Vector();
            Object var0 = null;
            int n = 0;
            while (n < colecaoTipoBens.size()) {
                ElementoTabela elementoTabela = (ElementoTabela)colecaoTipoBens.get(n);
                String string = elementoTabela.getConteudo(3);
                if (!string.equals(var0)) {
                    String string2 = elementoTabela.getConteudo(4);
                    ElementoTabela elementoTabela2 = new ElementoTabela();
                    elementoTabela2.setConteudo(0, string);
                    elementoTabela2.setConteudo(1, string2);
                    colecaoGrupoBens.add(elementoTabela2);
                }
                ++n;
            }
        }
        return colecaoGrupoBens;
    }

    public static List recuperarTipoBensAR() {
        try {
            if (colecaoTipoBensAR == null) {
                colecaoTipoBensAR = repositorioTabelasBasicas.recuperarObjetosTabela("tipoBensAR.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoBensAR;
    }

    public static List recuperarTipoDividas() {
        try {
            if (colecaoTipoDividas == null) {
                colecaoTipoDividas = repositorioTabelasBasicas.recuperarObjetosTabela("tipoDividas.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoDividas;
    }

    public static List recuperarTipoPagamentos() {
        try {
            if (colecaoTipoPagamentos == null) {
                colecaoTipoPagamentos = repositorioTabelasBasicas.recuperarObjetosTabela("tipoPagamentos.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoPagamentos;
    }

    public static List recuperarDependencias() {
        try {
            if (colecaoDependencias == null) {
                colecaoDependencias = repositorioTabelasBasicas.recuperarObjetosTabela("dependencias.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoDependencias;
    }

    public static void salvarDependencias() {
        colecaoDependencias = null;
        try {
            repositorioTabelasBasicas.salvar("dependencias.xml", CadastroTabelasIRPF.recuperarDependencias());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static List recuperarTipoAtividadesRural() {
        try {
            if (colecaoTipoAtividadesRural == null) {
                colecaoTipoAtividadesRural = repositorioTabelasBasicas.recuperarObjetosTabela("tipoAtividadesRural.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoAtividadesRural;
    }

    public static List recuperarCondicoesExploracao() {
        try {
            if (colecaoCondicoesExploracao == null) {
                colecaoCondicoesExploracao = repositorioTabelasBasicas.recuperarObjetosTabela("condicoesExploracao.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoCondicoesExploracao;
    }

    public static void salvarCondicoesExploracao() {
        colecaoCondicoesExploracao = null;
        try {
            repositorioTabelasBasicas.salvar("condicoesExploracao.xml", CadastroTabelasIRPF.recuperarCondicoesExploracao());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static List recuperarOcupacoesPrincipal() {
        try {
            if (colecaoOcupacoesPrincipal == null) {
                colecaoOcupacoesPrincipal = repositorioTabelasBasicas.recuperarObjetosTabela("ocupacoesPrincipal.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoOcupacoesPrincipal;
    }

    public static List recuperarBancos() {
        try {
            if (colecaoBancos == null) {
                colecaoBancos = repositorioTabelasBasicas.recuperarObjetosTabela("bancos.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoBancos;
    }

    public static List recuperarBancosDebito() {
        try {
            if (colecaoBancosDebito == null) {
                colecaoBancosDebito = repositorioTabelasBasicas.recuperarObjetosTabela("bancos_debito.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoBancosDebito;
    }

    public static List recuperarNaturezasOcupacao() {
        try {
            if (colecaoNaturezasOcupacao == null) {
                colecaoNaturezasOcupacao = repositorioTabelasBasicas.recuperarObjetosTabela("naturezasOcupacao.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoNaturezasOcupacao;
    }

    public static void salvarNaturezasOcupacao() {
        colecaoNaturezasOcupacao = null;
        try {
            repositorioTabelasBasicas.salvar("naturezasOcupacao.xml", CadastroTabelasIRPF.recuperarNaturezasOcupacao());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static void salvarBancos() {
        colecaoBancos = null;
        try {
            repositorioTabelasBasicas.salvar("bancos.xml", CadastroTabelasIRPF.recuperarBancos());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static void salvarBancosDebito() {
        colecaoBancosDebito = null;
        try {
            repositorioTabelasBasicas.salvar("bancos_debito.xml", CadastroTabelasIRPF.recuperarBancosDebito());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static void salvarTipoPagamento() {
        colecaoTipoPagamentos = null;
        try {
            repositorioTabelasBasicas.salvar("tipoPagamentos.xml", CadastroTabelasIRPF.recuperarTipoPagamentos());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static List recuperarRepresentacoes() {
        try {
            if (colecaoRepresentacoes == null) {
                colecaoRepresentacoes = repositorioTabelasBasicas.recuperarObjetosTabela("representacoes.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoRepresentacoes;
    }

    public static List recuperarMunicipios(String string, int n) {
        try {
            if (tabelaMunicipios.containsKey(string)) {
                return (List)tabelaMunicipios.get(string);
            }
            List list = repositorioTabelasBasicas.recuperarObjetosTabela(String.valueOf(string) + ".xml", testarCRC);
            CadastroTabelasIRPF.ordenarElementosPorColuna(n, list);
            tabelaMunicipios.put(string, list);
            return list;
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
            return colecaoRepresentacoes;
        }
    }

    public static boolean isTestarCRC() {
        return testarCRC;
    }

    public static void setTestarCRC(boolean bl) {
        testarCRC = bl;
    }

    private static void gravaAtributo(String string, String string2, String string3, String string4) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.out.println("XML: " + string);
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object4 = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object4).parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object4 = document.getElementsByTagName("ITEM");
        int n = 0;
        while (n < object4.getLength()) {
            object3 = (Element)object4.item(n);
            if (object3.getAttribute("COL1").equals(string2)) {
                object2 = object3.getAttribute("COL3");
                if (object2 == null || ((String)object2).trim().length() == 0) {
                    object2 = String.valueOf(string3) + "-" + string4;
                } else {
                    object = String.valueOf(string3) + "-" + string4;
                    if (((String)object2).indexOf((String)object) < 0) {
                        object2 = String.valueOf(object2) + "," + (String)object;
                    }
                }
                object3.setAttribute("COL3", (String)object2);
                break;
            }
            ++n;
        }
        DOMSource dOMSource = new DOMSource(document);
        object3 = new File(string);
        object2 = new StreamResult((File)object3);
        try {
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).setOutputProperty("method", "xml");
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform(dOMSource, (Result)object2);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        CadastroTabelasIRPF.setTestarCRC(false);
        CadastroTabelasIRPF.salvarBancosDebito();
    }

    private static void ordenarElementosPorColuna(final int n, List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                ElementoTabela elementoTabela = (ElementoTabela)object;
                ElementoTabela elementoTabela2 = (ElementoTabela)object2;
                if (n >= elementoTabela.size()) {
                    return UtilitariosString.removeAcentos(elementoTabela.getConteudo(0)).compareTo(UtilitariosString.removeAcentos(elementoTabela2.getConteudo(0)));
                }
                return UtilitariosString.removeAcentos(elementoTabela.getConteudo(n)).compareTo(UtilitariosString.removeAcentos(elementoTabela2.getConteudo(n)));
            }
        });
    }

    public static List recuperarMeses() {
        Vector<ElementoTabela> vector = new Vector<ElementoTabela>();
        ElementoTabela elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Janeiro");
        vector.add(0, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Fevereiro");
        vector.add(1, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Mar\u00e7o");
        vector.add(2, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Abril");
        vector.add(3, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Maio");
        vector.add(4, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Junho");
        vector.add(5, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Julho");
        vector.add(6, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Agosto");
        vector.add(7, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Setembro");
        vector.add(8, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Outubro");
        vector.add(9, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Novembro");
        vector.add(10, elementoTabela);
        elementoTabela = new ElementoTabela();
        elementoTabela.setConteudo(0, "Dezembro");
        vector.add(11, elementoTabela);
        return vector;
    }

    public static void salvarTiposLogradouro() {
        colecaoTipoLogradouro = null;
        try {
            repositorioTabelasBasicas.salvar("tipoLogradouro.xml", CadastroTabelasIRPF.recuperarTiposLogradouro());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public static List recuperarTiposLogradouro() {
        try {
            if (colecaoTipoLogradouro == null) {
                colecaoTipoLogradouro = repositorioTabelasBasicas.recuperarObjetosTabela("tipoLogradouro.xml", testarCRC);
            }
        }
        catch (RepositorioException repositorioException) {
            trataErro.trataErroSistemico(repositorioException);
        }
        return colecaoTipoLogradouro;
    }
}

