#ifndef _visit_node_h
#define _visit_node_h

// $Id: visit_node.h,v 1.1 1998/11/27 20:09:49 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/** This is a base class for node types, that introduces the ability
    of controlling visitation of a node.  This feature is needed by
    the Topological Scan algorithms.  */
class visit_node {
 private:
  /** `not_visited' means the node was never visited or was unvisited;
      `visiting' means it is currently being visited; `visit_finished'
      means it is no longer being visited, but it was nor unvisited
      yet.  */
  enum { not_visited, visiting, visit_finished } status;

 protected:
  /** Ensure that this is only used as a base class.  Initializes
      state as not_visited.  */
  visit_node() : status(not_visited) {}

 public:
  /** Start visitation, i.e., mark node as `visiting' and return
      false, unless it was not in the `not_visited' state.  In this
      case, return true.  */
  bool visit() {
    if (status != not_visited)
      return true;
    status = visiting;
    return false;
  }

  /** Terminate visit to the node, marking it with `visit_finished'.  */
  void visited() {
    status = visit_finished;
  }

  /** Reset visitation mark.  */
  void unvisit() {
    status = not_visited;
  }
};

#endif
